// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

public sealed partial class UpdateInferenceRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Update an inference endpoint.
/// </para>
/// <para>
/// Modify <c>task_settings</c>, secrets (within <c>service_settings</c>), or <c>num_allocations</c> for an inference endpoint, depending on the specific endpoint service and <c>task_type</c>.
/// </para>
/// <para>
/// IMPORTANT: The inference APIs enable you to use certain services, such as built-in machine learning models (ELSER, E5), models uploaded through Eland, Cohere, OpenAI, Azure, Google AI Studio, Google Vertex AI, Anthropic, Watsonx.ai, or Hugging Face.
/// For built-in models and models uploaded through Eland, the inference APIs offer an alternative way to use and manage trained models.
/// However, if you do not plan to use the inference APIs to use these models or if you want to use non-NLP models, use the machine learning trained model APIs.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.UpdateInferenceRequestConverter))]
public sealed partial class UpdateInferenceRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateInferenceRequest(Elastic.Clients.Elasticsearch.Id inferenceId) : base(r => r.Required("inference_id", inferenceId))
	{
	}

	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateInferenceRequest(Elastic.Clients.Elasticsearch.Inference.TaskType? taskType, Elastic.Clients.Elasticsearch.Id inferenceId) : base(r => r.Optional("task_type", taskType).Required("inference_id", inferenceId))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateInferenceRequest(Elastic.Clients.Elasticsearch.Id inferenceId, Elastic.Clients.Elasticsearch.Inference.InferenceEndpoint inferenceConfig) : base(r => r.Required("inference_id", inferenceId))
	{
		InferenceConfig = inferenceConfig;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateInferenceRequest(Elastic.Clients.Elasticsearch.Inference.TaskType? taskType, Elastic.Clients.Elasticsearch.Id inferenceId, Elastic.Clients.Elasticsearch.Inference.InferenceEndpoint inferenceConfig) : base(r => r.Optional("task_type", taskType).Required("inference_id", inferenceId))
	{
		InferenceConfig = inferenceConfig;
	}
#if NET7_0_OR_GREATER
	public UpdateInferenceRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal UpdateInferenceRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.InferenceUpdate;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "inference.update";

	/// <summary>
	/// <para>
	/// The unique identifier of the inference endpoint.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id InferenceId { get => P<Elastic.Clients.Elasticsearch.Id>("inference_id"); set => PR("inference_id", value); }

	/// <summary>
	/// <para>
	/// The type of inference task that the model performs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.TaskType? TaskType { get => P<Elastic.Clients.Elasticsearch.Inference.TaskType?>("task_type"); set => PO("task_type", value); }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Inference.InferenceEndpoint InferenceConfig { get; set; }
}

/// <summary>
/// <para>
/// Update an inference endpoint.
/// </para>
/// <para>
/// Modify <c>task_settings</c>, secrets (within <c>service_settings</c>), or <c>num_allocations</c> for an inference endpoint, depending on the specific endpoint service and <c>task_type</c>.
/// </para>
/// <para>
/// IMPORTANT: The inference APIs enable you to use certain services, such as built-in machine learning models (ELSER, E5), models uploaded through Eland, Cohere, OpenAI, Azure, Google AI Studio, Google Vertex AI, Anthropic, Watsonx.ai, or Hugging Face.
/// For built-in models and models uploaded through Eland, the inference APIs offer an alternative way to use and manage trained models.
/// However, if you do not plan to use the inference APIs to use these models or if you want to use non-NLP models, use the machine learning trained model APIs.
/// </para>
/// </summary>
public readonly partial struct UpdateInferenceRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateInferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequest instance)
	{
		Instance = instance;
	}

	public UpdateInferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Id inferenceId)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequest(inferenceId);
#pragma warning restore CS0618
	}

	public UpdateInferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.TaskType? taskType, Elastic.Clients.Elasticsearch.Id inferenceId)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequest(taskType, inferenceId);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public UpdateInferenceRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequest instance) => new Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequest(Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The unique identifier of the inference endpoint.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequestDescriptor InferenceId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.InferenceId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of inference task that the model performs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequestDescriptor TaskType(Elastic.Clients.Elasticsearch.Inference.TaskType? value)
	{
		Instance.TaskType = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequestDescriptor InferenceConfig(Elastic.Clients.Elasticsearch.Inference.InferenceEndpoint value)
	{
		Instance.InferenceConfig = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequestDescriptor InferenceConfig(System.Action<Elastic.Clients.Elasticsearch.Inference.InferenceEndpointDescriptor> action)
	{
		Instance.InferenceConfig = Elastic.Clients.Elasticsearch.Inference.InferenceEndpointDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequest Build(System.Action<Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequestDescriptor(new Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.UpdateInferenceRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}