// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

public sealed partial class TextEmbeddingRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference request to complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Perform text embedding inference on the service
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.TextEmbeddingRequestConverter))]
public sealed partial class TextEmbeddingRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TextEmbeddingRequest(Elastic.Clients.Elasticsearch.Id inferenceId) : base(r => r.Required("inference_id", inferenceId))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TextEmbeddingRequest(Elastic.Clients.Elasticsearch.Id inferenceId, System.Collections.Generic.ICollection<string> input) : base(r => r.Required("inference_id", inferenceId))
	{
		Input = input;
	}
#if NET7_0_OR_GREATER
	public TextEmbeddingRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TextEmbeddingRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.InferenceTextEmbedding;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "inference.text_embedding";

	/// <summary>
	/// <para>
	/// The inference Id
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id InferenceId { get => P<Elastic.Clients.Elasticsearch.Id>("inference_id"); set => PR("inference_id", value); }

	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference request to complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// Inference input.
	/// Either a string or an array of strings.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<string> Input { get; set; }

	/// <summary>
	/// <para>
	/// The input data type for the text embedding model. Possible values include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>SEARCH</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>INGEST</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>CLASSIFICATION</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>CLUSTERING</c>
	/// Not all services support all values. Unsupported values will trigger a validation exception.
	/// Accepted values depend on the configured inference service, refer to the relevant service-specific documentation for more info.
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// info
	/// The <c>input_type</c> parameter specified on the root level of the request body will take precedence over the <c>input_type</c> parameter specified in <c>task_settings</c>.
	/// </para>
	/// </summary>
	public string? InputType { get; set; }

	/// <summary>
	/// <para>
	/// Optional task settings
	/// </para>
	/// </summary>
	public object? TaskSettings { get; set; }
}

/// <summary>
/// <para>
/// Perform text embedding inference on the service
/// </para>
/// </summary>
public readonly partial struct TextEmbeddingRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TextEmbeddingRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequest instance)
	{
		Instance = instance;
	}

	public TextEmbeddingRequestDescriptor(Elastic.Clients.Elasticsearch.Id inferenceId)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequest(inferenceId);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public TextEmbeddingRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequest instance) => new Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequest(Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The inference Id
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequestDescriptor InferenceId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.InferenceId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference request to complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Inference input.
	/// Either a string or an array of strings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequestDescriptor Input(System.Collections.Generic.ICollection<string> value)
	{
		Instance.Input = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Inference input.
	/// Either a string or an array of strings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequestDescriptor Input(params string[] values)
	{
		Instance.Input = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The input data type for the text embedding model. Possible values include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>SEARCH</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>INGEST</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>CLASSIFICATION</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>CLUSTERING</c>
	/// Not all services support all values. Unsupported values will trigger a validation exception.
	/// Accepted values depend on the configured inference service, refer to the relevant service-specific documentation for more info.
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// info
	/// The <c>input_type</c> parameter specified on the root level of the request body will take precedence over the <c>input_type</c> parameter specified in <c>task_settings</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequestDescriptor InputType(string? value)
	{
		Instance.InputType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional task settings
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequestDescriptor TaskSettings(object? value)
	{
		Instance.TaskSettings = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequest Build(System.Action<Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequestDescriptor(new Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.TextEmbeddingRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}