// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

public sealed partial class SparseEmbeddingRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference request to complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Perform sparse embedding inference on the service
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.SparseEmbeddingRequestConverter))]
public sealed partial class SparseEmbeddingRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SparseEmbeddingRequest(Elastic.Clients.Elasticsearch.Id inferenceId) : base(r => r.Required("inference_id", inferenceId))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SparseEmbeddingRequest(Elastic.Clients.Elasticsearch.Id inferenceId, System.Collections.Generic.ICollection<string> input) : base(r => r.Required("inference_id", inferenceId))
	{
		Input = input;
	}
#if NET7_0_OR_GREATER
	public SparseEmbeddingRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SparseEmbeddingRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.InferenceSparseEmbedding;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "inference.sparse_embedding";

	/// <summary>
	/// <para>
	/// The inference Id
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id InferenceId { get => P<Elastic.Clients.Elasticsearch.Id>("inference_id"); set => PR("inference_id", value); }

	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference request to complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// Inference input.
	/// Either a string or an array of strings.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<string> Input { get; set; }

	/// <summary>
	/// <para>
	/// Optional task settings
	/// </para>
	/// </summary>
	public object? TaskSettings { get; set; }
}

/// <summary>
/// <para>
/// Perform sparse embedding inference on the service
/// </para>
/// </summary>
public readonly partial struct SparseEmbeddingRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SparseEmbeddingRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequest instance)
	{
		Instance = instance;
	}

	public SparseEmbeddingRequestDescriptor(Elastic.Clients.Elasticsearch.Id inferenceId)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequest(inferenceId);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public SparseEmbeddingRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequest instance) => new Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequest(Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The inference Id
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequestDescriptor InferenceId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.InferenceId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference request to complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Inference input.
	/// Either a string or an array of strings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequestDescriptor Input(System.Collections.Generic.ICollection<string> value)
	{
		Instance.Input = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Inference input.
	/// Either a string or an array of strings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequestDescriptor Input(params string[] values)
	{
		Instance.Input = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional task settings
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequestDescriptor TaskSettings(object? value)
	{
		Instance.TaskSettings = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequest Build(System.Action<Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequestDescriptor(new Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.SparseEmbeddingRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}