// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

public sealed partial class PutInferenceRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference endpoint to be created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Create an inference endpoint.
/// </para>
/// <para>
/// IMPORTANT: The inference APIs enable you to use certain services, such as built-in machine learning models (ELSER, E5), models uploaded through Eland, Cohere, OpenAI, Mistral, Azure OpenAI, Google AI Studio, Google Vertex AI, Anthropic, Watsonx.ai, or Hugging Face.
/// For built-in models and models uploaded through Eland, the inference APIs offer an alternative way to use and manage trained models.
/// However, if you do not plan to use the inference APIs to use these models or if you want to use non-NLP models, use the machine learning trained model APIs.
/// </para>
/// <para>
/// The following integrations are available through the inference API. You can find the available task types next to the integration name:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// AlibabaCloud AI Search (<c>completion</c>, <c>rerank</c>, <c>sparse_embedding</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Amazon Bedrock (<c>completion</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Amazon SageMaker (<c>chat_completion</c>, <c>completion</c>, <c>rerank</c>, <c>sparse_embedding</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Anthropic (<c>completion</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Azure AI Studio (<c>completion</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Azure OpenAI (<c>completion</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Cohere (<c>completion</c>, <c>rerank</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// DeepSeek (<c>chat_completion</c>, <c>completion</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Elasticsearch (<c>rerank</c>, <c>sparse_embedding</c>, <c>text_embedding</c> - this service is for built-in models and models uploaded through Eland)
/// </para>
/// </item>
/// <item>
/// <para>
/// ELSER (<c>sparse_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Google AI Studio (<c>completion</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Google Vertex AI (<c>chat_completion</c>, <c>completion</c>, <c>rerank</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Hugging Face (<c>chat_completion</c>, <c>completion</c>, <c>rerank</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// JinaAI (<c>rerank</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Llama (<c>chat_completion</c>, <c>completion</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Mistral (<c>chat_completion</c>, <c>completion</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// OpenAI (<c>chat_completion</c>, <c>completion</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// VoyageAI (<c>rerank</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Watsonx inference integration (<c>text_embedding</c>)
/// </para>
/// </item>
/// </list>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.PutInferenceRequestConverter))]
public sealed partial class PutInferenceRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Inference.PutInferenceRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutInferenceRequest(Elastic.Clients.Elasticsearch.Id inferenceId) : base(r => r.Required("inference_id", inferenceId))
	{
	}

	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutInferenceRequest(Elastic.Clients.Elasticsearch.Inference.TaskType? taskType, Elastic.Clients.Elasticsearch.Id inferenceId) : base(r => r.Optional("task_type", taskType).Required("inference_id", inferenceId))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutInferenceRequest(Elastic.Clients.Elasticsearch.Id inferenceId, Elastic.Clients.Elasticsearch.Inference.InferenceEndpoint inferenceConfig) : base(r => r.Required("inference_id", inferenceId))
	{
		InferenceConfig = inferenceConfig;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutInferenceRequest(Elastic.Clients.Elasticsearch.Inference.TaskType? taskType, Elastic.Clients.Elasticsearch.Id inferenceId, Elastic.Clients.Elasticsearch.Inference.InferenceEndpoint inferenceConfig) : base(r => r.Optional("task_type", taskType).Required("inference_id", inferenceId))
	{
		InferenceConfig = inferenceConfig;
	}
#if NET7_0_OR_GREATER
	public PutInferenceRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutInferenceRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.InferencePut;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "inference.put";

	/// <summary>
	/// <para>
	/// The inference Id
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id InferenceId { get => P<Elastic.Clients.Elasticsearch.Id>("inference_id"); set => PR("inference_id", value); }

	/// <summary>
	/// <para>
	/// The task type. Refer to the integration list in the API description for the available task types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.TaskType? TaskType { get => P<Elastic.Clients.Elasticsearch.Inference.TaskType?>("task_type"); set => PO("task_type", value); }

	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference endpoint to be created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Inference.InferenceEndpoint InferenceConfig { get; set; }
}

/// <summary>
/// <para>
/// Create an inference endpoint.
/// </para>
/// <para>
/// IMPORTANT: The inference APIs enable you to use certain services, such as built-in machine learning models (ELSER, E5), models uploaded through Eland, Cohere, OpenAI, Mistral, Azure OpenAI, Google AI Studio, Google Vertex AI, Anthropic, Watsonx.ai, or Hugging Face.
/// For built-in models and models uploaded through Eland, the inference APIs offer an alternative way to use and manage trained models.
/// However, if you do not plan to use the inference APIs to use these models or if you want to use non-NLP models, use the machine learning trained model APIs.
/// </para>
/// <para>
/// The following integrations are available through the inference API. You can find the available task types next to the integration name:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// AlibabaCloud AI Search (<c>completion</c>, <c>rerank</c>, <c>sparse_embedding</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Amazon Bedrock (<c>completion</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Amazon SageMaker (<c>chat_completion</c>, <c>completion</c>, <c>rerank</c>, <c>sparse_embedding</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Anthropic (<c>completion</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Azure AI Studio (<c>completion</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Azure OpenAI (<c>completion</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Cohere (<c>completion</c>, <c>rerank</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// DeepSeek (<c>chat_completion</c>, <c>completion</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Elasticsearch (<c>rerank</c>, <c>sparse_embedding</c>, <c>text_embedding</c> - this service is for built-in models and models uploaded through Eland)
/// </para>
/// </item>
/// <item>
/// <para>
/// ELSER (<c>sparse_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Google AI Studio (<c>completion</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Google Vertex AI (<c>chat_completion</c>, <c>completion</c>, <c>rerank</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Hugging Face (<c>chat_completion</c>, <c>completion</c>, <c>rerank</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// JinaAI (<c>rerank</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Llama (<c>chat_completion</c>, <c>completion</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Mistral (<c>chat_completion</c>, <c>completion</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// OpenAI (<c>chat_completion</c>, <c>completion</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// VoyageAI (<c>rerank</c>, <c>text_embedding</c>)
/// </para>
/// </item>
/// <item>
/// <para>
/// Watsonx inference integration (<c>text_embedding</c>)
/// </para>
/// </item>
/// </list>
/// </summary>
public readonly partial struct PutInferenceRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.PutInferenceRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutInferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.PutInferenceRequest instance)
	{
		Instance = instance;
	}

	public PutInferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Id inferenceId)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Inference.PutInferenceRequest(inferenceId);
#pragma warning restore CS0618
	}

	public PutInferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.TaskType? taskType, Elastic.Clients.Elasticsearch.Id inferenceId)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Inference.PutInferenceRequest(taskType, inferenceId);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutInferenceRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.PutInferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.PutInferenceRequest instance) => new Elastic.Clients.Elasticsearch.Inference.PutInferenceRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.PutInferenceRequest(Elastic.Clients.Elasticsearch.Inference.PutInferenceRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The inference Id
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutInferenceRequestDescriptor InferenceId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.InferenceId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The task type. Refer to the integration list in the API description for the available task types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutInferenceRequestDescriptor TaskType(Elastic.Clients.Elasticsearch.Inference.TaskType? value)
	{
		Instance.TaskType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference endpoint to be created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutInferenceRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutInferenceRequestDescriptor InferenceConfig(Elastic.Clients.Elasticsearch.Inference.InferenceEndpoint value)
	{
		Instance.InferenceConfig = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutInferenceRequestDescriptor InferenceConfig(System.Action<Elastic.Clients.Elasticsearch.Inference.InferenceEndpointDescriptor> action)
	{
		Instance.InferenceConfig = Elastic.Clients.Elasticsearch.Inference.InferenceEndpointDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.PutInferenceRequest Build(System.Action<Elastic.Clients.Elasticsearch.Inference.PutInferenceRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.PutInferenceRequestDescriptor(new Elastic.Clients.Elasticsearch.Inference.PutInferenceRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutInferenceRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutInferenceRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutInferenceRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutInferenceRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutInferenceRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutInferenceRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutInferenceRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}