// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

public sealed partial class PutCustomRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Create a custom inference endpoint.
/// </para>
/// <para>
/// The custom service gives more control over how to interact with external inference services that aren't explicitly supported through dedicated integrations.
/// The custom service gives you the ability to define the headers, url, query parameters, request body, and secrets.
/// The custom service supports the template replacement functionality, which enables you to define a template that can be replaced with the value associated with that key.
/// Templates are portions of a string that start with <c>${</c> and end with <c>}</c>.
/// The parameters <c>secret_parameters</c> and <c>task_settings</c> are checked for keys for template replacement. Template replacement is supported in the <c>request</c>, <c>headers</c>, <c>url</c>, and <c>query_parameters</c>.
/// If the definition (key) is not found for a template, an error message is returned.
/// In case of an endpoint definition like the following:
/// </para>
/// <code>
/// PUT _inference/text_embedding/test-text-embedding
/// {
///   "service": "custom",
///   "service_settings": {
///      "secret_parameters": {
///           "api_key": "&lt;some api key>"
///      },
///      "url": "...endpoints.huggingface.cloud/v1/embeddings",
///      "headers": {
///          "Authorization": "Bearer ${api_key}",
///          "Content-Type": "application/json"
///      },
///      "request": "{\"input\": ${input}}",
///      "response": {
///          "json_parser": {
///              "text_embeddings":"$.data[*].embedding[*]"
///          }
///      }
///   }
/// }
/// </code>
/// <para>
/// To replace <c>${api_key}</c> the <c>secret_parameters</c> and <c>task_settings</c> are checked for a key named <c>api_key</c>.
/// </para>
/// <para>
/// info
/// Templates should not be surrounded by quotes.
/// </para>
/// <para>
/// Pre-defined templates:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// <c>${input}</c> refers to the array of input strings that comes from the <c>input</c> field of the subsequent inference requests.
/// </para>
/// </item>
/// <item>
/// <para>
/// <c>${input_type}</c> refers to the input type translation values.
/// </para>
/// </item>
/// <item>
/// <para>
/// <c>${query}</c> refers to the query field used specifically for reranking tasks.
/// </para>
/// </item>
/// <item>
/// <para>
/// <c>${top_n}</c> refers to the <c>top_n</c> field available when performing rerank requests.
/// </para>
/// </item>
/// <item>
/// <para>
/// <c>${return_documents}</c> refers to the <c>return_documents</c> field available when performing rerank requests.
/// </para>
/// </item>
/// </list>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.PutCustomRequestConverter))]
public sealed partial class PutCustomRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Inference.PutCustomRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutCustomRequest(Elastic.Clients.Elasticsearch.Inference.CustomTaskType taskType, Elastic.Clients.Elasticsearch.Id customInferenceId) : base(r => r.Required("task_type", taskType).Required("custom_inference_id", customInferenceId))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutCustomRequest(Elastic.Clients.Elasticsearch.Inference.CustomTaskType taskType, Elastic.Clients.Elasticsearch.Id customInferenceId, Elastic.Clients.Elasticsearch.Inference.CustomServiceSettings serviceSettings) : base(r => r.Required("task_type", taskType).Required("custom_inference_id", customInferenceId))
	{
		ServiceSettings = serviceSettings;
	}
#if NET7_0_OR_GREATER
	public PutCustomRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutCustomRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.InferencePutCustom;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "inference.put_custom";

	/// <summary>
	/// <para>
	/// The unique identifier of the inference endpoint.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id CustomInferenceId { get => P<Elastic.Clients.Elasticsearch.Id>("custom_inference_id"); set => PR("custom_inference_id", value); }

	/// <summary>
	/// <para>
	/// The type of the inference task that the model will perform.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Inference.CustomTaskType TaskType { get => P<Elastic.Clients.Elasticsearch.Inference.CustomTaskType>("task_type"); set => PR("task_type", value); }

	/// <summary>
	/// <para>
	/// The chunking configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettings? ChunkingSettings { get; set; }

	/// <summary>
	/// <para>
	/// The type of service supported for the specified task type. In this case, <c>custom</c>.
	/// </para>
	/// </summary>
	public string Service => "custom";

	/// <summary>
	/// <para>
	/// Settings used to install the inference model.
	/// These settings are specific to the <c>custom</c> service.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Inference.CustomServiceSettings ServiceSettings { get; set; }

	/// <summary>
	/// <para>
	/// Settings to configure the inference task.
	/// These settings are specific to the task type you specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.CustomTaskSettings? TaskSettings { get; set; }
}

/// <summary>
/// <para>
/// Create a custom inference endpoint.
/// </para>
/// <para>
/// The custom service gives more control over how to interact with external inference services that aren't explicitly supported through dedicated integrations.
/// The custom service gives you the ability to define the headers, url, query parameters, request body, and secrets.
/// The custom service supports the template replacement functionality, which enables you to define a template that can be replaced with the value associated with that key.
/// Templates are portions of a string that start with <c>${</c> and end with <c>}</c>.
/// The parameters <c>secret_parameters</c> and <c>task_settings</c> are checked for keys for template replacement. Template replacement is supported in the <c>request</c>, <c>headers</c>, <c>url</c>, and <c>query_parameters</c>.
/// If the definition (key) is not found for a template, an error message is returned.
/// In case of an endpoint definition like the following:
/// </para>
/// <code>
/// PUT _inference/text_embedding/test-text-embedding
/// {
///   "service": "custom",
///   "service_settings": {
///      "secret_parameters": {
///           "api_key": "&lt;some api key>"
///      },
///      "url": "...endpoints.huggingface.cloud/v1/embeddings",
///      "headers": {
///          "Authorization": "Bearer ${api_key}",
///          "Content-Type": "application/json"
///      },
///      "request": "{\"input\": ${input}}",
///      "response": {
///          "json_parser": {
///              "text_embeddings":"$.data[*].embedding[*]"
///          }
///      }
///   }
/// }
/// </code>
/// <para>
/// To replace <c>${api_key}</c> the <c>secret_parameters</c> and <c>task_settings</c> are checked for a key named <c>api_key</c>.
/// </para>
/// <para>
/// info
/// Templates should not be surrounded by quotes.
/// </para>
/// <para>
/// Pre-defined templates:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// <c>${input}</c> refers to the array of input strings that comes from the <c>input</c> field of the subsequent inference requests.
/// </para>
/// </item>
/// <item>
/// <para>
/// <c>${input_type}</c> refers to the input type translation values.
/// </para>
/// </item>
/// <item>
/// <para>
/// <c>${query}</c> refers to the query field used specifically for reranking tasks.
/// </para>
/// </item>
/// <item>
/// <para>
/// <c>${top_n}</c> refers to the <c>top_n</c> field available when performing rerank requests.
/// </para>
/// </item>
/// <item>
/// <para>
/// <c>${return_documents}</c> refers to the <c>return_documents</c> field available when performing rerank requests.
/// </para>
/// </item>
/// </list>
/// </summary>
public readonly partial struct PutCustomRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.PutCustomRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutCustomRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.PutCustomRequest instance)
	{
		Instance = instance;
	}

	public PutCustomRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.CustomTaskType taskType, Elastic.Clients.Elasticsearch.Id customInferenceId)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Inference.PutCustomRequest(taskType, customInferenceId);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutCustomRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.PutCustomRequest instance) => new Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.PutCustomRequest(Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The unique identifier of the inference endpoint.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor CustomInferenceId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.CustomInferenceId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of the inference task that the model will perform.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor TaskType(Elastic.Clients.Elasticsearch.Inference.CustomTaskType value)
	{
		Instance.TaskType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The chunking configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor ChunkingSettings(Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettings? value)
	{
		Instance.ChunkingSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The chunking configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor ChunkingSettings()
	{
		Instance.ChunkingSettings = Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The chunking configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor ChunkingSettings(System.Action<Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor>? action)
	{
		Instance.ChunkingSettings = Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings used to install the inference model.
	/// These settings are specific to the <c>custom</c> service.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor ServiceSettings(Elastic.Clients.Elasticsearch.Inference.CustomServiceSettings value)
	{
		Instance.ServiceSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings used to install the inference model.
	/// These settings are specific to the <c>custom</c> service.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor ServiceSettings(System.Action<Elastic.Clients.Elasticsearch.Inference.CustomServiceSettingsDescriptor> action)
	{
		Instance.ServiceSettings = Elastic.Clients.Elasticsearch.Inference.CustomServiceSettingsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to configure the inference task.
	/// These settings are specific to the task type you specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor TaskSettings(Elastic.Clients.Elasticsearch.Inference.CustomTaskSettings? value)
	{
		Instance.TaskSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to configure the inference task.
	/// These settings are specific to the task type you specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor TaskSettings()
	{
		Instance.TaskSettings = Elastic.Clients.Elasticsearch.Inference.CustomTaskSettingsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to configure the inference task.
	/// These settings are specific to the task type you specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor TaskSettings(System.Action<Elastic.Clients.Elasticsearch.Inference.CustomTaskSettingsDescriptor>? action)
	{
		Instance.TaskSettings = Elastic.Clients.Elasticsearch.Inference.CustomTaskSettingsDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.PutCustomRequest Build(System.Action<Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor(new Elastic.Clients.Elasticsearch.Inference.PutCustomRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutCustomRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}