// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

public sealed partial class PutAzureaistudioRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference endpoint to be created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Create an Azure AI studio inference endpoint.
/// </para>
/// <para>
/// Create an inference endpoint to perform an inference task with the <c>azureaistudio</c> service.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.PutAzureaistudioRequestConverter))]
public sealed partial class PutAzureaistudioRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutAzureaistudioRequest(Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskType taskType, Elastic.Clients.Elasticsearch.Id azureaistudioInferenceId) : base(r => r.Required("task_type", taskType).Required("azureaistudio_inference_id", azureaistudioInferenceId))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutAzureaistudioRequest(Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskType taskType, Elastic.Clients.Elasticsearch.Id azureaistudioInferenceId, Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettings serviceSettings) : base(r => r.Required("task_type", taskType).Required("azureaistudio_inference_id", azureaistudioInferenceId))
	{
		ServiceSettings = serviceSettings;
	}
#if NET7_0_OR_GREATER
	public PutAzureaistudioRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutAzureaistudioRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.InferencePutAzureaistudio;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "inference.put_azureaistudio";

	/// <summary>
	/// <para>
	/// The unique identifier of the inference endpoint.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id AzureaistudioInferenceId { get => P<Elastic.Clients.Elasticsearch.Id>("azureaistudio_inference_id"); set => PR("azureaistudio_inference_id", value); }

	/// <summary>
	/// <para>
	/// The type of the inference task that the model will perform.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskType TaskType { get => P<Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskType>("task_type"); set => PR("task_type", value); }

	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference endpoint to be created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// The chunking configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettings? ChunkingSettings { get; set; }

	/// <summary>
	/// <para>
	/// The type of service supported for the specified task type. In this case, <c>azureaistudio</c>.
	/// </para>
	/// </summary>
	public string Service => "azureaistudio";

	/// <summary>
	/// <para>
	/// Settings used to install the inference model. These settings are specific to the <c>openai</c> service.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettings ServiceSettings { get; set; }

	/// <summary>
	/// <para>
	/// Settings to configure the inference task.
	/// These settings are specific to the task type you specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettings? TaskSettings { get; set; }
}

/// <summary>
/// <para>
/// Create an Azure AI studio inference endpoint.
/// </para>
/// <para>
/// Create an inference endpoint to perform an inference task with the <c>azureaistudio</c> service.
/// </para>
/// </summary>
public readonly partial struct PutAzureaistudioRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutAzureaistudioRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequest instance)
	{
		Instance = instance;
	}

	public PutAzureaistudioRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskType taskType, Elastic.Clients.Elasticsearch.Id azureaistudioInferenceId)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequest(taskType, azureaistudioInferenceId);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutAzureaistudioRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequest instance) => new Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequest(Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The unique identifier of the inference endpoint.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor AzureaistudioInferenceId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.AzureaistudioInferenceId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of the inference task that the model will perform.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor TaskType(Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskType value)
	{
		Instance.TaskType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference endpoint to be created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The chunking configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor ChunkingSettings(Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettings? value)
	{
		Instance.ChunkingSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The chunking configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor ChunkingSettings()
	{
		Instance.ChunkingSettings = Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The chunking configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor ChunkingSettings(System.Action<Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor>? action)
	{
		Instance.ChunkingSettings = Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings used to install the inference model. These settings are specific to the <c>openai</c> service.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor ServiceSettings(Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettings value)
	{
		Instance.ServiceSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings used to install the inference model. These settings are specific to the <c>openai</c> service.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor ServiceSettings(System.Action<Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettingsDescriptor> action)
	{
		Instance.ServiceSettings = Elastic.Clients.Elasticsearch.Inference.AzureAiStudioServiceSettingsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to configure the inference task.
	/// These settings are specific to the task type you specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor TaskSettings(Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettings? value)
	{
		Instance.TaskSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to configure the inference task.
	/// These settings are specific to the task type you specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor TaskSettings()
	{
		Instance.TaskSettings = Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettingsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to configure the inference task.
	/// These settings are specific to the task type you specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor TaskSettings(System.Action<Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettingsDescriptor>? action)
	{
		Instance.TaskSettings = Elastic.Clients.Elasticsearch.Inference.AzureAiStudioTaskSettingsDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequest Build(System.Action<Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor(new Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAzureaistudioRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}