// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

public sealed partial class PutAmazonsagemakerRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference endpoint to be created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Create an Amazon SageMaker inference endpoint.
/// </para>
/// <para>
/// Create an inference endpoint to perform an inference task with the <c>amazon_sagemaker</c> service.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.PutAmazonsagemakerRequestConverter))]
public sealed partial class PutAmazonsagemakerRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutAmazonsagemakerRequest(Elastic.Clients.Elasticsearch.Inference.TaskTypeAmazonSageMaker taskType, Elastic.Clients.Elasticsearch.Id amazonsagemakerInferenceId) : base(r => r.Required("task_type", taskType).Required("amazonsagemaker_inference_id", amazonsagemakerInferenceId))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutAmazonsagemakerRequest(Elastic.Clients.Elasticsearch.Inference.TaskTypeAmazonSageMaker taskType, Elastic.Clients.Elasticsearch.Id amazonsagemakerInferenceId, Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettings serviceSettings) : base(r => r.Required("task_type", taskType).Required("amazonsagemaker_inference_id", amazonsagemakerInferenceId))
	{
		ServiceSettings = serviceSettings;
	}
#if NET7_0_OR_GREATER
	public PutAmazonsagemakerRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutAmazonsagemakerRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.InferencePutAmazonsagemaker;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "inference.put_amazonsagemaker";

	/// <summary>
	/// <para>
	/// The unique identifier of the inference endpoint.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id AmazonsagemakerInferenceId { get => P<Elastic.Clients.Elasticsearch.Id>("amazonsagemaker_inference_id"); set => PR("amazonsagemaker_inference_id", value); }

	/// <summary>
	/// <para>
	/// The type of the inference task that the model will perform.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Inference.TaskTypeAmazonSageMaker TaskType { get => P<Elastic.Clients.Elasticsearch.Inference.TaskTypeAmazonSageMaker>("task_type"); set => PR("task_type", value); }

	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference endpoint to be created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// The chunking configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettings? ChunkingSettings { get; set; }

	/// <summary>
	/// <para>
	/// The type of service supported for the specified task type. In this case, <c>amazon_sagemaker</c>.
	/// </para>
	/// </summary>
	public string Service => "amazon_sagemaker";

	/// <summary>
	/// <para>
	/// Settings used to install the inference model.
	/// These settings are specific to the <c>amazon_sagemaker</c> service and <c>service_settings.api</c> you specified.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettings ServiceSettings { get; set; }

	/// <summary>
	/// <para>
	/// Settings to configure the inference task.
	/// These settings are specific to the task type and <c>service_settings.api</c> you specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettings? TaskSettings { get; set; }
}

/// <summary>
/// <para>
/// Create an Amazon SageMaker inference endpoint.
/// </para>
/// <para>
/// Create an inference endpoint to perform an inference task with the <c>amazon_sagemaker</c> service.
/// </para>
/// </summary>
public readonly partial struct PutAmazonsagemakerRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutAmazonsagemakerRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequest instance)
	{
		Instance = instance;
	}

	public PutAmazonsagemakerRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.TaskTypeAmazonSageMaker taskType, Elastic.Clients.Elasticsearch.Id amazonsagemakerInferenceId)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequest(taskType, amazonsagemakerInferenceId);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutAmazonsagemakerRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequest instance) => new Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequest(Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The unique identifier of the inference endpoint.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor AmazonsagemakerInferenceId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.AmazonsagemakerInferenceId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of the inference task that the model will perform.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor TaskType(Elastic.Clients.Elasticsearch.Inference.TaskTypeAmazonSageMaker value)
	{
		Instance.TaskType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference endpoint to be created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The chunking configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor ChunkingSettings(Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettings? value)
	{
		Instance.ChunkingSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The chunking configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor ChunkingSettings()
	{
		Instance.ChunkingSettings = Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The chunking configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor ChunkingSettings(System.Action<Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor>? action)
	{
		Instance.ChunkingSettings = Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings used to install the inference model.
	/// These settings are specific to the <c>amazon_sagemaker</c> service and <c>service_settings.api</c> you specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor ServiceSettings(Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettings value)
	{
		Instance.ServiceSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings used to install the inference model.
	/// These settings are specific to the <c>amazon_sagemaker</c> service and <c>service_settings.api</c> you specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor ServiceSettings(System.Action<Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettingsDescriptor> action)
	{
		Instance.ServiceSettings = Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerServiceSettingsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to configure the inference task.
	/// These settings are specific to the task type and <c>service_settings.api</c> you specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor TaskSettings(Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettings? value)
	{
		Instance.TaskSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to configure the inference task.
	/// These settings are specific to the task type and <c>service_settings.api</c> you specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor TaskSettings()
	{
		Instance.TaskSettings = Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettingsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to configure the inference task.
	/// These settings are specific to the task type and <c>service_settings.api</c> you specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor TaskSettings(System.Action<Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettingsDescriptor>? action)
	{
		Instance.TaskSettings = Elastic.Clients.Elasticsearch.Inference.AmazonSageMakerTaskSettingsDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequest Build(System.Action<Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor(new Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAmazonsagemakerRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}