// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

public sealed partial class PutAlibabacloudRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference endpoint to be created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Create an AlibabaCloud AI Search inference endpoint.
/// </para>
/// <para>
/// Create an inference endpoint to perform an inference task with the <c>alibabacloud-ai-search</c> service.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.PutAlibabacloudRequestConverter))]
public sealed partial class PutAlibabacloudRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutAlibabacloudRequest(Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskType taskType, Elastic.Clients.Elasticsearch.Id alibabacloudInferenceId) : base(r => r.Required("task_type", taskType).Required("alibabacloud_inference_id", alibabacloudInferenceId))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutAlibabacloudRequest(Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskType taskType, Elastic.Clients.Elasticsearch.Id alibabacloudInferenceId, Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettings serviceSettings) : base(r => r.Required("task_type", taskType).Required("alibabacloud_inference_id", alibabacloudInferenceId))
	{
		ServiceSettings = serviceSettings;
	}
#if NET7_0_OR_GREATER
	public PutAlibabacloudRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutAlibabacloudRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.InferencePutAlibabacloud;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "inference.put_alibabacloud";

	/// <summary>
	/// <para>
	/// The unique identifier of the inference endpoint.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id AlibabacloudInferenceId { get => P<Elastic.Clients.Elasticsearch.Id>("alibabacloud_inference_id"); set => PR("alibabacloud_inference_id", value); }

	/// <summary>
	/// <para>
	/// The type of the inference task that the model will perform.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskType TaskType { get => P<Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskType>("task_type"); set => PR("task_type", value); }

	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference endpoint to be created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// The chunking configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettings? ChunkingSettings { get; set; }

	/// <summary>
	/// <para>
	/// The type of service supported for the specified task type. In this case, <c>alibabacloud-ai-search</c>.
	/// </para>
	/// </summary>
	public string Service => "alibabacloud-ai-search";

	/// <summary>
	/// <para>
	/// Settings used to install the inference model. These settings are specific to the <c>alibabacloud-ai-search</c> service.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettings ServiceSettings { get; set; }

	/// <summary>
	/// <para>
	/// Settings to configure the inference task.
	/// These settings are specific to the task type you specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettings? TaskSettings { get; set; }
}

/// <summary>
/// <para>
/// Create an AlibabaCloud AI Search inference endpoint.
/// </para>
/// <para>
/// Create an inference endpoint to perform an inference task with the <c>alibabacloud-ai-search</c> service.
/// </para>
/// </summary>
public readonly partial struct PutAlibabacloudRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutAlibabacloudRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequest instance)
	{
		Instance = instance;
	}

	public PutAlibabacloudRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskType taskType, Elastic.Clients.Elasticsearch.Id alibabacloudInferenceId)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequest(taskType, alibabacloudInferenceId);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutAlibabacloudRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequest instance) => new Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequest(Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The unique identifier of the inference endpoint.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor AlibabacloudInferenceId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.AlibabacloudInferenceId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of the inference task that the model will perform.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor TaskType(Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskType value)
	{
		Instance.TaskType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference endpoint to be created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The chunking configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor ChunkingSettings(Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettings? value)
	{
		Instance.ChunkingSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The chunking configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor ChunkingSettings()
	{
		Instance.ChunkingSettings = Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The chunking configuration object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor ChunkingSettings(System.Action<Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor>? action)
	{
		Instance.ChunkingSettings = Elastic.Clients.Elasticsearch.Inference.InferenceChunkingSettingsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings used to install the inference model. These settings are specific to the <c>alibabacloud-ai-search</c> service.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor ServiceSettings(Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettings value)
	{
		Instance.ServiceSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings used to install the inference model. These settings are specific to the <c>alibabacloud-ai-search</c> service.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor ServiceSettings(System.Action<Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettingsDescriptor> action)
	{
		Instance.ServiceSettings = Elastic.Clients.Elasticsearch.Inference.AlibabaCloudServiceSettingsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to configure the inference task.
	/// These settings are specific to the task type you specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor TaskSettings(Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettings? value)
	{
		Instance.TaskSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to configure the inference task.
	/// These settings are specific to the task type you specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor TaskSettings()
	{
		Instance.TaskSettings = Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettingsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to configure the inference task.
	/// These settings are specific to the task type you specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor TaskSettings(System.Action<Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettingsDescriptor>? action)
	{
		Instance.TaskSettings = Elastic.Clients.Elasticsearch.Inference.AlibabaCloudTaskSettingsDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequest Build(System.Action<Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor(new Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.PutAlibabacloudRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}