// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

public sealed partial class InferenceRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// The amount of time to wait for the inference request to complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Perform inference on the service.
/// </para>
/// <para>
/// This API enables you to use machine learning models to perform specific tasks on data that you provide as an input.
/// It returns a response with the results of the tasks.
/// The inference endpoint you use can perform one specific task that has been defined when the endpoint was created with the create inference API.
/// </para>
/// <para>
/// For details about using this API with a service, such as Amazon Bedrock, Anthropic, or HuggingFace, refer to the service-specific documentation.
/// </para>
/// <para>
/// info
/// The inference APIs enable you to use certain services, such as built-in machine learning models (ELSER, E5), models uploaded through Eland, Cohere, OpenAI, Azure, Google AI Studio, Google Vertex AI, Anthropic, Watsonx.ai, or Hugging Face. For built-in models and models uploaded through Eland, the inference APIs offer an alternative way to use and manage trained models. However, if you do not plan to use the inference APIs to use these models or if you want to use non-NLP models, use the machine learning trained model APIs.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.InferenceRequestConverter))]
public sealed partial class InferenceRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Inference.InferenceRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceRequest(Elastic.Clients.Elasticsearch.Id inferenceId) : base(r => r.Required("inference_id", inferenceId))
	{
	}

	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceRequest(Elastic.Clients.Elasticsearch.Inference.TaskType? taskType, Elastic.Clients.Elasticsearch.Id inferenceId) : base(r => r.Optional("task_type", taskType).Required("inference_id", inferenceId))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceRequest(Elastic.Clients.Elasticsearch.Id inferenceId, System.Collections.Generic.ICollection<string> input) : base(r => r.Required("inference_id", inferenceId))
	{
		Input = input;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceRequest(Elastic.Clients.Elasticsearch.Inference.TaskType? taskType, Elastic.Clients.Elasticsearch.Id inferenceId, System.Collections.Generic.ICollection<string> input) : base(r => r.Optional("task_type", taskType).Required("inference_id", inferenceId))
	{
		Input = input;
	}
#if NET7_0_OR_GREATER
	public InferenceRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal InferenceRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.InferenceInference;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "inference.inference";

	/// <summary>
	/// <para>
	/// The unique identifier for the inference endpoint.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id InferenceId { get => P<Elastic.Clients.Elasticsearch.Id>("inference_id"); set => PR("inference_id", value); }

	/// <summary>
	/// <para>
	/// The type of inference task that the model performs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.TaskType? TaskType { get => P<Elastic.Clients.Elasticsearch.Inference.TaskType?>("task_type"); set => PO("task_type", value); }

	/// <summary>
	/// <para>
	/// The amount of time to wait for the inference request to complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// The text on which you want to perform the inference task.
	/// It can be a single string or an array.
	/// </para>
	/// <para>
	/// info
	/// Inference endpoints for the <c>completion</c> task type currently only support a single string as input.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<string> Input { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the input data type for the text embedding model. The <c>input_type</c> parameter only applies to Inference Endpoints with the <c>text_embedding</c> task type. Possible values include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>SEARCH</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>INGEST</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>CLASSIFICATION</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>CLUSTERING</c>
	/// Not all services support all values. Unsupported values will trigger a validation exception.
	/// Accepted values depend on the configured inference service, refer to the relevant service-specific documentation for more info.
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// info
	/// The <c>input_type</c> parameter specified on the root level of the request body will take precedence over the <c>input_type</c> parameter specified in <c>task_settings</c>.
	/// </para>
	/// </summary>
	public string? InputType { get; set; }

	/// <summary>
	/// <para>
	/// The query input, which is required only for the <c>rerank</c> task.
	/// It is not required for other tasks.
	/// </para>
	/// </summary>
	public string? Query { get; set; }

	/// <summary>
	/// <para>
	/// Task settings for the individual inference request.
	/// These settings are specific to the task type you specified and override the task settings specified when initializing the service.
	/// </para>
	/// </summary>
	public object? TaskSettings { get; set; }
}

/// <summary>
/// <para>
/// Perform inference on the service.
/// </para>
/// <para>
/// This API enables you to use machine learning models to perform specific tasks on data that you provide as an input.
/// It returns a response with the results of the tasks.
/// The inference endpoint you use can perform one specific task that has been defined when the endpoint was created with the create inference API.
/// </para>
/// <para>
/// For details about using this API with a service, such as Amazon Bedrock, Anthropic, or HuggingFace, refer to the service-specific documentation.
/// </para>
/// <para>
/// info
/// The inference APIs enable you to use certain services, such as built-in machine learning models (ELSER, E5), models uploaded through Eland, Cohere, OpenAI, Azure, Google AI Studio, Google Vertex AI, Anthropic, Watsonx.ai, or Hugging Face. For built-in models and models uploaded through Eland, the inference APIs offer an alternative way to use and manage trained models. However, if you do not plan to use the inference APIs to use these models or if you want to use non-NLP models, use the machine learning trained model APIs.
/// </para>
/// </summary>
public readonly partial struct InferenceRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.InferenceRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.InferenceRequest instance)
	{
		Instance = instance;
	}

	public InferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Id inferenceId)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Inference.InferenceRequest(inferenceId);
#pragma warning restore CS0618
	}

	public InferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.TaskType? taskType, Elastic.Clients.Elasticsearch.Id inferenceId)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Inference.InferenceRequest(taskType, inferenceId);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public InferenceRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.InferenceRequest instance) => new Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.InferenceRequest(Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The unique identifier for the inference endpoint.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor InferenceId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.InferenceId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of inference task that the model performs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor TaskType(Elastic.Clients.Elasticsearch.Inference.TaskType? value)
	{
		Instance.TaskType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The amount of time to wait for the inference request to complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The text on which you want to perform the inference task.
	/// It can be a single string or an array.
	/// </para>
	/// <para>
	/// info
	/// Inference endpoints for the <c>completion</c> task type currently only support a single string as input.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor Input(System.Collections.Generic.ICollection<string> value)
	{
		Instance.Input = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The text on which you want to perform the inference task.
	/// It can be a single string or an array.
	/// </para>
	/// <para>
	/// info
	/// Inference endpoints for the <c>completion</c> task type currently only support a single string as input.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor Input(params string[] values)
	{
		Instance.Input = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the input data type for the text embedding model. The <c>input_type</c> parameter only applies to Inference Endpoints with the <c>text_embedding</c> task type. Possible values include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// <c>SEARCH</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>INGEST</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>CLASSIFICATION</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// <c>CLUSTERING</c>
	/// Not all services support all values. Unsupported values will trigger a validation exception.
	/// Accepted values depend on the configured inference service, refer to the relevant service-specific documentation for more info.
	/// </para>
	/// </item>
	/// </list>
	/// <para>
	/// info
	/// The <c>input_type</c> parameter specified on the root level of the request body will take precedence over the <c>input_type</c> parameter specified in <c>task_settings</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor InputType(string? value)
	{
		Instance.InputType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query input, which is required only for the <c>rerank</c> task.
	/// It is not required for other tasks.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor Query(string? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Task settings for the individual inference request.
	/// These settings are specific to the task type you specified and override the task settings specified when initializing the service.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor TaskSettings(object? value)
	{
		Instance.TaskSettings = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.InferenceRequest Build(System.Action<Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor(new Elastic.Clients.Elasticsearch.Inference.InferenceRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.InferenceRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}