// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

public sealed partial class GetInferenceRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Get an inference endpoint
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.GetInferenceRequestConverter))]
public sealed partial class GetInferenceRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Inference.GetInferenceRequestParameters>
{
	public GetInferenceRequest(Elastic.Clients.Elasticsearch.Id? inferenceId) : base(r => r.Optional("inference_id", inferenceId))
	{
	}

	public GetInferenceRequest(Elastic.Clients.Elasticsearch.Inference.TaskType? taskType, Elastic.Clients.Elasticsearch.Id? inferenceId) : base(r => r.Optional("task_type", taskType).Optional("inference_id", inferenceId))
	{
	}
#if NET7_0_OR_GREATER
	public GetInferenceRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public GetInferenceRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetInferenceRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.InferenceGet;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "inference.get";

	/// <summary>
	/// <para>
	/// The inference Id
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Id? InferenceId { get => P<Elastic.Clients.Elasticsearch.Id?>("inference_id"); set => PO("inference_id", value); }

	/// <summary>
	/// <para>
	/// The task type
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.TaskType? TaskType { get => P<Elastic.Clients.Elasticsearch.Inference.TaskType?>("task_type"); set => PO("task_type", value); }
}

/// <summary>
/// <para>
/// Get an inference endpoint
/// </para>
/// </summary>
public readonly partial struct GetInferenceRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.GetInferenceRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetInferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.GetInferenceRequest instance)
	{
		Instance = instance;
	}

	public GetInferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Id? inferenceId)
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.GetInferenceRequest(inferenceId);
	}

	public GetInferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.TaskType? taskType, Elastic.Clients.Elasticsearch.Id? inferenceId)
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.GetInferenceRequest(taskType, inferenceId);
	}

	public GetInferenceRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.GetInferenceRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.GetInferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.GetInferenceRequest instance) => new Elastic.Clients.Elasticsearch.Inference.GetInferenceRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.GetInferenceRequest(Elastic.Clients.Elasticsearch.Inference.GetInferenceRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The inference Id
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.GetInferenceRequestDescriptor InferenceId(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.InferenceId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The task type
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.GetInferenceRequestDescriptor TaskType(Elastic.Clients.Elasticsearch.Inference.TaskType? value)
	{
		Instance.TaskType = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.GetInferenceRequest Build(System.Action<Elastic.Clients.Elasticsearch.Inference.GetInferenceRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Inference.GetInferenceRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Inference.GetInferenceRequestDescriptor(new Elastic.Clients.Elasticsearch.Inference.GetInferenceRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Inference.GetInferenceRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.GetInferenceRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.GetInferenceRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.GetInferenceRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.GetInferenceRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.GetInferenceRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.GetInferenceRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}