// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

public sealed partial class DeleteInferenceRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// When true, the endpoint is not deleted and a list of ingest processors which reference this endpoint is returned.
	/// </para>
	/// </summary>
	public bool? DryRun { get => Q<bool?>("dry_run"); set => Q("dry_run", value); }

	/// <summary>
	/// <para>
	/// When true, the inference endpoint is forcefully deleted even if it is still being used by ingest processors or semantic text fields.
	/// </para>
	/// </summary>
	public bool? Force { get => Q<bool?>("force"); set => Q("force", value); }
}

/// <summary>
/// <para>
/// Delete an inference endpoint
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.DeleteInferenceRequestConverter))]
public sealed partial class DeleteInferenceRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DeleteInferenceRequest(Elastic.Clients.Elasticsearch.Id inferenceId) : base(r => r.Required("inference_id", inferenceId))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DeleteInferenceRequest(Elastic.Clients.Elasticsearch.Inference.TaskType? taskType, Elastic.Clients.Elasticsearch.Id inferenceId) : base(r => r.Optional("task_type", taskType).Required("inference_id", inferenceId))
	{
	}
#if NET7_0_OR_GREATER
	public DeleteInferenceRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DeleteInferenceRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.InferenceDelete;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.DELETE;

	internal override bool SupportsBody => false;

	internal override string OperationName => "inference.delete";

	/// <summary>
	/// <para>
	/// The inference identifier.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id InferenceId { get => P<Elastic.Clients.Elasticsearch.Id>("inference_id"); set => PR("inference_id", value); }

	/// <summary>
	/// <para>
	/// The task type
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.TaskType? TaskType { get => P<Elastic.Clients.Elasticsearch.Inference.TaskType?>("task_type"); set => PO("task_type", value); }

	/// <summary>
	/// <para>
	/// When true, the endpoint is not deleted and a list of ingest processors which reference this endpoint is returned.
	/// </para>
	/// </summary>
	public bool? DryRun { get => Q<bool?>("dry_run"); set => Q("dry_run", value); }

	/// <summary>
	/// <para>
	/// When true, the inference endpoint is forcefully deleted even if it is still being used by ingest processors or semantic text fields.
	/// </para>
	/// </summary>
	public bool? Force { get => Q<bool?>("force"); set => Q("force", value); }
}

/// <summary>
/// <para>
/// Delete an inference endpoint
/// </para>
/// </summary>
public readonly partial struct DeleteInferenceRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DeleteInferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequest instance)
	{
		Instance = instance;
	}

	public DeleteInferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Id inferenceId)
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequest(inferenceId);
	}

	public DeleteInferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.TaskType? taskType, Elastic.Clients.Elasticsearch.Id inferenceId)
	{
		Instance = new Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequest(taskType, inferenceId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public DeleteInferenceRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequest instance) => new Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequest(Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The inference identifier.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequestDescriptor InferenceId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.InferenceId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The task type
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequestDescriptor TaskType(Elastic.Clients.Elasticsearch.Inference.TaskType? value)
	{
		Instance.TaskType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// When true, the endpoint is not deleted and a list of ingest processors which reference this endpoint is returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequestDescriptor DryRun(bool? value = true)
	{
		Instance.DryRun = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// When true, the inference endpoint is forcefully deleted even if it is still being used by ingest processors or semantic text fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequestDescriptor Force(bool? value = true)
	{
		Instance.Force = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequest Build(System.Action<Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequestDescriptor(new Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.DeleteInferenceRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}