// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Inference;

public sealed partial class ChatCompletionUnifiedRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference request to complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Perform chat completion inference
/// </para>
/// <para>
/// The chat completion inference API enables real-time responses for chat completion tasks by delivering answers incrementally, reducing response times during computation.
/// It only works with the <c>chat_completion</c> task type for <c>openai</c> and <c>elastic</c> inference services.
/// </para>
/// <para>
/// NOTE: The <c>chat_completion</c> task type is only available within the _stream API and only supports streaming.
/// The Chat completion inference API and the Stream inference API differ in their response structure and capabilities.
/// The Chat completion inference API provides more comprehensive customization options through more fields and function calling support.
/// If you use the <c>openai</c>, <c>hugging_face</c> or the <c>elastic</c> service, use the Chat completion inference API.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Inference.Json.ChatCompletionUnifiedRequestConverter))]
public sealed partial class ChatCompletionUnifiedRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ChatCompletionUnifiedRequest(Elastic.Clients.Elasticsearch.Id inferenceId) : base(r => r.Required("inference_id", inferenceId))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ChatCompletionUnifiedRequest(Elastic.Clients.Elasticsearch.Id inferenceId, Elastic.Clients.Elasticsearch.Inference.RequestChatCompletion chatCompletionRequest) : base(r => r.Required("inference_id", inferenceId))
	{
		ChatCompletionRequest = chatCompletionRequest;
	}
#if NET7_0_OR_GREATER
	public ChatCompletionUnifiedRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ChatCompletionUnifiedRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.InferenceChatCompletionUnified;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "inference.chat_completion_unified";

	/// <summary>
	/// <para>
	/// The inference Id
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id InferenceId { get => P<Elastic.Clients.Elasticsearch.Id>("inference_id"); set => PR("inference_id", value); }

	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference request to complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Inference.RequestChatCompletion ChatCompletionRequest { get; set; }
}

/// <summary>
/// <para>
/// Perform chat completion inference
/// </para>
/// <para>
/// The chat completion inference API enables real-time responses for chat completion tasks by delivering answers incrementally, reducing response times during computation.
/// It only works with the <c>chat_completion</c> task type for <c>openai</c> and <c>elastic</c> inference services.
/// </para>
/// <para>
/// NOTE: The <c>chat_completion</c> task type is only available within the _stream API and only supports streaming.
/// The Chat completion inference API and the Stream inference API differ in their response structure and capabilities.
/// The Chat completion inference API provides more comprehensive customization options through more fields and function calling support.
/// If you use the <c>openai</c>, <c>hugging_face</c> or the <c>elastic</c> service, use the Chat completion inference API.
/// </para>
/// </summary>
public readonly partial struct ChatCompletionUnifiedRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ChatCompletionUnifiedRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequest instance)
	{
		Instance = instance;
	}

	public ChatCompletionUnifiedRequestDescriptor(Elastic.Clients.Elasticsearch.Id inferenceId)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequest(inferenceId);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public ChatCompletionUnifiedRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequestDescriptor(Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequest instance) => new Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequest(Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The inference Id
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequestDescriptor InferenceId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.InferenceId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the amount of time to wait for the inference request to complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequestDescriptor ChatCompletionRequest(Elastic.Clients.Elasticsearch.Inference.RequestChatCompletion value)
	{
		Instance.ChatCompletionRequest = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequestDescriptor ChatCompletionRequest(System.Action<Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor> action)
	{
		Instance.ChatCompletionRequest = Elastic.Clients.Elasticsearch.Inference.RequestChatCompletionDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequest Build(System.Action<Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequestDescriptor(new Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Inference.ChatCompletionUnifiedRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}