// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

public sealed partial class SimulateTemplateRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// User defined reason for dry-run creating the new template for simulation purposes
	/// </para>
	/// </summary>
	public string? Cause { get => Q<string?>("cause"); set => Q("cause", value); }

	/// <summary>
	/// <para>
	/// If true, the template passed in the body is only used if no existing templates match the same index patterns. If false, the simulation uses the template with the highest priority. Note that the template is not permanently added or updated in either case; it is only used for the simulation.
	/// </para>
	/// </summary>
	public bool? Create { get => Q<bool?>("create"); set => Q("create", value); }

	/// <summary>
	/// <para>
	/// If true, returns all relevant default configurations for the index template.
	/// </para>
	/// </summary>
	public bool? IncludeDefaults { get => Q<bool?>("include_defaults"); set => Q("include_defaults", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }
}

/// <summary>
/// <para>
/// Simulate an index template.
/// Get the index configuration that would be applied by a particular index template.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.SimulateTemplateRequestConverter))]
public sealed partial class SimulateTemplateRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestParameters>
{
	public SimulateTemplateRequest(Elastic.Clients.Elasticsearch.Name? name) : base(r => r.Optional("name", name))
	{
	}
#if NET7_0_OR_GREATER
	public SimulateTemplateRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public SimulateTemplateRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SimulateTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.IndexManagementSimulateTemplate;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "indices.simulate_template";

	/// <summary>
	/// <para>
	/// Name of the index template to simulate. To test a template configuration before you add it to the cluster, omit
	/// this parameter and specify the template configuration in the request body.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Name? Name { get => P<Elastic.Clients.Elasticsearch.Name?>("name"); set => PO("name", value); }

	/// <summary>
	/// <para>
	/// User defined reason for dry-run creating the new template for simulation purposes
	/// </para>
	/// </summary>
	public string? Cause { get => Q<string?>("cause"); set => Q("cause", value); }

	/// <summary>
	/// <para>
	/// If true, the template passed in the body is only used if no existing templates match the same index patterns. If false, the simulation uses the template with the highest priority. Note that the template is not permanently added or updated in either case; it is only used for the simulation.
	/// </para>
	/// </summary>
	public bool? Create { get => Q<bool?>("create"); set => Q("create", value); }

	/// <summary>
	/// <para>
	/// If true, returns all relevant default configurations for the index template.
	/// </para>
	/// </summary>
	public bool? IncludeDefaults { get => Q<bool?>("include_defaults"); set => Q("include_defaults", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// This setting overrides the value of the <c>action.auto_create_index</c> cluster setting.
	/// If set to <c>true</c> in a template, then indices can be automatically created using that template even if auto-creation of indices is disabled via <c>actions.auto_create_index</c>.
	/// If set to <c>false</c>, then indices or data streams matching the template must always be explicitly created, and may never be automatically created.
	/// </para>
	/// </summary>
	public bool? AllowAutoCreate { get; set; }

	/// <summary>
	/// <para>
	/// An ordered list of component template names.
	/// Component templates are merged in the order specified, meaning that the last component template specified has the highest precedence.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Name>? ComposedOf { get; set; }

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamVisibility? DataStream { get; set; }

	/// <summary>
	/// <para>
	/// Marks this index template as deprecated. When creating or updating a non-deprecated index template
	/// that uses deprecated components, Elasticsearch will emit a deprecation warning.
	/// </para>
	/// </summary>
	public bool? Deprecated { get; set; }

	/// <summary>
	/// <para>
	/// The configuration option ignore_missing_component_templates can be used when an index template
	/// references a component template that might not exist
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? IgnoreMissingComponentTemplates { get; set; }

	/// <summary>
	/// <para>
	/// Array of wildcard (<c>*</c>) expressions used to match the names of data streams and indices during creation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Indices? IndexPatterns { get; set; }

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template.
	/// May have any contents.
	/// This map is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Meta { get; set; }

	/// <summary>
	/// <para>
	/// Priority to determine index template precedence when a new data stream or index is created.
	/// The index template with the highest priority is chosen.
	/// If no priority is specified the template is treated as though it is of priority 0 (lowest priority).
	/// This number is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public long? Priority { get; set; }

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMapping? Template { get; set; }

	/// <summary>
	/// <para>
	/// Version number used to manage index templates externally.
	/// This number is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public long? Version { get; set; }
}

/// <summary>
/// <para>
/// Simulate an index template.
/// Get the index configuration that would be applied by a particular index template.
/// </para>
/// </summary>
public readonly partial struct SimulateTemplateRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SimulateTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest instance)
	{
		Instance = instance;
	}

	public SimulateTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.Name? name)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest(name);
	}

	public SimulateTemplateRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest(Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Name of the index template to simulate. To test a template configuration before you add it to the cluster, omit
	/// this parameter and specify the template configuration in the request body.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor Name(Elastic.Clients.Elasticsearch.Name? value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// User defined reason for dry-run creating the new template for simulation purposes
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor Cause(string? value)
	{
		Instance.Cause = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, the template passed in the body is only used if no existing templates match the same index patterns. If false, the simulation uses the template with the highest priority. Note that the template is not permanently added or updated in either case; it is only used for the simulation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor Create(bool? value = true)
	{
		Instance.Create = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, returns all relevant default configurations for the index template.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor IncludeDefaults(bool? value = true)
	{
		Instance.IncludeDefaults = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting overrides the value of the <c>action.auto_create_index</c> cluster setting.
	/// If set to <c>true</c> in a template, then indices can be automatically created using that template even if auto-creation of indices is disabled via <c>actions.auto_create_index</c>.
	/// If set to <c>false</c>, then indices or data streams matching the template must always be explicitly created, and may never be automatically created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor AllowAutoCreate(bool? value = true)
	{
		Instance.AllowAutoCreate = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An ordered list of component template names.
	/// Component templates are merged in the order specified, meaning that the last component template specified has the highest precedence.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor ComposedOf(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Name>? value)
	{
		Instance.ComposedOf = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An ordered list of component template names.
	/// Component templates are merged in the order specified, meaning that the last component template specified has the highest precedence.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor ComposedOf(params Elastic.Clients.Elasticsearch.Name[] values)
	{
		Instance.ComposedOf = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor DataStream(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamVisibility? value)
	{
		Instance.DataStream = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor DataStream()
	{
		Instance.DataStream = Elastic.Clients.Elasticsearch.IndexManagement.DataStreamVisibilityDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor DataStream(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamVisibilityDescriptor>? action)
	{
		Instance.DataStream = Elastic.Clients.Elasticsearch.IndexManagement.DataStreamVisibilityDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Marks this index template as deprecated. When creating or updating a non-deprecated index template
	/// that uses deprecated components, Elasticsearch will emit a deprecation warning.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor Deprecated(bool? value = true)
	{
		Instance.Deprecated = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration option ignore_missing_component_templates can be used when an index template
	/// references a component template that might not exist
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor IgnoreMissingComponentTemplates(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.IgnoreMissingComponentTemplates = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration option ignore_missing_component_templates can be used when an index template
	/// references a component template that might not exist
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor IgnoreMissingComponentTemplates(params string[] values)
	{
		Instance.IgnoreMissingComponentTemplates = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (<c>*</c>) expressions used to match the names of data streams and indices during creation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor IndexPatterns(Elastic.Clients.Elasticsearch.Indices? value)
	{
		Instance.IndexPatterns = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template.
	/// May have any contents.
	/// This map is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor Meta(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Meta = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template.
	/// May have any contents.
	/// This map is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template.
	/// May have any contents.
	/// This map is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor AddMeta(string key, object value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Meta.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Priority to determine index template precedence when a new data stream or index is created.
	/// The index template with the highest priority is chosen.
	/// If no priority is specified the template is treated as though it is of priority 0 (lowest priority).
	/// This number is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor Priority(long? value)
	{
		Instance.Priority = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor Template(Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMapping? value)
	{
		Instance.Template = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor Template()
	{
		Instance.Template = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMappingDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor Template(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMappingDescriptor>? action)
	{
		Instance.Template = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMappingDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor Template<T>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMappingDescriptor<T>>? action)
	{
		Instance.Template = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMappingDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Version number used to manage index templates externally.
	/// This number is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor Version(long? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Simulate an index template.
/// Get the index configuration that would be applied by a particular index template.
/// </para>
/// </summary>
public readonly partial struct SimulateTemplateRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SimulateTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest instance)
	{
		Instance = instance;
	}

	public SimulateTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.Name? name)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest(name);
	}

	public SimulateTemplateRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest(Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Name of the index template to simulate. To test a template configuration before you add it to the cluster, omit
	/// this parameter and specify the template configuration in the request body.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> Name(Elastic.Clients.Elasticsearch.Name? value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// User defined reason for dry-run creating the new template for simulation purposes
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> Cause(string? value)
	{
		Instance.Cause = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, the template passed in the body is only used if no existing templates match the same index patterns. If false, the simulation uses the template with the highest priority. Note that the template is not permanently added or updated in either case; it is only used for the simulation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> Create(bool? value = true)
	{
		Instance.Create = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, returns all relevant default configurations for the index template.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> IncludeDefaults(bool? value = true)
	{
		Instance.IncludeDefaults = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting overrides the value of the <c>action.auto_create_index</c> cluster setting.
	/// If set to <c>true</c> in a template, then indices can be automatically created using that template even if auto-creation of indices is disabled via <c>actions.auto_create_index</c>.
	/// If set to <c>false</c>, then indices or data streams matching the template must always be explicitly created, and may never be automatically created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> AllowAutoCreate(bool? value = true)
	{
		Instance.AllowAutoCreate = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An ordered list of component template names.
	/// Component templates are merged in the order specified, meaning that the last component template specified has the highest precedence.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> ComposedOf(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Name>? value)
	{
		Instance.ComposedOf = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An ordered list of component template names.
	/// Component templates are merged in the order specified, meaning that the last component template specified has the highest precedence.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> ComposedOf(params Elastic.Clients.Elasticsearch.Name[] values)
	{
		Instance.ComposedOf = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> DataStream(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamVisibility? value)
	{
		Instance.DataStream = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> DataStream()
	{
		Instance.DataStream = Elastic.Clients.Elasticsearch.IndexManagement.DataStreamVisibilityDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> DataStream(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamVisibilityDescriptor>? action)
	{
		Instance.DataStream = Elastic.Clients.Elasticsearch.IndexManagement.DataStreamVisibilityDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Marks this index template as deprecated. When creating or updating a non-deprecated index template
	/// that uses deprecated components, Elasticsearch will emit a deprecation warning.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> Deprecated(bool? value = true)
	{
		Instance.Deprecated = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration option ignore_missing_component_templates can be used when an index template
	/// references a component template that might not exist
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> IgnoreMissingComponentTemplates(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.IgnoreMissingComponentTemplates = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration option ignore_missing_component_templates can be used when an index template
	/// references a component template that might not exist
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> IgnoreMissingComponentTemplates(params string[] values)
	{
		Instance.IgnoreMissingComponentTemplates = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (<c>*</c>) expressions used to match the names of data streams and indices during creation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> IndexPatterns(Elastic.Clients.Elasticsearch.Indices? value)
	{
		Instance.IndexPatterns = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template.
	/// May have any contents.
	/// This map is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> Meta(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Meta = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template.
	/// May have any contents.
	/// This map is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template.
	/// May have any contents.
	/// This map is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> AddMeta(string key, object value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Meta.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Priority to determine index template precedence when a new data stream or index is created.
	/// The index template with the highest priority is chosen.
	/// If no priority is specified the template is treated as though it is of priority 0 (lowest priority).
	/// This number is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> Priority(long? value)
	{
		Instance.Priority = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> Template(Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMapping? value)
	{
		Instance.Template = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> Template()
	{
		Instance.Template = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMappingDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> Template(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMappingDescriptor<TDocument>>? action)
	{
		Instance.Template = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMappingDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Version number used to manage index templates externally.
	/// This number is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> Version(long? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateTemplateRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}