// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

public sealed partial class SimulateIndexTemplateRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// User defined reason for dry-run creating the new template for simulation purposes
	/// </para>
	/// </summary>
	public string? Cause { get => Q<string?>("cause"); set => Q("cause", value); }

	/// <summary>
	/// <para>
	/// Whether the index template we optionally defined in the body should only be dry-run added if new or can also replace an existing one
	/// </para>
	/// </summary>
	public bool? Create { get => Q<bool?>("create"); set => Q("create", value); }

	/// <summary>
	/// <para>
	/// If true, returns all relevant default configurations for the index template.
	/// </para>
	/// </summary>
	public bool? IncludeDefaults { get => Q<bool?>("include_defaults"); set => Q("include_defaults", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }
}

/// <summary>
/// <para>
/// Simulate an index.
/// Get the index configuration that would be applied to the specified index from an existing index template.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.SimulateIndexTemplateRequestConverter))]
public sealed partial class SimulateIndexTemplateRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SimulateIndexTemplateRequest(Elastic.Clients.Elasticsearch.Name name) : base(r => r.Required("name", name))
	{
	}
#if NET7_0_OR_GREATER
	public SimulateIndexTemplateRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SimulateIndexTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.IndexManagementSimulateIndexTemplate;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "indices.simulate_index_template";

	/// <summary>
	/// <para>
	/// Name of the index to simulate
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name Name { get => P<Elastic.Clients.Elasticsearch.Name>("name"); set => PR("name", value); }

	/// <summary>
	/// <para>
	/// User defined reason for dry-run creating the new template for simulation purposes
	/// </para>
	/// </summary>
	public string? Cause { get => Q<string?>("cause"); set => Q("cause", value); }

	/// <summary>
	/// <para>
	/// Whether the index template we optionally defined in the body should only be dry-run added if new or can also replace an existing one
	/// </para>
	/// </summary>
	public bool? Create { get => Q<bool?>("create"); set => Q("create", value); }

	/// <summary>
	/// <para>
	/// If true, returns all relevant default configurations for the index template.
	/// </para>
	/// </summary>
	public bool? IncludeDefaults { get => Q<bool?>("include_defaults"); set => Q("include_defaults", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate? IndexTemplate { get; set; }
}

/// <summary>
/// <para>
/// Simulate an index.
/// Get the index configuration that would be applied to the specified index from an existing index template.
/// </para>
/// </summary>
public readonly partial struct SimulateIndexTemplateRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SimulateIndexTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest instance)
	{
		Instance = instance;
	}

	public SimulateIndexTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.Name name)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest(name);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public SimulateIndexTemplateRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest(Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Name of the index to simulate
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// User defined reason for dry-run creating the new template for simulation purposes
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor Cause(string? value)
	{
		Instance.Cause = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether the index template we optionally defined in the body should only be dry-run added if new or can also replace an existing one
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor Create(bool? value = true)
	{
		Instance.Create = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, returns all relevant default configurations for the index template.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor IncludeDefaults(bool? value = true)
	{
		Instance.IncludeDefaults = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor IndexTemplate(Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate? value)
	{
		Instance.IndexTemplate = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor IndexTemplate(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor> action)
	{
		Instance.IndexTemplate = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor IndexTemplate<T>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<T>> action)
	{
		Instance.IndexTemplate = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Simulate an index.
/// Get the index configuration that would be applied to the specified index from an existing index template.
/// </para>
/// </summary>
public readonly partial struct SimulateIndexTemplateRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SimulateIndexTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest instance)
	{
		Instance = instance;
	}

	public SimulateIndexTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.Name name)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest(name);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public SimulateIndexTemplateRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest(Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Name of the index to simulate
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument> Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// User defined reason for dry-run creating the new template for simulation purposes
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument> Cause(string? value)
	{
		Instance.Cause = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether the index template we optionally defined in the body should only be dry-run added if new or can also replace an existing one
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument> Create(bool? value = true)
	{
		Instance.Create = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, returns all relevant default configurations for the index template.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument> IncludeDefaults(bool? value = true)
	{
		Instance.IncludeDefaults = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument> MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument> IndexTemplate(Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate? value)
	{
		Instance.IndexTemplate = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument> IndexTemplate(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument>> action)
	{
		Instance.IndexTemplate = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SimulateIndexTemplateRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}