// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

public sealed partial class PutTemplateRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// User defined reason for creating/updating the index template
	/// </para>
	/// </summary>
	public string? Cause { get => Q<string?>("cause"); set => Q("cause", value); }

	/// <summary>
	/// <para>
	/// If true, this request cannot replace or update existing index templates.
	/// </para>
	/// </summary>
	public bool? Create { get => Q<bool?>("create"); set => Q("create", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node. If no response is
	/// received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }
}

/// <summary>
/// <para>
/// Create or update a legacy index template.
/// Index templates define settings, mappings, and aliases that can be applied automatically to new indices.
/// Elasticsearch applies templates to new indices based on an index pattern that matches the index name.
/// </para>
/// <para>
/// IMPORTANT: This documentation is about legacy index templates, which are deprecated and will be replaced by the composable templates introduced in Elasticsearch 7.8.
/// </para>
/// <para>
/// Composable templates always take precedence over legacy templates.
/// If no composable template matches a new index, matching legacy templates are applied according to their order.
/// </para>
/// <para>
/// Index templates are only applied during index creation.
/// Changes to index templates do not affect existing indices.
/// Settings and mappings specified in create index API requests override any settings or mappings specified in an index template.
/// </para>
/// <para>
/// You can use C-style <c>/* *\/</c> block comments in index templates.
/// You can include comments anywhere in the request body, except before the opening curly bracket.
/// </para>
/// <para>
/// <strong>Indices matching multiple templates</strong>
/// </para>
/// <para>
/// Multiple index templates can potentially match an index, in this case, both the settings and mappings are merged into the final configuration of the index.
/// The order of the merging can be controlled using the order parameter, with lower order being applied first, and higher orders overriding them.
/// NOTE: Multiple matching templates with the same order value will result in a non-deterministic merging order.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.PutTemplateRequestConverter))]
public sealed partial class PutTemplateRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutTemplateRequest(Elastic.Clients.Elasticsearch.Name name) : base(r => r.Required("name", name))
	{
	}
#if NET7_0_OR_GREATER
	public PutTemplateRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.IndexManagementPutTemplate;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "indices.put_template";

	/// <summary>
	/// <para>
	/// The name of the template
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name Name { get => P<Elastic.Clients.Elasticsearch.Name>("name"); set => PR("name", value); }

	/// <summary>
	/// <para>
	/// User defined reason for creating/updating the index template
	/// </para>
	/// </summary>
	public string? Cause { get => Q<string?>("cause"); set => Q("cause", value); }

	/// <summary>
	/// <para>
	/// If true, this request cannot replace or update existing index templates.
	/// </para>
	/// </summary>
	public bool? Create { get => Q<bool?>("create"); set => Q("create", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node. If no response is
	/// received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>? Aliases { get; set; }

	/// <summary>
	/// <para>
	/// Array of wildcard expressions used to match the names
	/// of indices during creation.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? IndexPatterns { get; set; }

	/// <summary>
	/// <para>
	/// Mapping for fields in the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.TypeMapping? Mappings { get; set; }

	/// <summary>
	/// <para>
	/// Order in which Elasticsearch applies this template if index
	/// matches multiple templates.
	/// </para>
	/// <para>
	/// Templates with lower 'order' values are merged first. Templates with higher
	/// 'order' values are merged later, overriding templates with lower values.
	/// </para>
	/// </summary>
	public int? Order { get; set; }

	/// <summary>
	/// <para>
	/// Configuration options for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings? Settings { get; set; }

	/// <summary>
	/// <para>
	/// Version number used to manage index templates externally. This number
	/// is not automatically generated by Elasticsearch.
	/// To unset a version, replace the template without specifying one.
	/// </para>
	/// </summary>
	public long? Version { get; set; }
}

/// <summary>
/// <para>
/// Create or update a legacy index template.
/// Index templates define settings, mappings, and aliases that can be applied automatically to new indices.
/// Elasticsearch applies templates to new indices based on an index pattern that matches the index name.
/// </para>
/// <para>
/// IMPORTANT: This documentation is about legacy index templates, which are deprecated and will be replaced by the composable templates introduced in Elasticsearch 7.8.
/// </para>
/// <para>
/// Composable templates always take precedence over legacy templates.
/// If no composable template matches a new index, matching legacy templates are applied according to their order.
/// </para>
/// <para>
/// Index templates are only applied during index creation.
/// Changes to index templates do not affect existing indices.
/// Settings and mappings specified in create index API requests override any settings or mappings specified in an index template.
/// </para>
/// <para>
/// You can use C-style <c>/* *\/</c> block comments in index templates.
/// You can include comments anywhere in the request body, except before the opening curly bracket.
/// </para>
/// <para>
/// <strong>Indices matching multiple templates</strong>
/// </para>
/// <para>
/// Multiple index templates can potentially match an index, in this case, both the settings and mappings are merged into the final configuration of the index.
/// The order of the merging can be controlled using the order parameter, with lower order being applied first, and higher orders overriding them.
/// NOTE: Multiple matching templates with the same order value will result in a non-deterministic merging order.
/// </para>
/// </summary>
public readonly partial struct PutTemplateRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest instance)
	{
		Instance = instance;
	}

	public PutTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.Name name)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest(name);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutTemplateRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest(Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the template
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// User defined reason for creating/updating the index template
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Cause(string? value)
	{
		Instance.Cause = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, this request cannot replace or update existing index templates.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Create(bool? value = true)
	{
		Instance.Create = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node. If no response is
	/// received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Aliases(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>? value)
	{
		Instance.Aliases = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Aliases()
	{
		Instance.Aliases = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfIndexNameAlias.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Aliases(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfIndexNameAlias>? action)
	{
		Instance.Aliases = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfIndexNameAlias.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Aliases<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfIndexNameAlias<T>>? action)
	{
		Instance.Aliases = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfIndexNameAlias<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor AddAlias(Elastic.Clients.Elasticsearch.IndexName key, Elastic.Clients.Elasticsearch.IndexManagement.Alias value)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Aliases(Elastic.Clients.Elasticsearch.IndexName key)
	{
		Instance.Aliases = new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias> { { key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor.Build(null) } };
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Aliases(params Elastic.Clients.Elasticsearch.IndexName[] keys)
	{
		var items = new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		foreach (var key in keys)
		{
			items.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor.Build(null));
		}

		Instance.Aliases = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor AddAlias(Elastic.Clients.Elasticsearch.IndexName key)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor AddAlias(Elastic.Clients.Elasticsearch.IndexName key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor>? action)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor AddAlias<T>(Elastic.Clients.Elasticsearch.IndexName key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<T>>? action)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<T>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard expressions used to match the names
	/// of indices during creation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor IndexPatterns(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.IndexPatterns = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard expressions used to match the names
	/// of indices during creation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor IndexPatterns(params string[] values)
	{
		Instance.IndexPatterns = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping for fields in the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Mappings(Elastic.Clients.Elasticsearch.Mapping.TypeMapping? value)
	{
		Instance.Mappings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping for fields in the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Mappings()
	{
		Instance.Mappings = Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping for fields in the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Mappings(System.Action<Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor>? action)
	{
		Instance.Mappings = Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping for fields in the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Mappings<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<T>>? action)
	{
		Instance.Mappings = Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Order in which Elasticsearch applies this template if index
	/// matches multiple templates.
	/// </para>
	/// <para>
	/// Templates with lower 'order' values are merged first. Templates with higher
	/// 'order' values are merged later, overriding templates with lower values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Order(int? value)
	{
		Instance.Order = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Settings(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings? value)
	{
		Instance.Settings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Settings()
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Settings(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor>? action)
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Settings<T>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<T>>? action)
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Version number used to manage index templates externally. This number
	/// is not automatically generated by Elasticsearch.
	/// To unset a version, replace the template without specifying one.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Version(long? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Create or update a legacy index template.
/// Index templates define settings, mappings, and aliases that can be applied automatically to new indices.
/// Elasticsearch applies templates to new indices based on an index pattern that matches the index name.
/// </para>
/// <para>
/// IMPORTANT: This documentation is about legacy index templates, which are deprecated and will be replaced by the composable templates introduced in Elasticsearch 7.8.
/// </para>
/// <para>
/// Composable templates always take precedence over legacy templates.
/// If no composable template matches a new index, matching legacy templates are applied according to their order.
/// </para>
/// <para>
/// Index templates are only applied during index creation.
/// Changes to index templates do not affect existing indices.
/// Settings and mappings specified in create index API requests override any settings or mappings specified in an index template.
/// </para>
/// <para>
/// You can use C-style <c>/* *\/</c> block comments in index templates.
/// You can include comments anywhere in the request body, except before the opening curly bracket.
/// </para>
/// <para>
/// <strong>Indices matching multiple templates</strong>
/// </para>
/// <para>
/// Multiple index templates can potentially match an index, in this case, both the settings and mappings are merged into the final configuration of the index.
/// The order of the merging can be controlled using the order parameter, with lower order being applied first, and higher orders overriding them.
/// NOTE: Multiple matching templates with the same order value will result in a non-deterministic merging order.
/// </para>
/// </summary>
public readonly partial struct PutTemplateRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest instance)
	{
		Instance = instance;
	}

	public PutTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.Name name)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest(name);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutTemplateRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest(Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the template
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// User defined reason for creating/updating the index template
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> Cause(string? value)
	{
		Instance.Cause = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, this request cannot replace or update existing index templates.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> Create(bool? value = true)
	{
		Instance.Create = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node. If no response is
	/// received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> Aliases(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>? value)
	{
		Instance.Aliases = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> Aliases()
	{
		Instance.Aliases = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfIndexNameAlias<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> Aliases(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfIndexNameAlias<TDocument>>? action)
	{
		Instance.Aliases = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfIndexNameAlias<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> AddAlias(Elastic.Clients.Elasticsearch.IndexName key, Elastic.Clients.Elasticsearch.IndexManagement.Alias value)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> Aliases(Elastic.Clients.Elasticsearch.IndexName key)
	{
		Instance.Aliases = new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias> { { key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument>.Build(null) } };
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> Aliases(params Elastic.Clients.Elasticsearch.IndexName[] keys)
	{
		var items = new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		foreach (var key in keys)
		{
			items.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument>.Build(null));
		}

		Instance.Aliases = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> AddAlias(Elastic.Clients.Elasticsearch.IndexName key)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> AddAlias(Elastic.Clients.Elasticsearch.IndexName key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument>>? action)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard expressions used to match the names
	/// of indices during creation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> IndexPatterns(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.IndexPatterns = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard expressions used to match the names
	/// of indices during creation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> IndexPatterns(params string[] values)
	{
		Instance.IndexPatterns = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping for fields in the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> Mappings(Elastic.Clients.Elasticsearch.Mapping.TypeMapping? value)
	{
		Instance.Mappings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping for fields in the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> Mappings()
	{
		Instance.Mappings = Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping for fields in the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> Mappings(System.Action<Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument>>? action)
	{
		Instance.Mappings = Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Order in which Elasticsearch applies this template if index
	/// matches multiple templates.
	/// </para>
	/// <para>
	/// Templates with lower 'order' values are merged first. Templates with higher
	/// 'order' values are merged later, overriding templates with lower values.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> Order(int? value)
	{
		Instance.Order = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> Settings(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings? value)
	{
		Instance.Settings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> Settings()
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> Settings(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument>>? action)
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Version number used to manage index templates externally. This number
	/// is not automatically generated by Elasticsearch.
	/// To unset a version, replace the template without specifying one.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> Version(long? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutTemplateRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}