// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

public sealed partial class PutMappingRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if any wildcard expression, index alias, or <c>_all</c> value targets only missing or closed indices.
	/// This behavior applies even if the request targets other open indices.
	/// </para>
	/// </summary>
	public bool? AllowNoIndices { get => Q<bool?>("allow_no_indices"); set => Q("allow_no_indices", value); }

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match.
	/// If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
	/// Supports comma-separated values, such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? ExpandWildcards { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>?>("expand_wildcards"); set => Q("expand_wildcards", value); }

	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if it targets a missing or closed index.
	/// </para>
	/// </summary>
	public bool? IgnoreUnavailable { get => Q<bool?>("ignore_unavailable"); set => Q("ignore_unavailable", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the mappings are applied only to the current write index for the target.
	/// </para>
	/// </summary>
	public bool? WriteIndexOnly { get => Q<bool?>("write_index_only"); set => Q("write_index_only", value); }
}

/// <summary>
/// <para>
/// Update field mappings.
/// Add new fields to an existing data stream or index.
/// You can use the update mapping API to:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// Add a new field to an existing index
/// </para>
/// </item>
/// <item>
/// <para>
/// Update mappings for multiple indices in a single request
/// </para>
/// </item>
/// <item>
/// <para>
/// Add new properties to an object field
/// </para>
/// </item>
/// <item>
/// <para>
/// Enable multi-fields for an existing field
/// </para>
/// </item>
/// <item>
/// <para>
/// Update supported mapping parameters
/// </para>
/// </item>
/// <item>
/// <para>
/// Change a field's mapping using reindexing
/// </para>
/// </item>
/// <item>
/// <para>
/// Rename a field using a field alias
/// </para>
/// </item>
/// </list>
/// <para>
/// Learn how to use the update mapping API with practical examples in the <a href="https://www.elastic.co/docs/manage-data/data-store/mapping/update-mappings-examples">Update mapping API examples</a> guide.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.PutMappingRequestConverter))]
public sealed partial class PutMappingRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutMappingRequest(Elastic.Clients.Elasticsearch.Indices indices) : base(r => r.Required("index", indices))
	{
	}
#if NET7_0_OR_GREATER
	public PutMappingRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutMappingRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.IndexManagementPutMapping;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "indices.put_mapping";

	/// <summary>
	/// <para>
	/// A comma-separated list of index names the mapping should be added to (supports wildcards); use <c>_all</c> or omit to add the mapping on all indices.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Indices Indices { get => P<Elastic.Clients.Elasticsearch.Indices>("index"); set => PR("index", value); }

	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if any wildcard expression, index alias, or <c>_all</c> value targets only missing or closed indices.
	/// This behavior applies even if the request targets other open indices.
	/// </para>
	/// </summary>
	public bool? AllowNoIndices { get => Q<bool?>("allow_no_indices"); set => Q("allow_no_indices", value); }

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match.
	/// If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
	/// Supports comma-separated values, such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? ExpandWildcards { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>?>("expand_wildcards"); set => Q("expand_wildcards", value); }

	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if it targets a missing or closed index.
	/// </para>
	/// </summary>
	public bool? IgnoreUnavailable { get => Q<bool?>("ignore_unavailable"); set => Q("ignore_unavailable", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the mappings are applied only to the current write index for the target.
	/// </para>
	/// </summary>
	public bool? WriteIndexOnly { get => Q<bool?>("write_index_only"); set => Q("write_index_only", value); }

	/// <summary>
	/// <para>
	/// Controls whether dynamic date detection is enabled.
	/// </para>
	/// </summary>
	public bool? DateDetection { get; set; }

	/// <summary>
	/// <para>
	/// Controls whether new fields are added dynamically.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.DynamicMapping? Dynamic { get; set; }

	/// <summary>
	/// <para>
	/// If date detection is enabled then new string fields are checked
	/// against 'dynamic_date_formats' and if the value matches then
	/// a new date field is added instead of string.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? DynamicDateFormats { get; set; }

	/// <summary>
	/// <para>
	/// Specify dynamic templates for the mapping.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>>? DynamicTemplates { get; set; }

	/// <summary>
	/// <para>
	/// Control whether field names are enabled for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.FieldNamesField? FieldNames { get; set; }

	/// <summary>
	/// <para>
	/// A mapping type can have custom meta data associated with it. These are
	/// not used at all by Elasticsearch, but can be used to store
	/// application-specific metadata.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Meta { get; set; }

	/// <summary>
	/// <para>
	/// Automatically map strings into numeric data types for all fields.
	/// </para>
	/// </summary>
	public bool? NumericDetection { get; set; }

	/// <summary>
	/// <para>
	/// Mapping for a field. For new fields, this mapping can include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Field name
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Field data type
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Mapping parameters
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.Properties? Properties { get; set; }

	/// <summary>
	/// <para>
	/// Enable making a routing value required on indexed documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.RoutingField? Routing { get; set; }

	/// <summary>
	/// <para>
	/// Mapping of runtime fields for the index.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? Runtime { get; set; }

	/// <summary>
	/// <para>
	/// Control whether the _source field is enabled on the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.SourceField? Source { get; set; }
}

/// <summary>
/// <para>
/// Update field mappings.
/// Add new fields to an existing data stream or index.
/// You can use the update mapping API to:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// Add a new field to an existing index
/// </para>
/// </item>
/// <item>
/// <para>
/// Update mappings for multiple indices in a single request
/// </para>
/// </item>
/// <item>
/// <para>
/// Add new properties to an object field
/// </para>
/// </item>
/// <item>
/// <para>
/// Enable multi-fields for an existing field
/// </para>
/// </item>
/// <item>
/// <para>
/// Update supported mapping parameters
/// </para>
/// </item>
/// <item>
/// <para>
/// Change a field's mapping using reindexing
/// </para>
/// </item>
/// <item>
/// <para>
/// Rename a field using a field alias
/// </para>
/// </item>
/// </list>
/// <para>
/// Learn how to use the update mapping API with practical examples in the <a href="https://www.elastic.co/docs/manage-data/data-store/mapping/update-mappings-examples">Update mapping API examples</a> guide.
/// </para>
/// </summary>
public readonly partial struct PutMappingRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutMappingRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest instance)
	{
		Instance = instance;
	}

	public PutMappingRequestDescriptor(Elastic.Clients.Elasticsearch.Indices indices)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest(indices);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutMappingRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest(Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A comma-separated list of index names the mapping should be added to (supports wildcards); use <c>_all</c> or omit to add the mapping on all indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Indices(Elastic.Clients.Elasticsearch.Indices value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if any wildcard expression, index alias, or <c>_all</c> value targets only missing or closed indices.
	/// This behavior applies even if the request targets other open indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor AllowNoIndices(bool? value = true)
	{
		Instance.AllowNoIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match.
	/// If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
	/// Supports comma-separated values, such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor ExpandWildcards(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? value)
	{
		Instance.ExpandWildcards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match.
	/// If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
	/// Supports comma-separated values, such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor ExpandWildcards(params Elastic.Clients.Elasticsearch.ExpandWildcard[] values)
	{
		Instance.ExpandWildcards = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if it targets a missing or closed index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor IgnoreUnavailable(bool? value = true)
	{
		Instance.IgnoreUnavailable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the mappings are applied only to the current write index for the target.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor WriteIndexOnly(bool? value = true)
	{
		Instance.WriteIndexOnly = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls whether dynamic date detection is enabled.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor DateDetection(bool? value = true)
	{
		Instance.DateDetection = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls whether new fields are added dynamically.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Dynamic(Elastic.Clients.Elasticsearch.Mapping.DynamicMapping? value)
	{
		Instance.Dynamic = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If date detection is enabled then new string fields are checked
	/// against 'dynamic_date_formats' and if the value matches then
	/// a new date field is added instead of string.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor DynamicDateFormats(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.DynamicDateFormats = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If date detection is enabled then new string fields are checked
	/// against 'dynamic_date_formats' and if the value matches then
	/// a new date field is added instead of string.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor DynamicDateFormats(params string[] values)
	{
		Instance.DynamicDateFormats = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify dynamic templates for the mapping.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor DynamicTemplates(System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>>? value)
	{
		Instance.DynamicTemplates = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify dynamic templates for the mapping.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor DynamicTemplates()
	{
		Instance.DynamicTemplates = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringDynamicTemplate.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify dynamic templates for the mapping.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor DynamicTemplates(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringDynamicTemplate>? action)
	{
		Instance.DynamicTemplates = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringDynamicTemplate.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify dynamic templates for the mapping.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor DynamicTemplates<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringDynamicTemplate<T>>? action)
	{
		Instance.DynamicTemplates = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringDynamicTemplate<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor AddDynamicTemplate(string key, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate value)
	{
		Instance.DynamicTemplates ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>>();
		Instance.DynamicTemplates.Add(new System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>(key, value));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor AddDynamicTemplate(string key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor> action)
	{
		Instance.DynamicTemplates ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>>();
		Instance.DynamicTemplates.Add(new System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>(key, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor.Build(action)));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor AddDynamicTemplate<T>(string key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<T>> action)
	{
		Instance.DynamicTemplates ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>>();
		Instance.DynamicTemplates.Add(new System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>(key, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<T>.Build(action)));
		return this;
	}

	/// <summary>
	/// <para>
	/// Control whether field names are enabled for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor FieldNames(Elastic.Clients.Elasticsearch.Mapping.FieldNamesField? value)
	{
		Instance.FieldNames = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Control whether field names are enabled for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor FieldNames(System.Action<Elastic.Clients.Elasticsearch.Mapping.FieldNamesFieldDescriptor> action)
	{
		Instance.FieldNames = Elastic.Clients.Elasticsearch.Mapping.FieldNamesFieldDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A mapping type can have custom meta data associated with it. These are
	/// not used at all by Elasticsearch, but can be used to store
	/// application-specific metadata.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Meta(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Meta = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A mapping type can have custom meta data associated with it. These are
	/// not used at all by Elasticsearch, but can be used to store
	/// application-specific metadata.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// A mapping type can have custom meta data associated with it. These are
	/// not used at all by Elasticsearch, but can be used to store
	/// application-specific metadata.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor AddMeta(string key, object value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Meta.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Automatically map strings into numeric data types for all fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor NumericDetection(bool? value = true)
	{
		Instance.NumericDetection = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping for a field. For new fields, this mapping can include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Field name
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Field data type
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Mapping parameters
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Properties(Elastic.Clients.Elasticsearch.Mapping.Properties? value)
	{
		Instance.Properties = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping for a field. For new fields, this mapping can include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Field name
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Field data type
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Mapping parameters
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Properties(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor> action)
	{
		Instance.Properties = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping for a field. For new fields, this mapping can include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Field name
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Field data type
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Mapping parameters
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Properties<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<T>> action)
	{
		Instance.Properties = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Enable making a routing value required on indexed documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Routing(Elastic.Clients.Elasticsearch.Mapping.RoutingField? value)
	{
		Instance.Routing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Enable making a routing value required on indexed documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Routing(System.Action<Elastic.Clients.Elasticsearch.Mapping.RoutingFieldDescriptor> action)
	{
		Instance.Routing = Elastic.Clients.Elasticsearch.Mapping.RoutingFieldDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping of runtime fields for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Runtime(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.Runtime = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping of runtime fields for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Runtime()
	{
		Instance.Runtime = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping of runtime fields for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Runtime(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField>? action)
	{
		Instance.Runtime = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping of runtime fields for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Runtime<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>>? action)
	{
		Instance.Runtime = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor AddRuntime(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.Runtime ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.Runtime.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor AddRuntime<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.Runtime ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.Runtime.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor AddRuntime(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.Runtime ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.Runtime.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor AddRuntime<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.Runtime ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.Runtime.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor AddRuntime<T>(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.Runtime ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.Runtime.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor AddRuntime<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.Runtime ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.Runtime.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Control whether the _source field is enabled on the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Source(Elastic.Clients.Elasticsearch.Mapping.SourceField? value)
	{
		Instance.Source = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Control whether the _source field is enabled on the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Source()
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Mapping.SourceFieldDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Control whether the _source field is enabled on the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Source(System.Action<Elastic.Clients.Elasticsearch.Mapping.SourceFieldDescriptor>? action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Mapping.SourceFieldDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Update field mappings.
/// Add new fields to an existing data stream or index.
/// You can use the update mapping API to:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// Add a new field to an existing index
/// </para>
/// </item>
/// <item>
/// <para>
/// Update mappings for multiple indices in a single request
/// </para>
/// </item>
/// <item>
/// <para>
/// Add new properties to an object field
/// </para>
/// </item>
/// <item>
/// <para>
/// Enable multi-fields for an existing field
/// </para>
/// </item>
/// <item>
/// <para>
/// Update supported mapping parameters
/// </para>
/// </item>
/// <item>
/// <para>
/// Change a field's mapping using reindexing
/// </para>
/// </item>
/// <item>
/// <para>
/// Rename a field using a field alias
/// </para>
/// </item>
/// </list>
/// <para>
/// Learn how to use the update mapping API with practical examples in the <a href="https://www.elastic.co/docs/manage-data/data-store/mapping/update-mappings-examples">Update mapping API examples</a> guide.
/// </para>
/// </summary>
public readonly partial struct PutMappingRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutMappingRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest instance)
	{
		Instance = instance;
	}

	public PutMappingRequestDescriptor(Elastic.Clients.Elasticsearch.Indices indices)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest(indices);
	}

	public PutMappingRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest(typeof(TDocument));
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest(Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A comma-separated list of index names the mapping should be added to (supports wildcards); use <c>_all</c> or omit to add the mapping on all indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> Indices(Elastic.Clients.Elasticsearch.Indices value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if any wildcard expression, index alias, or <c>_all</c> value targets only missing or closed indices.
	/// This behavior applies even if the request targets other open indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> AllowNoIndices(bool? value = true)
	{
		Instance.AllowNoIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match.
	/// If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
	/// Supports comma-separated values, such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> ExpandWildcards(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? value)
	{
		Instance.ExpandWildcards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match.
	/// If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
	/// Supports comma-separated values, such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> ExpandWildcards(params Elastic.Clients.Elasticsearch.ExpandWildcard[] values)
	{
		Instance.ExpandWildcards = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error if it targets a missing or closed index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> IgnoreUnavailable(bool? value = true)
	{
		Instance.IgnoreUnavailable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the mappings are applied only to the current write index for the target.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> WriteIndexOnly(bool? value = true)
	{
		Instance.WriteIndexOnly = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls whether dynamic date detection is enabled.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> DateDetection(bool? value = true)
	{
		Instance.DateDetection = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls whether new fields are added dynamically.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> Dynamic(Elastic.Clients.Elasticsearch.Mapping.DynamicMapping? value)
	{
		Instance.Dynamic = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If date detection is enabled then new string fields are checked
	/// against 'dynamic_date_formats' and if the value matches then
	/// a new date field is added instead of string.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> DynamicDateFormats(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.DynamicDateFormats = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If date detection is enabled then new string fields are checked
	/// against 'dynamic_date_formats' and if the value matches then
	/// a new date field is added instead of string.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> DynamicDateFormats(params string[] values)
	{
		Instance.DynamicDateFormats = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify dynamic templates for the mapping.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> DynamicTemplates(System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>>? value)
	{
		Instance.DynamicTemplates = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify dynamic templates for the mapping.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> DynamicTemplates()
	{
		Instance.DynamicTemplates = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringDynamicTemplate<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify dynamic templates for the mapping.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> DynamicTemplates(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringDynamicTemplate<TDocument>>? action)
	{
		Instance.DynamicTemplates = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfStringDynamicTemplate<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> AddDynamicTemplate(string key, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate value)
	{
		Instance.DynamicTemplates ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>>();
		Instance.DynamicTemplates.Add(new System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>(key, value));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> AddDynamicTemplate(string key, System.Action<Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument>> action)
	{
		Instance.DynamicTemplates ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>>();
		Instance.DynamicTemplates.Add(new System.Collections.Generic.KeyValuePair<string, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplate>(key, Elastic.Clients.Elasticsearch.Mapping.DynamicTemplateDescriptor<TDocument>.Build(action)));
		return this;
	}

	/// <summary>
	/// <para>
	/// Control whether field names are enabled for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> FieldNames(Elastic.Clients.Elasticsearch.Mapping.FieldNamesField? value)
	{
		Instance.FieldNames = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Control whether field names are enabled for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> FieldNames(System.Action<Elastic.Clients.Elasticsearch.Mapping.FieldNamesFieldDescriptor> action)
	{
		Instance.FieldNames = Elastic.Clients.Elasticsearch.Mapping.FieldNamesFieldDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A mapping type can have custom meta data associated with it. These are
	/// not used at all by Elasticsearch, but can be used to store
	/// application-specific metadata.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> Meta(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Meta = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A mapping type can have custom meta data associated with it. These are
	/// not used at all by Elasticsearch, but can be used to store
	/// application-specific metadata.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// A mapping type can have custom meta data associated with it. These are
	/// not used at all by Elasticsearch, but can be used to store
	/// application-specific metadata.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> AddMeta(string key, object value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Meta.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Automatically map strings into numeric data types for all fields.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> NumericDetection(bool? value = true)
	{
		Instance.NumericDetection = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping for a field. For new fields, this mapping can include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Field name
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Field data type
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Mapping parameters
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> Properties(Elastic.Clients.Elasticsearch.Mapping.Properties? value)
	{
		Instance.Properties = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping for a field. For new fields, this mapping can include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Field name
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Field data type
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Mapping parameters
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> Properties(System.Action<Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>> action)
	{
		Instance.Properties = Elastic.Clients.Elasticsearch.Mapping.PropertiesDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Enable making a routing value required on indexed documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> Routing(Elastic.Clients.Elasticsearch.Mapping.RoutingField? value)
	{
		Instance.Routing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Enable making a routing value required on indexed documents.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> Routing(System.Action<Elastic.Clients.Elasticsearch.Mapping.RoutingFieldDescriptor> action)
	{
		Instance.Routing = Elastic.Clients.Elasticsearch.Mapping.RoutingFieldDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping of runtime fields for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> Runtime(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.Runtime = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping of runtime fields for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> Runtime()
	{
		Instance.Runtime = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping of runtime fields for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> Runtime(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>>? action)
	{
		Instance.Runtime = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> AddRuntime(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.Runtime ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.Runtime.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> AddRuntime(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.Runtime ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.Runtime.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> AddRuntime(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.Runtime ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.Runtime.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> AddRuntime(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.Runtime ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.Runtime.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Control whether the _source field is enabled on the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> Source(Elastic.Clients.Elasticsearch.Mapping.SourceField? value)
	{
		Instance.Source = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Control whether the _source field is enabled on the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> Source()
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Mapping.SourceFieldDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Control whether the _source field is enabled on the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> Source(System.Action<Elastic.Clients.Elasticsearch.Mapping.SourceFieldDescriptor>? action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Mapping.SourceFieldDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutMappingRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}