// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

public sealed partial class PutIndexTemplateRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// User defined reason for creating/updating the index template
	/// </para>
	/// </summary>
	public string? Cause { get => Q<string?>("cause"); set => Q("cause", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, this request cannot replace or update existing index templates.
	/// </para>
	/// </summary>
	public bool? Create { get => Q<bool?>("create"); set => Q("create", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }
}

/// <summary>
/// <para>
/// Create or update an index template.
/// Index templates define settings, mappings, and aliases that can be applied automatically to new indices.
/// </para>
/// <para>
/// Elasticsearch applies templates to new indices based on an wildcard pattern that matches the index name.
/// Index templates are applied during data stream or index creation.
/// For data streams, these settings and mappings are applied when the stream's backing indices are created.
/// Settings and mappings specified in a create index API request override any settings or mappings specified in an index template.
/// Changes to index templates do not affect existing indices, including the existing backing indices of a data stream.
/// </para>
/// <para>
/// You can use C-style <c>/* *\/</c> block comments in index templates.
/// You can include comments anywhere in the request body, except before the opening curly bracket.
/// </para>
/// <para>
/// <strong>Multiple matching templates</strong>
/// </para>
/// <para>
/// If multiple index templates match the name of a new index or data stream, the template with the highest priority is used.
/// </para>
/// <para>
/// Multiple templates with overlapping index patterns at the same priority are not allowed and an error will be thrown when attempting to create a template matching an existing index template at identical priorities.
/// </para>
/// <para>
/// <strong>Composing aliases, mappings, and settings</strong>
/// </para>
/// <para>
/// When multiple component templates are specified in the <c>composed_of</c> field for an index template, they are merged in the order specified, meaning that later component templates override earlier component templates.
/// Any mappings, settings, or aliases from the parent index template are merged in next.
/// Finally, any configuration on the index request itself is merged.
/// Mapping definitions are merged recursively, which means that later mapping components can introduce new field mappings and update the mapping configuration.
/// If a field mapping is already contained in an earlier component, its definition will be completely overwritten by the later one.
/// This recursive merging strategy applies not only to field mappings, but also root options like <c>dynamic_templates</c> and <c>meta</c>.
/// If an earlier component contains a <c>dynamic_templates</c> block, then by default new <c>dynamic_templates</c> entries are appended onto the end.
/// If an entry already exists with the same key, then it is overwritten by the new definition.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.PutIndexTemplateRequestConverter))]
public sealed partial class PutIndexTemplateRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutIndexTemplateRequest(Elastic.Clients.Elasticsearch.Name name) : base(r => r.Required("name", name))
	{
	}
#if NET7_0_OR_GREATER
	public PutIndexTemplateRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutIndexTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.IndexManagementPutIndexTemplate;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "indices.put_index_template";

	/// <summary>
	/// <para>
	/// Index or template name
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name Name { get => P<Elastic.Clients.Elasticsearch.Name>("name"); set => PR("name", value); }

	/// <summary>
	/// <para>
	/// User defined reason for creating/updating the index template
	/// </para>
	/// </summary>
	public string? Cause { get => Q<string?>("cause"); set => Q("cause", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, this request cannot replace or update existing index templates.
	/// </para>
	/// </summary>
	public bool? Create { get => Q<bool?>("create"); set => Q("create", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// This setting overrides the value of the <c>action.auto_create_index</c> cluster setting.
	/// If set to <c>true</c> in a template, then indices can be automatically created using that template even if auto-creation of indices is disabled via <c>actions.auto_create_index</c>.
	/// If set to <c>false</c>, then indices or data streams matching the template must always be explicitly created, and may never be automatically created.
	/// </para>
	/// </summary>
	public bool? AllowAutoCreate { get; set; }

	/// <summary>
	/// <para>
	/// An ordered list of component template names.
	/// Component templates are merged in the order specified, meaning that the last component template specified has the highest precedence.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Name>? ComposedOf { get; set; }

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamVisibility? DataStream { get; set; }

	/// <summary>
	/// <para>
	/// Marks this index template as deprecated. When creating or updating a non-deprecated index template
	/// that uses deprecated components, Elasticsearch will emit a deprecation warning.
	/// </para>
	/// </summary>
	public bool? Deprecated { get; set; }

	/// <summary>
	/// <para>
	/// The configuration option ignore_missing_component_templates can be used when an index template
	/// references a component template that might not exist
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? IgnoreMissingComponentTemplates { get; set; }

	/// <summary>
	/// <para>
	/// Name of the index template to create.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Indices? IndexPatterns { get; set; }

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template.
	/// It may have any contents.
	/// It is not automatically generated or used by Elasticsearch.
	/// This user-defined object is stored in the cluster state, so keeping it short is preferable
	/// To unset the metadata, replace the template without specifying it.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Meta { get; set; }

	/// <summary>
	/// <para>
	/// Priority to determine index template precedence when a new data stream or index is created.
	/// The index template with the highest priority is chosen.
	/// If no priority is specified the template is treated as though it is of priority 0 (lowest priority).
	/// This number is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public long? Priority { get; set; }

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMapping? Template { get; set; }

	/// <summary>
	/// <para>
	/// Version number used to manage index templates externally.
	/// This number is not automatically generated by Elasticsearch.
	/// External systems can use these version numbers to simplify template management.
	/// To unset a version, replace the template without specifying one.
	/// </para>
	/// </summary>
	public long? Version { get; set; }
}

/// <summary>
/// <para>
/// Create or update an index template.
/// Index templates define settings, mappings, and aliases that can be applied automatically to new indices.
/// </para>
/// <para>
/// Elasticsearch applies templates to new indices based on an wildcard pattern that matches the index name.
/// Index templates are applied during data stream or index creation.
/// For data streams, these settings and mappings are applied when the stream's backing indices are created.
/// Settings and mappings specified in a create index API request override any settings or mappings specified in an index template.
/// Changes to index templates do not affect existing indices, including the existing backing indices of a data stream.
/// </para>
/// <para>
/// You can use C-style <c>/* *\/</c> block comments in index templates.
/// You can include comments anywhere in the request body, except before the opening curly bracket.
/// </para>
/// <para>
/// <strong>Multiple matching templates</strong>
/// </para>
/// <para>
/// If multiple index templates match the name of a new index or data stream, the template with the highest priority is used.
/// </para>
/// <para>
/// Multiple templates with overlapping index patterns at the same priority are not allowed and an error will be thrown when attempting to create a template matching an existing index template at identical priorities.
/// </para>
/// <para>
/// <strong>Composing aliases, mappings, and settings</strong>
/// </para>
/// <para>
/// When multiple component templates are specified in the <c>composed_of</c> field for an index template, they are merged in the order specified, meaning that later component templates override earlier component templates.
/// Any mappings, settings, or aliases from the parent index template are merged in next.
/// Finally, any configuration on the index request itself is merged.
/// Mapping definitions are merged recursively, which means that later mapping components can introduce new field mappings and update the mapping configuration.
/// If a field mapping is already contained in an earlier component, its definition will be completely overwritten by the later one.
/// This recursive merging strategy applies not only to field mappings, but also root options like <c>dynamic_templates</c> and <c>meta</c>.
/// If an earlier component contains a <c>dynamic_templates</c> block, then by default new <c>dynamic_templates</c> entries are appended onto the end.
/// If an entry already exists with the same key, then it is overwritten by the new definition.
/// </para>
/// </summary>
public readonly partial struct PutIndexTemplateRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutIndexTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest instance)
	{
		Instance = instance;
	}

	public PutIndexTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.Name name)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest(name);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutIndexTemplateRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest(Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Index or template name
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// User defined reason for creating/updating the index template
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor Cause(string? value)
	{
		Instance.Cause = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, this request cannot replace or update existing index templates.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor Create(bool? value = true)
	{
		Instance.Create = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting overrides the value of the <c>action.auto_create_index</c> cluster setting.
	/// If set to <c>true</c> in a template, then indices can be automatically created using that template even if auto-creation of indices is disabled via <c>actions.auto_create_index</c>.
	/// If set to <c>false</c>, then indices or data streams matching the template must always be explicitly created, and may never be automatically created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor AllowAutoCreate(bool? value = true)
	{
		Instance.AllowAutoCreate = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An ordered list of component template names.
	/// Component templates are merged in the order specified, meaning that the last component template specified has the highest precedence.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor ComposedOf(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Name>? value)
	{
		Instance.ComposedOf = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An ordered list of component template names.
	/// Component templates are merged in the order specified, meaning that the last component template specified has the highest precedence.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor ComposedOf(params Elastic.Clients.Elasticsearch.Name[] values)
	{
		Instance.ComposedOf = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor DataStream(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamVisibility? value)
	{
		Instance.DataStream = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor DataStream()
	{
		Instance.DataStream = Elastic.Clients.Elasticsearch.IndexManagement.DataStreamVisibilityDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor DataStream(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamVisibilityDescriptor>? action)
	{
		Instance.DataStream = Elastic.Clients.Elasticsearch.IndexManagement.DataStreamVisibilityDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Marks this index template as deprecated. When creating or updating a non-deprecated index template
	/// that uses deprecated components, Elasticsearch will emit a deprecation warning.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor Deprecated(bool? value = true)
	{
		Instance.Deprecated = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration option ignore_missing_component_templates can be used when an index template
	/// references a component template that might not exist
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor IgnoreMissingComponentTemplates(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.IgnoreMissingComponentTemplates = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration option ignore_missing_component_templates can be used when an index template
	/// references a component template that might not exist
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor IgnoreMissingComponentTemplates(params string[] values)
	{
		Instance.IgnoreMissingComponentTemplates = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the index template to create.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor IndexPatterns(Elastic.Clients.Elasticsearch.Indices? value)
	{
		Instance.IndexPatterns = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template.
	/// It may have any contents.
	/// It is not automatically generated or used by Elasticsearch.
	/// This user-defined object is stored in the cluster state, so keeping it short is preferable
	/// To unset the metadata, replace the template without specifying it.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor Meta(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Meta = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template.
	/// It may have any contents.
	/// It is not automatically generated or used by Elasticsearch.
	/// This user-defined object is stored in the cluster state, so keeping it short is preferable
	/// To unset the metadata, replace the template without specifying it.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template.
	/// It may have any contents.
	/// It is not automatically generated or used by Elasticsearch.
	/// This user-defined object is stored in the cluster state, so keeping it short is preferable
	/// To unset the metadata, replace the template without specifying it.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor AddMeta(string key, object value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Meta.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Priority to determine index template precedence when a new data stream or index is created.
	/// The index template with the highest priority is chosen.
	/// If no priority is specified the template is treated as though it is of priority 0 (lowest priority).
	/// This number is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor Priority(long? value)
	{
		Instance.Priority = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor Template(Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMapping? value)
	{
		Instance.Template = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor Template()
	{
		Instance.Template = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMappingDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor Template(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMappingDescriptor>? action)
	{
		Instance.Template = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMappingDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor Template<T>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMappingDescriptor<T>>? action)
	{
		Instance.Template = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMappingDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Version number used to manage index templates externally.
	/// This number is not automatically generated by Elasticsearch.
	/// External systems can use these version numbers to simplify template management.
	/// To unset a version, replace the template without specifying one.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor Version(long? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Create or update an index template.
/// Index templates define settings, mappings, and aliases that can be applied automatically to new indices.
/// </para>
/// <para>
/// Elasticsearch applies templates to new indices based on an wildcard pattern that matches the index name.
/// Index templates are applied during data stream or index creation.
/// For data streams, these settings and mappings are applied when the stream's backing indices are created.
/// Settings and mappings specified in a create index API request override any settings or mappings specified in an index template.
/// Changes to index templates do not affect existing indices, including the existing backing indices of a data stream.
/// </para>
/// <para>
/// You can use C-style <c>/* *\/</c> block comments in index templates.
/// You can include comments anywhere in the request body, except before the opening curly bracket.
/// </para>
/// <para>
/// <strong>Multiple matching templates</strong>
/// </para>
/// <para>
/// If multiple index templates match the name of a new index or data stream, the template with the highest priority is used.
/// </para>
/// <para>
/// Multiple templates with overlapping index patterns at the same priority are not allowed and an error will be thrown when attempting to create a template matching an existing index template at identical priorities.
/// </para>
/// <para>
/// <strong>Composing aliases, mappings, and settings</strong>
/// </para>
/// <para>
/// When multiple component templates are specified in the <c>composed_of</c> field for an index template, they are merged in the order specified, meaning that later component templates override earlier component templates.
/// Any mappings, settings, or aliases from the parent index template are merged in next.
/// Finally, any configuration on the index request itself is merged.
/// Mapping definitions are merged recursively, which means that later mapping components can introduce new field mappings and update the mapping configuration.
/// If a field mapping is already contained in an earlier component, its definition will be completely overwritten by the later one.
/// This recursive merging strategy applies not only to field mappings, but also root options like <c>dynamic_templates</c> and <c>meta</c>.
/// If an earlier component contains a <c>dynamic_templates</c> block, then by default new <c>dynamic_templates</c> entries are appended onto the end.
/// If an entry already exists with the same key, then it is overwritten by the new definition.
/// </para>
/// </summary>
public readonly partial struct PutIndexTemplateRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutIndexTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest instance)
	{
		Instance = instance;
	}

	public PutIndexTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.Name name)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest(name);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutIndexTemplateRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest(Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Index or template name
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// User defined reason for creating/updating the index template
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> Cause(string? value)
	{
		Instance.Cause = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, this request cannot replace or update existing index templates.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> Create(bool? value = true)
	{
		Instance.Create = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This setting overrides the value of the <c>action.auto_create_index</c> cluster setting.
	/// If set to <c>true</c> in a template, then indices can be automatically created using that template even if auto-creation of indices is disabled via <c>actions.auto_create_index</c>.
	/// If set to <c>false</c>, then indices or data streams matching the template must always be explicitly created, and may never be automatically created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> AllowAutoCreate(bool? value = true)
	{
		Instance.AllowAutoCreate = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An ordered list of component template names.
	/// Component templates are merged in the order specified, meaning that the last component template specified has the highest precedence.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> ComposedOf(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Name>? value)
	{
		Instance.ComposedOf = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An ordered list of component template names.
	/// Component templates are merged in the order specified, meaning that the last component template specified has the highest precedence.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> ComposedOf(params Elastic.Clients.Elasticsearch.Name[] values)
	{
		Instance.ComposedOf = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> DataStream(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamVisibility? value)
	{
		Instance.DataStream = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> DataStream()
	{
		Instance.DataStream = Elastic.Clients.Elasticsearch.IndexManagement.DataStreamVisibilityDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> DataStream(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamVisibilityDescriptor>? action)
	{
		Instance.DataStream = Elastic.Clients.Elasticsearch.IndexManagement.DataStreamVisibilityDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Marks this index template as deprecated. When creating or updating a non-deprecated index template
	/// that uses deprecated components, Elasticsearch will emit a deprecation warning.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> Deprecated(bool? value = true)
	{
		Instance.Deprecated = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration option ignore_missing_component_templates can be used when an index template
	/// references a component template that might not exist
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> IgnoreMissingComponentTemplates(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.IgnoreMissingComponentTemplates = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The configuration option ignore_missing_component_templates can be used when an index template
	/// references a component template that might not exist
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> IgnoreMissingComponentTemplates(params string[] values)
	{
		Instance.IgnoreMissingComponentTemplates = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the index template to create.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> IndexPatterns(Elastic.Clients.Elasticsearch.Indices? value)
	{
		Instance.IndexPatterns = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template.
	/// It may have any contents.
	/// It is not automatically generated or used by Elasticsearch.
	/// This user-defined object is stored in the cluster state, so keeping it short is preferable
	/// To unset the metadata, replace the template without specifying it.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> Meta(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Meta = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template.
	/// It may have any contents.
	/// It is not automatically generated or used by Elasticsearch.
	/// This user-defined object is stored in the cluster state, so keeping it short is preferable
	/// To unset the metadata, replace the template without specifying it.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template.
	/// It may have any contents.
	/// It is not automatically generated or used by Elasticsearch.
	/// This user-defined object is stored in the cluster state, so keeping it short is preferable
	/// To unset the metadata, replace the template without specifying it.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> AddMeta(string key, object value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Meta.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Priority to determine index template precedence when a new data stream or index is created.
	/// The index template with the highest priority is chosen.
	/// If no priority is specified the template is treated as though it is of priority 0 (lowest priority).
	/// This number is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> Priority(long? value)
	{
		Instance.Priority = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> Template(Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMapping? value)
	{
		Instance.Template = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> Template()
	{
		Instance.Template = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMappingDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> Template(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMappingDescriptor<TDocument>>? action)
	{
		Instance.Template = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateMappingDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Version number used to manage index templates externally.
	/// This number is not automatically generated by Elasticsearch.
	/// External systems can use these version numbers to simplify template management.
	/// To unset a version, replace the template without specifying one.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> Version(long? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutIndexTemplateRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}