// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

public sealed partial class PutDataStreamSettingsRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If <c>true</c>, the request does not actually change the settings on any data streams or indices. Instead, it
	/// simulates changing the settings and reports back to the user what would have happened had these settings
	/// actually been applied.
	/// </para>
	/// </summary>
	public bool? DryRun { get => Q<bool?>("dry_run"); set => Q("dry_run", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node. If no response is
	/// received before the timeout expires, the request fails and returns an
	/// error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a response. If no response is received before the
	/// timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Update data stream settings.
/// </para>
/// <para>
/// This API can be used to override settings on specific data streams. These overrides will take precedence over what
/// is specified in the template that the data stream matches. To prevent your data stream from getting into an invalid state,
/// only certain settings are allowed. If possible, the setting change is applied to all
/// backing indices. Otherwise, it will be applied when the data stream is next rolled over.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.PutDataStreamSettingsRequestConverter))]
public sealed partial class PutDataStreamSettingsRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutDataStreamSettingsRequest(Elastic.Clients.Elasticsearch.Indices name) : base(r => r.Required("name", name))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutDataStreamSettingsRequest(Elastic.Clients.Elasticsearch.Indices name, Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings settings) : base(r => r.Required("name", name))
	{
		Settings = settings;
	}
#if NET7_0_OR_GREATER
	public PutDataStreamSettingsRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutDataStreamSettingsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.IndexManagementPutDataStreamSettings;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "indices.put_data_stream_settings";

	/// <summary>
	/// <para>
	/// A comma-separated list of data streams or data stream patterns.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Indices Name { get => P<Elastic.Clients.Elasticsearch.Indices>("name"); set => PR("name", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request does not actually change the settings on any data streams or indices. Instead, it
	/// simulates changing the settings and reports back to the user what would have happened had these settings
	/// actually been applied.
	/// </para>
	/// </summary>
	public bool? DryRun { get => Q<bool?>("dry_run"); set => Q("dry_run", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node. If no response is
	/// received before the timeout expires, the request fails and returns an
	/// error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a response. If no response is received before the
	/// timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings Settings { get; set; }
}

/// <summary>
/// <para>
/// Update data stream settings.
/// </para>
/// <para>
/// This API can be used to override settings on specific data streams. These overrides will take precedence over what
/// is specified in the template that the data stream matches. To prevent your data stream from getting into an invalid state,
/// only certain settings are allowed. If possible, the setting change is applied to all
/// backing indices. Otherwise, it will be applied when the data stream is next rolled over.
/// </para>
/// </summary>
public readonly partial struct PutDataStreamSettingsRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutDataStreamSettingsRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest instance)
	{
		Instance = instance;
	}

	public PutDataStreamSettingsRequestDescriptor(Elastic.Clients.Elasticsearch.Indices name)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest(name);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutDataStreamSettingsRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest(Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A comma-separated list of data streams or data stream patterns.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor Name(Elastic.Clients.Elasticsearch.Indices value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request does not actually change the settings on any data streams or indices. Instead, it
	/// simulates changing the settings and reports back to the user what would have happened had these settings
	/// actually been applied.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor DryRun(bool? value = true)
	{
		Instance.DryRun = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node. If no response is
	/// received before the timeout expires, the request fails and returns an
	/// error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for a response. If no response is received before the
	/// timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor Settings(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings value)
	{
		Instance.Settings = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor Settings()
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor Settings(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor>? action)
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor Settings<T>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<T>>? action)
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Update data stream settings.
/// </para>
/// <para>
/// This API can be used to override settings on specific data streams. These overrides will take precedence over what
/// is specified in the template that the data stream matches. To prevent your data stream from getting into an invalid state,
/// only certain settings are allowed. If possible, the setting change is applied to all
/// backing indices. Otherwise, it will be applied when the data stream is next rolled over.
/// </para>
/// </summary>
public readonly partial struct PutDataStreamSettingsRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutDataStreamSettingsRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest instance)
	{
		Instance = instance;
	}

	public PutDataStreamSettingsRequestDescriptor(Elastic.Clients.Elasticsearch.Indices name)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest(name);
#pragma warning restore CS0618
	}

	public PutDataStreamSettingsRequestDescriptor()
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest(typeof(TDocument));
#pragma warning restore CS0618
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest(Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A comma-separated list of data streams or data stream patterns.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument> Name(Elastic.Clients.Elasticsearch.Indices value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request does not actually change the settings on any data streams or indices. Instead, it
	/// simulates changing the settings and reports back to the user what would have happened had these settings
	/// actually been applied.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument> DryRun(bool? value = true)
	{
		Instance.DryRun = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node. If no response is
	/// received before the timeout expires, the request fails and returns an
	/// error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument> MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for a response. If no response is received before the
	/// timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument> Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument> Settings(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings value)
	{
		Instance.Settings = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument> Settings()
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument> Settings(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument>>? action)
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutDataStreamSettingsRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}