// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

public sealed partial class PutAliasRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Create or update an alias.
/// Adds a data stream or index to an alias.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.PutAliasRequestConverter))]
public sealed partial class PutAliasRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutAliasRequest(Elastic.Clients.Elasticsearch.Indices indices, Elastic.Clients.Elasticsearch.Name name) : base(r => r.Required("index", indices).Required("name", name))
	{
	}
#if NET7_0_OR_GREATER
	public PutAliasRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutAliasRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.IndexManagementPutAlias;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "indices.put_alias";

	/// <summary>
	/// <para>
	/// Comma-separated list of data streams or indices to add.
	/// Supports wildcards (<c>*</c>).
	/// Wildcard patterns that match both data streams and indices return an error.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Indices Indices { get => P<Elastic.Clients.Elasticsearch.Indices>("index"); set => PR("index", value); }

	/// <summary>
	/// <para>
	/// Alias to update.
	/// If the alias doesn’t exist, the request creates it.
	/// Index alias names support date math.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name Name { get => P<Elastic.Clients.Elasticsearch.Name>("name"); set => PR("name", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// Query used to limit documents the alias can access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? Filter { get; set; }

	/// <summary>
	/// <para>
	/// Value used to route indexing operations to a specific shard.
	/// If specified, this overwrites the <c>routing</c> value for indexing operations.
	/// Data stream aliases don’t support this parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Routing? IndexRouting { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, sets the write index or data stream for the alias.
	/// If an alias points to multiple indices or data streams and <c>is_write_index</c> isn’t set, the alias rejects write requests.
	/// If an index alias points to one index and <c>is_write_index</c> isn’t set, the index automatically acts as the write index.
	/// Data stream aliases don’t automatically set a write data stream, even if the alias points to one data stream.
	/// </para>
	/// </summary>
	public bool? IsWriteIndex { get; set; }

	/// <summary>
	/// <para>
	/// Value used to route indexing and search operations to a specific shard.
	/// Data stream aliases don’t support this parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Routing? Routing { get; set; }

	/// <summary>
	/// <para>
	/// Value used to route search operations to a specific shard.
	/// If specified, this overwrites the <c>routing</c> value for search operations.
	/// Data stream aliases don’t support this parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Routing? SearchRouting { get; set; }
}

/// <summary>
/// <para>
/// Create or update an alias.
/// Adds a data stream or index to an alias.
/// </para>
/// </summary>
public readonly partial struct PutAliasRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutAliasRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest instance)
	{
		Instance = instance;
	}

	public PutAliasRequestDescriptor(Elastic.Clients.Elasticsearch.Indices indices, Elastic.Clients.Elasticsearch.Name name)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest(indices, name);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutAliasRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest(Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Comma-separated list of data streams or indices to add.
	/// Supports wildcards (<c>*</c>).
	/// Wildcard patterns that match both data streams and indices return an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor Indices(Elastic.Clients.Elasticsearch.Indices value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Alias to update.
	/// If the alias doesn’t exist, the request creates it.
	/// Index alias names support date math.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query used to limit documents the alias can access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor Filter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query used to limit documents the alias can access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor Filter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Query used to limit documents the alias can access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor Filter<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Value used to route indexing operations to a specific shard.
	/// If specified, this overwrites the <c>routing</c> value for indexing operations.
	/// Data stream aliases don’t support this parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor IndexRouting(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.IndexRouting = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, sets the write index or data stream for the alias.
	/// If an alias points to multiple indices or data streams and <c>is_write_index</c> isn’t set, the alias rejects write requests.
	/// If an index alias points to one index and <c>is_write_index</c> isn’t set, the index automatically acts as the write index.
	/// Data stream aliases don’t automatically set a write data stream, even if the alias points to one data stream.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor IsWriteIndex(bool? value = true)
	{
		Instance.IsWriteIndex = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Value used to route indexing and search operations to a specific shard.
	/// Data stream aliases don’t support this parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor Routing(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.Routing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Value used to route search operations to a specific shard.
	/// If specified, this overwrites the <c>routing</c> value for search operations.
	/// Data stream aliases don’t support this parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor SearchRouting(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.SearchRouting = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Create or update an alias.
/// Adds a data stream or index to an alias.
/// </para>
/// </summary>
public readonly partial struct PutAliasRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutAliasRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest instance)
	{
		Instance = instance;
	}

	public PutAliasRequestDescriptor(Elastic.Clients.Elasticsearch.Indices indices, Elastic.Clients.Elasticsearch.Name name)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest(indices, name);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutAliasRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest(Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Comma-separated list of data streams or indices to add.
	/// Supports wildcards (<c>*</c>).
	/// Wildcard patterns that match both data streams and indices return an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument> Indices(Elastic.Clients.Elasticsearch.Indices value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Alias to update.
	/// If the alias doesn’t exist, the request creates it.
	/// Index alias names support date math.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument> Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument> MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument> Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query used to limit documents the alias can access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument> Filter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query used to limit documents the alias can access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument> Filter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Value used to route indexing operations to a specific shard.
	/// If specified, this overwrites the <c>routing</c> value for indexing operations.
	/// Data stream aliases don’t support this parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument> IndexRouting(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.IndexRouting = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, sets the write index or data stream for the alias.
	/// If an alias points to multiple indices or data streams and <c>is_write_index</c> isn’t set, the alias rejects write requests.
	/// If an index alias points to one index and <c>is_write_index</c> isn’t set, the index automatically acts as the write index.
	/// Data stream aliases don’t automatically set a write data stream, even if the alias points to one data stream.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument> IsWriteIndex(bool? value = true)
	{
		Instance.IsWriteIndex = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Value used to route indexing and search operations to a specific shard.
	/// Data stream aliases don’t support this parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument> Routing(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.Routing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Value used to route search operations to a specific shard.
	/// If specified, this overwrites the <c>routing</c> value for search operations.
	/// Data stream aliases don’t support this parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument> SearchRouting(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.SearchRouting = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.PutAliasRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}