// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

public sealed partial class MigrateReindexRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Reindex legacy backing indices.
/// </para>
/// <para>
/// Reindex all legacy backing indices for a data stream.
/// This operation occurs in a persistent task.
/// The persistent task ID is returned immediately and the reindexing work is completed in that task.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.MigrateReindexRequestConverter))]
public sealed partial class MigrateReindexRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MigrateReindexRequest(Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindex reindex)
	{
		Reindex = reindex;
	}
#if NET7_0_OR_GREATER
	public MigrateReindexRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public MigrateReindexRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MigrateReindexRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.IndexManagementMigrateReindex;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "indices.migrate_reindex";

	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindex Reindex { get; set; }
}

/// <summary>
/// <para>
/// Reindex legacy backing indices.
/// </para>
/// <para>
/// Reindex all legacy backing indices for a data stream.
/// This operation occurs in a persistent task.
/// The persistent task ID is returned immediately and the reindexing work is completed in that task.
/// </para>
/// </summary>
public readonly partial struct MigrateReindexRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MigrateReindexRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequest instance)
	{
		Instance = instance;
	}

	public MigrateReindexRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequest(Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestDescriptor Reindex(Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindex value)
	{
		Instance.Reindex = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestDescriptor Reindex(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexDescriptor> action)
	{
		Instance.Reindex = Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}