// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

public sealed partial class IndicesStatsRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in fielddata and suggest statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? CompletionFields { get => Q<Elastic.Clients.Elasticsearch.Fields?>("completion_fields"); set => Q("completion_fields", value); }

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match. If the request can target data streams, this argument
	/// determines whether wildcard expressions match hidden data streams. Supports comma-separated values,
	/// such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? ExpandWildcards { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>?>("expand_wildcards"); set => Q("expand_wildcards", value); }

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in fielddata statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? FielddataFields { get => Q<Elastic.Clients.Elasticsearch.Fields?>("fielddata_fields"); set => Q("fielddata_fields", value); }

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in the statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? Fields { get => Q<Elastic.Clients.Elasticsearch.Fields?>("fields"); set => Q("fields", value); }

	/// <summary>
	/// <para>
	/// If true, statistics are not collected from closed indices.
	/// </para>
	/// </summary>
	public bool? ForbidClosedIndices { get => Q<bool?>("forbid_closed_indices"); set => Q("forbid_closed_indices", value); }

	/// <summary>
	/// <para>
	/// Comma-separated list of search groups to include in the search statistics.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Groups { get => Q<System.Collections.Generic.ICollection<string>?>("groups"); set => Q("groups", value); }

	/// <summary>
	/// <para>
	/// If true, the call reports the aggregated disk usage of each one of the Lucene index files (only applies if segment stats are requested).
	/// </para>
	/// </summary>
	public bool? IncludeSegmentFileSizes { get => Q<bool?>("include_segment_file_sizes"); set => Q("include_segment_file_sizes", value); }

	/// <summary>
	/// <para>
	/// If true, the response includes information from segments that are not loaded into memory.
	/// </para>
	/// </summary>
	public bool? IncludeUnloadedSegments { get => Q<bool?>("include_unloaded_segments"); set => Q("include_unloaded_segments", value); }

	/// <summary>
	/// <para>
	/// Indicates whether statistics are aggregated at the cluster, indices, or shards level.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Level? Level { get => Q<Elastic.Clients.Elasticsearch.Level?>("level"); set => Q("level", value); }
}

/// <summary>
/// <para>
/// Get index statistics.
/// For data streams, the API retrieves statistics for the stream's backing indices.
/// </para>
/// <para>
/// By default, the returned statistics are index-level with <c>primaries</c> and <c>total</c> aggregations.
/// <c>primaries</c> are the values for only the primary shards.
/// <c>total</c> are the accumulated values for both primary and replica shards.
/// </para>
/// <para>
/// To get shard-level statistics, set the <c>level</c> parameter to <c>shards</c>.
/// </para>
/// <para>
/// NOTE: When moving to another node, the shard-level statistics for a shard are cleared.
/// Although the shard is no longer part of the node, that node retains any node-level statistics to which the shard contributed.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.IndicesStatsRequestConverter))]
public sealed partial class IndicesStatsRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestParameters>
{
	public IndicesStatsRequest(Elastic.Clients.Elasticsearch.Metrics? metric) : base(r => r.Optional("metric", metric))
	{
	}

	public IndicesStatsRequest(Elastic.Clients.Elasticsearch.Indices? indices) : base(r => r.Optional("index", indices))
	{
	}

	public IndicesStatsRequest(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Metrics? metric) : base(r => r.Optional("index", indices).Optional("metric", metric))
	{
	}
#if NET7_0_OR_GREATER
	public IndicesStatsRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public IndicesStatsRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IndicesStatsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.IndexManagementStats;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "indices.stats";

	/// <summary>
	/// <para>
	/// A comma-separated list of index names; use <c>_all</c> or empty string to perform the operation on all indices
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Indices? Indices { get => P<Elastic.Clients.Elasticsearch.Indices?>("index"); set => PO("index", value); }

	/// <summary>
	/// <para>
	/// Limit the information returned the specific metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Metrics? Metric { get => P<Elastic.Clients.Elasticsearch.Metrics?>("metric"); set => PO("metric", value); }

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in fielddata and suggest statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? CompletionFields { get => Q<Elastic.Clients.Elasticsearch.Fields?>("completion_fields"); set => Q("completion_fields", value); }

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match. If the request can target data streams, this argument
	/// determines whether wildcard expressions match hidden data streams. Supports comma-separated values,
	/// such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? ExpandWildcards { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>?>("expand_wildcards"); set => Q("expand_wildcards", value); }

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in fielddata statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? FielddataFields { get => Q<Elastic.Clients.Elasticsearch.Fields?>("fielddata_fields"); set => Q("fielddata_fields", value); }

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in the statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? Fields { get => Q<Elastic.Clients.Elasticsearch.Fields?>("fields"); set => Q("fields", value); }

	/// <summary>
	/// <para>
	/// If true, statistics are not collected from closed indices.
	/// </para>
	/// </summary>
	public bool? ForbidClosedIndices { get => Q<bool?>("forbid_closed_indices"); set => Q("forbid_closed_indices", value); }

	/// <summary>
	/// <para>
	/// Comma-separated list of search groups to include in the search statistics.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Groups { get => Q<System.Collections.Generic.ICollection<string>?>("groups"); set => Q("groups", value); }

	/// <summary>
	/// <para>
	/// If true, the call reports the aggregated disk usage of each one of the Lucene index files (only applies if segment stats are requested).
	/// </para>
	/// </summary>
	public bool? IncludeSegmentFileSizes { get => Q<bool?>("include_segment_file_sizes"); set => Q("include_segment_file_sizes", value); }

	/// <summary>
	/// <para>
	/// If true, the response includes information from segments that are not loaded into memory.
	/// </para>
	/// </summary>
	public bool? IncludeUnloadedSegments { get => Q<bool?>("include_unloaded_segments"); set => Q("include_unloaded_segments", value); }

	/// <summary>
	/// <para>
	/// Indicates whether statistics are aggregated at the cluster, indices, or shards level.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Level? Level { get => Q<Elastic.Clients.Elasticsearch.Level?>("level"); set => Q("level", value); }
}

/// <summary>
/// <para>
/// Get index statistics.
/// For data streams, the API retrieves statistics for the stream's backing indices.
/// </para>
/// <para>
/// By default, the returned statistics are index-level with <c>primaries</c> and <c>total</c> aggregations.
/// <c>primaries</c> are the values for only the primary shards.
/// <c>total</c> are the accumulated values for both primary and replica shards.
/// </para>
/// <para>
/// To get shard-level statistics, set the <c>level</c> parameter to <c>shards</c>.
/// </para>
/// <para>
/// NOTE: When moving to another node, the shard-level statistics for a shard are cleared.
/// Although the shard is no longer part of the node, that node retains any node-level statistics to which the shard contributed.
/// </para>
/// </summary>
public readonly partial struct IndicesStatsRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndicesStatsRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest instance)
	{
		Instance = instance;
	}

	public IndicesStatsRequestDescriptor(Elastic.Clients.Elasticsearch.Metrics? metric)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest(metric);
	}

	public IndicesStatsRequestDescriptor(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest(indices);
	}

	public IndicesStatsRequestDescriptor(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Metrics? metric)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest(indices, metric);
	}

	public IndicesStatsRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest(Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A comma-separated list of index names; use <c>_all</c> or empty string to perform the operation on all indices
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor Indices(Elastic.Clients.Elasticsearch.Indices? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limit the information returned the specific metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor Metric(Elastic.Clients.Elasticsearch.Metrics? value)
	{
		Instance.Metric = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in fielddata and suggest statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor CompletionFields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.CompletionFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in fielddata and suggest statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor CompletionFields<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.CompletionFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match. If the request can target data streams, this argument
	/// determines whether wildcard expressions match hidden data streams. Supports comma-separated values,
	/// such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor ExpandWildcards(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? value)
	{
		Instance.ExpandWildcards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match. If the request can target data streams, this argument
	/// determines whether wildcard expressions match hidden data streams. Supports comma-separated values,
	/// such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor ExpandWildcards(params Elastic.Clients.Elasticsearch.ExpandWildcard[] values)
	{
		Instance.ExpandWildcards = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in fielddata statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor FielddataFields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.FielddataFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in fielddata statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor FielddataFields<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.FielddataFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in the statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor Fields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in the statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor Fields<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, statistics are not collected from closed indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor ForbidClosedIndices(bool? value = true)
	{
		Instance.ForbidClosedIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list of search groups to include in the search statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor Groups(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Groups = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list of search groups to include in the search statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor Groups(params string[] values)
	{
		Instance.Groups = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, the call reports the aggregated disk usage of each one of the Lucene index files (only applies if segment stats are requested).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor IncludeSegmentFileSizes(bool? value = true)
	{
		Instance.IncludeSegmentFileSizes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, the response includes information from segments that are not loaded into memory.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor IncludeUnloadedSegments(bool? value = true)
	{
		Instance.IncludeUnloadedSegments = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether statistics are aggregated at the cluster, indices, or shards level.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor Level(Elastic.Clients.Elasticsearch.Level? value)
	{
		Instance.Level = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Get index statistics.
/// For data streams, the API retrieves statistics for the stream's backing indices.
/// </para>
/// <para>
/// By default, the returned statistics are index-level with <c>primaries</c> and <c>total</c> aggregations.
/// <c>primaries</c> are the values for only the primary shards.
/// <c>total</c> are the accumulated values for both primary and replica shards.
/// </para>
/// <para>
/// To get shard-level statistics, set the <c>level</c> parameter to <c>shards</c>.
/// </para>
/// <para>
/// NOTE: When moving to another node, the shard-level statistics for a shard are cleared.
/// Although the shard is no longer part of the node, that node retains any node-level statistics to which the shard contributed.
/// </para>
/// </summary>
public readonly partial struct IndicesStatsRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndicesStatsRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest instance)
	{
		Instance = instance;
	}

	public IndicesStatsRequestDescriptor(Elastic.Clients.Elasticsearch.Metrics? metric)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest(metric);
	}

	public IndicesStatsRequestDescriptor(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest(indices);
	}

	public IndicesStatsRequestDescriptor(Elastic.Clients.Elasticsearch.Indices? indices, Elastic.Clients.Elasticsearch.Metrics? metric)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest(indices, metric);
	}

	public IndicesStatsRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest(Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A comma-separated list of index names; use <c>_all</c> or empty string to perform the operation on all indices
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> Indices(Elastic.Clients.Elasticsearch.Indices? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limit the information returned the specific metrics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> Metric(Elastic.Clients.Elasticsearch.Metrics? value)
	{
		Instance.Metric = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in fielddata and suggest statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> CompletionFields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.CompletionFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in fielddata and suggest statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> CompletionFields(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.CompletionFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match. If the request can target data streams, this argument
	/// determines whether wildcard expressions match hidden data streams. Supports comma-separated values,
	/// such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> ExpandWildcards(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? value)
	{
		Instance.ExpandWildcards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match. If the request can target data streams, this argument
	/// determines whether wildcard expressions match hidden data streams. Supports comma-separated values,
	/// such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> ExpandWildcards(params Elastic.Clients.Elasticsearch.ExpandWildcard[] values)
	{
		Instance.ExpandWildcards = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in fielddata statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> FielddataFields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.FielddataFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in fielddata statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> FielddataFields(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.FielddataFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in the statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> Fields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list or wildcard expressions of fields to include in the statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> Fields(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, statistics are not collected from closed indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> ForbidClosedIndices(bool? value = true)
	{
		Instance.ForbidClosedIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list of search groups to include in the search statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> Groups(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Groups = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Comma-separated list of search groups to include in the search statistics.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> Groups(params string[] values)
	{
		Instance.Groups = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, the call reports the aggregated disk usage of each one of the Lucene index files (only applies if segment stats are requested).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> IncludeSegmentFileSizes(bool? value = true)
	{
		Instance.IncludeSegmentFileSizes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, the response includes information from segments that are not loaded into memory.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> IncludeUnloadedSegments(bool? value = true)
	{
		Instance.IncludeUnloadedSegments = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether statistics are aggregated at the cluster, indices, or shards level.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> Level(Elastic.Clients.Elasticsearch.Level? value)
	{
		Instance.Level = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndicesStatsRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}