// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

public sealed partial class DownsampleRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Downsample an index.
/// Aggregate a time series (TSDS) index and store pre-computed statistical summaries (<c>min</c>, <c>max</c>, <c>sum</c>, <c>value_count</c> and <c>avg</c>) for each metric field grouped by a configured time interval.
/// For example, a TSDS index that contains metrics sampled every 10 seconds can be downsampled to an hourly index.
/// All documents within an hour interval are summarized and stored as a single document in the downsample index.
/// </para>
/// <para>
/// NOTE: Only indices in a time series data stream are supported.
/// Neither field nor document level security can be defined on the source index.
/// The source index must be read only (<c>index.blocks.write: true</c>).
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.DownsampleRequestConverter))]
public sealed partial class DownsampleRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DownsampleRequest(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName targetIndex) : base(r => r.Required("index", index).Required("target_index", targetIndex))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DownsampleRequest(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName targetIndex, Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfig config) : base(r => r.Required("index", index).Required("target_index", targetIndex))
	{
		Config = config;
	}
#if NET7_0_OR_GREATER
	public DownsampleRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DownsampleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.IndexManagementDownsample;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "indices.downsample";

	/// <summary>
	/// <para>
	/// Name of the time series index to downsample.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexName Index { get => P<Elastic.Clients.Elasticsearch.IndexName>("index"); set => PR("index", value); }

	/// <summary>
	/// <para>
	/// Name of the index to create.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexName TargetIndex { get => P<Elastic.Clients.Elasticsearch.IndexName>("target_index"); set => PR("target_index", value); }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfig Config { get; set; }
}

/// <summary>
/// <para>
/// Downsample an index.
/// Aggregate a time series (TSDS) index and store pre-computed statistical summaries (<c>min</c>, <c>max</c>, <c>sum</c>, <c>value_count</c> and <c>avg</c>) for each metric field grouped by a configured time interval.
/// For example, a TSDS index that contains metrics sampled every 10 seconds can be downsampled to an hourly index.
/// All documents within an hour interval are summarized and stored as a single document in the downsample index.
/// </para>
/// <para>
/// NOTE: Only indices in a time series data stream are supported.
/// Neither field nor document level security can be defined on the source index.
/// The source index must be read only (<c>index.blocks.write: true</c>).
/// </para>
/// </summary>
public readonly partial struct DownsampleRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DownsampleRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest instance)
	{
		Instance = instance;
	}

	public DownsampleRequestDescriptor(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName targetIndex)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest(index, targetIndex);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public DownsampleRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest(Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Name of the time series index to downsample.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor Index(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the index to create.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor TargetIndex(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.TargetIndex = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor Config(Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfig value)
	{
		Instance.Config = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor Config(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfigDescriptor> action)
	{
		Instance.Config = Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfigDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Downsample an index.
/// Aggregate a time series (TSDS) index and store pre-computed statistical summaries (<c>min</c>, <c>max</c>, <c>sum</c>, <c>value_count</c> and <c>avg</c>) for each metric field grouped by a configured time interval.
/// For example, a TSDS index that contains metrics sampled every 10 seconds can be downsampled to an hourly index.
/// All documents within an hour interval are summarized and stored as a single document in the downsample index.
/// </para>
/// <para>
/// NOTE: Only indices in a time series data stream are supported.
/// Neither field nor document level security can be defined on the source index.
/// The source index must be read only (<c>index.blocks.write: true</c>).
/// </para>
/// </summary>
public readonly partial struct DownsampleRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DownsampleRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest instance)
	{
		Instance = instance;
	}

	public DownsampleRequestDescriptor(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.IndexName targetIndex)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest(index, targetIndex);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public DownsampleRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest(Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Name of the time series index to downsample.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument> Index(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the index to create.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument> TargetIndex(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.TargetIndex = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument> Config(Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfig value)
	{
		Instance.Config = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument> Config(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfigDescriptor> action)
	{
		Instance.Config = Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfigDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}