// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

public sealed partial class DiskUsageRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If false, the request returns an error if any wildcard expression, index alias, or <c>_all</c> value targets only missing or closed indices.
	/// This behavior applies even if the request targets other open indices.
	/// For example, a request targeting <c>foo*,bar*</c> returns an error if an index starts with <c>foo</c> but no index starts with <c>bar</c>.
	/// </para>
	/// </summary>
	public bool? AllowNoIndices { get => Q<bool?>("allow_no_indices"); set => Q("allow_no_indices", value); }

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match.
	/// If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
	/// Supports comma-separated values, such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? ExpandWildcards { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>?>("expand_wildcards"); set => Q("expand_wildcards", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the API performs a flush before analysis.
	/// If <c>false</c>, the response may not include uncommitted data.
	/// </para>
	/// </summary>
	public bool? Flush { get => Q<bool?>("flush"); set => Q("flush", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, missing or closed indices are not included in the response.
	/// </para>
	/// </summary>
	public bool? IgnoreUnavailable { get => Q<bool?>("ignore_unavailable"); set => Q("ignore_unavailable", value); }

	/// <summary>
	/// <para>
	/// Analyzing field disk usage is resource-intensive.
	/// To use the API, this parameter must be set to <c>true</c>.
	/// </para>
	/// </summary>
	public bool? RunExpensiveTasks { get => Q<bool?>("run_expensive_tasks"); set => Q("run_expensive_tasks", value); }
}

/// <summary>
/// <para>
/// Analyze the index disk usage.
/// Analyze the disk usage of each field of an index or data stream.
/// This API might not support indices created in previous Elasticsearch versions.
/// The result of a small index can be inaccurate as some parts of an index might not be analyzed by the API.
/// </para>
/// <para>
/// NOTE: The total size of fields of the analyzed shards of the index in the response is usually smaller than the index <c>store_size</c> value because some small metadata files are ignored and some parts of data files might not be scanned by the API.
/// Since stored fields are stored together in a compressed format, the sizes of stored fields are also estimates and can be inaccurate.
/// The stored size of the <c>_id</c> field is likely underestimated while the <c>_source</c> field is overestimated.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.DiskUsageRequestConverter))]
public sealed partial class DiskUsageRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DiskUsageRequest(Elastic.Clients.Elasticsearch.Indices indices) : base(r => r.Required("index", indices))
	{
	}
#if NET7_0_OR_GREATER
	public DiskUsageRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DiskUsageRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.IndexManagementDiskUsage;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => false;

	internal override string OperationName => "indices.disk_usage";

	/// <summary>
	/// <para>
	/// Comma-separated list of data streams, indices, and aliases used to limit the request.
	/// It’s recommended to execute this API with a single index (or the latest backing index of a data stream) as the API consumes resources significantly.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Indices Indices { get => P<Elastic.Clients.Elasticsearch.Indices>("index"); set => PR("index", value); }

	/// <summary>
	/// <para>
	/// If false, the request returns an error if any wildcard expression, index alias, or <c>_all</c> value targets only missing or closed indices.
	/// This behavior applies even if the request targets other open indices.
	/// For example, a request targeting <c>foo*,bar*</c> returns an error if an index starts with <c>foo</c> but no index starts with <c>bar</c>.
	/// </para>
	/// </summary>
	public bool? AllowNoIndices { get => Q<bool?>("allow_no_indices"); set => Q("allow_no_indices", value); }

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match.
	/// If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
	/// Supports comma-separated values, such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? ExpandWildcards { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>?>("expand_wildcards"); set => Q("expand_wildcards", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the API performs a flush before analysis.
	/// If <c>false</c>, the response may not include uncommitted data.
	/// </para>
	/// </summary>
	public bool? Flush { get => Q<bool?>("flush"); set => Q("flush", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, missing or closed indices are not included in the response.
	/// </para>
	/// </summary>
	public bool? IgnoreUnavailable { get => Q<bool?>("ignore_unavailable"); set => Q("ignore_unavailable", value); }

	/// <summary>
	/// <para>
	/// Analyzing field disk usage is resource-intensive.
	/// To use the API, this parameter must be set to <c>true</c>.
	/// </para>
	/// </summary>
	public bool? RunExpensiveTasks { get => Q<bool?>("run_expensive_tasks"); set => Q("run_expensive_tasks", value); }
}

/// <summary>
/// <para>
/// Analyze the index disk usage.
/// Analyze the disk usage of each field of an index or data stream.
/// This API might not support indices created in previous Elasticsearch versions.
/// The result of a small index can be inaccurate as some parts of an index might not be analyzed by the API.
/// </para>
/// <para>
/// NOTE: The total size of fields of the analyzed shards of the index in the response is usually smaller than the index <c>store_size</c> value because some small metadata files are ignored and some parts of data files might not be scanned by the API.
/// Since stored fields are stored together in a compressed format, the sizes of stored fields are also estimates and can be inaccurate.
/// The stored size of the <c>_id</c> field is likely underestimated while the <c>_source</c> field is overestimated.
/// </para>
/// </summary>
public readonly partial struct DiskUsageRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DiskUsageRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest instance)
	{
		Instance = instance;
	}

	public DiskUsageRequestDescriptor(Elastic.Clients.Elasticsearch.Indices indices)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest(indices);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public DiskUsageRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest(Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Comma-separated list of data streams, indices, and aliases used to limit the request.
	/// It’s recommended to execute this API with a single index (or the latest backing index of a data stream) as the API consumes resources significantly.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor Indices(Elastic.Clients.Elasticsearch.Indices value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If false, the request returns an error if any wildcard expression, index alias, or <c>_all</c> value targets only missing or closed indices.
	/// This behavior applies even if the request targets other open indices.
	/// For example, a request targeting <c>foo*,bar*</c> returns an error if an index starts with <c>foo</c> but no index starts with <c>bar</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor AllowNoIndices(bool? value = true)
	{
		Instance.AllowNoIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match.
	/// If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
	/// Supports comma-separated values, such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor ExpandWildcards(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? value)
	{
		Instance.ExpandWildcards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match.
	/// If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
	/// Supports comma-separated values, such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor ExpandWildcards(params Elastic.Clients.Elasticsearch.ExpandWildcard[] values)
	{
		Instance.ExpandWildcards = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the API performs a flush before analysis.
	/// If <c>false</c>, the response may not include uncommitted data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor Flush(bool? value = true)
	{
		Instance.Flush = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, missing or closed indices are not included in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor IgnoreUnavailable(bool? value = true)
	{
		Instance.IgnoreUnavailable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Analyzing field disk usage is resource-intensive.
	/// To use the API, this parameter must be set to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor RunExpensiveTasks(bool? value = true)
	{
		Instance.RunExpensiveTasks = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Analyze the index disk usage.
/// Analyze the disk usage of each field of an index or data stream.
/// This API might not support indices created in previous Elasticsearch versions.
/// The result of a small index can be inaccurate as some parts of an index might not be analyzed by the API.
/// </para>
/// <para>
/// NOTE: The total size of fields of the analyzed shards of the index in the response is usually smaller than the index <c>store_size</c> value because some small metadata files are ignored and some parts of data files might not be scanned by the API.
/// Since stored fields are stored together in a compressed format, the sizes of stored fields are also estimates and can be inaccurate.
/// The stored size of the <c>_id</c> field is likely underestimated while the <c>_source</c> field is overestimated.
/// </para>
/// </summary>
public readonly partial struct DiskUsageRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DiskUsageRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest instance)
	{
		Instance = instance;
	}

	public DiskUsageRequestDescriptor(Elastic.Clients.Elasticsearch.Indices indices)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest(indices);
	}

	public DiskUsageRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest(typeof(TDocument));
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest(Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Comma-separated list of data streams, indices, and aliases used to limit the request.
	/// It’s recommended to execute this API with a single index (or the latest backing index of a data stream) as the API consumes resources significantly.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument> Indices(Elastic.Clients.Elasticsearch.Indices value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If false, the request returns an error if any wildcard expression, index alias, or <c>_all</c> value targets only missing or closed indices.
	/// This behavior applies even if the request targets other open indices.
	/// For example, a request targeting <c>foo*,bar*</c> returns an error if an index starts with <c>foo</c> but no index starts with <c>bar</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument> AllowNoIndices(bool? value = true)
	{
		Instance.AllowNoIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match.
	/// If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
	/// Supports comma-separated values, such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument> ExpandWildcards(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? value)
	{
		Instance.ExpandWildcards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Type of index that wildcard patterns can match.
	/// If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams.
	/// Supports comma-separated values, such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument> ExpandWildcards(params Elastic.Clients.Elasticsearch.ExpandWildcard[] values)
	{
		Instance.ExpandWildcards = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the API performs a flush before analysis.
	/// If <c>false</c>, the response may not include uncommitted data.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument> Flush(bool? value = true)
	{
		Instance.Flush = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, missing or closed indices are not included in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument> IgnoreUnavailable(bool? value = true)
	{
		Instance.IgnoreUnavailable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Analyzing field disk usage is resource-intensive.
	/// To use the API, this parameter must be set to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument> RunExpensiveTasks(bool? value = true)
	{
		Instance.RunExpensiveTasks = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DiskUsageRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}