// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

public sealed partial class CreateIndexRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// The number of shard copies that must be active before proceeding with the operation.
	/// Set to <c>all</c> or any positive integer up to the total number of shards in the index (<c>number_of_replicas+1</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.WaitForActiveShards? WaitForActiveShards { get => Q<Elastic.Clients.Elasticsearch.WaitForActiveShards?>("wait_for_active_shards"); set => Q("wait_for_active_shards", value); }
}

/// <summary>
/// <para>
/// Create an index.
/// You can use the create index API to add a new index to an Elasticsearch cluster.
/// When creating an index, you can specify the following:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// Settings for the index.
/// </para>
/// </item>
/// <item>
/// <para>
/// Mappings for fields in the index.
/// </para>
/// </item>
/// <item>
/// <para>
/// Index aliases
/// </para>
/// </item>
/// </list>
/// <para>
/// <strong>Wait for active shards</strong>
/// </para>
/// <para>
/// By default, index creation will only return a response to the client when the primary copies of each shard have been started, or the request times out.
/// The index creation response will indicate what happened.
/// For example, <c>acknowledged</c> indicates whether the index was successfully created in the cluster, <c>while shards_acknowledged</c> indicates whether the requisite number of shard copies were started for each shard in the index before timing out.
/// Note that it is still possible for either <c>acknowledged</c> or <c>shards_acknowledged</c> to be <c>false</c>, but for the index creation to be successful.
/// These values simply indicate whether the operation completed before the timeout.
/// If <c>acknowledged</c> is false, the request timed out before the cluster state was updated with the newly created index, but it probably will be created sometime soon.
/// If <c>shards_acknowledged</c> is false, then the request timed out before the requisite number of shards were started (by default just the primaries), even if the cluster state was successfully updated to reflect the newly created index (that is to say, <c>acknowledged</c> is <c>true</c>).
/// </para>
/// <para>
/// You can change the default of only waiting for the primary shards to start through the index setting <c>index.write.wait_for_active_shards</c>.
/// Note that changing this setting will also affect the <c>wait_for_active_shards</c> value on all subsequent write operations.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.CreateIndexRequestConverter))]
public sealed partial class CreateIndexRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CreateIndexRequest(Elastic.Clients.Elasticsearch.IndexName index) : base(r => r.Required("index", index))
	{
	}
#if NET7_0_OR_GREATER
	public CreateIndexRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CreateIndexRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.IndexManagementCreate;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "indices.create";

	/// <summary>
	/// <para>
	/// Name of the index you wish to create.
	/// Index names must meet the following criteria:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Lowercase only
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Cannot include <c>\</c>, <c>/</c>, <c>*</c>, <c>?</c>, <c>"</c>, <c>&lt;</c>, <c>></c>, <c>|</c>, <c> </c> (space character), <c>,</c>, or <c>#</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Indices prior to 7.0 could contain a colon (<c>:</c>), but that has been deprecated and will not be supported in later versions
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Cannot start with <c>-</c>, <c>_</c>, or <c>+</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Cannot be <c>.</c> or <c>..</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Cannot be longer than 255 bytes (note thtat it is bytes, so multi-byte characters will reach the limit faster)
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Names starting with <c>.</c> are deprecated, except for hidden indices and internal indices managed by plugins
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexName Index { get => P<Elastic.Clients.Elasticsearch.IndexName>("index"); set => PR("index", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// The number of shard copies that must be active before proceeding with the operation.
	/// Set to <c>all</c> or any positive integer up to the total number of shards in the index (<c>number_of_replicas+1</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.WaitForActiveShards? WaitForActiveShards { get => Q<Elastic.Clients.Elasticsearch.WaitForActiveShards?>("wait_for_active_shards"); set => Q("wait_for_active_shards", value); }

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Name, Elastic.Clients.Elasticsearch.IndexManagement.Alias>? Aliases { get; set; }

	/// <summary>
	/// <para>
	/// Mapping for fields in the index. If specified, this mapping can include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Field names
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Field data types
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Mapping parameters
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Mapping.TypeMapping? Mappings { get; set; }

	/// <summary>
	/// <para>
	/// Configuration options for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings? Settings { get; set; }
}

/// <summary>
/// <para>
/// Create an index.
/// You can use the create index API to add a new index to an Elasticsearch cluster.
/// When creating an index, you can specify the following:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// Settings for the index.
/// </para>
/// </item>
/// <item>
/// <para>
/// Mappings for fields in the index.
/// </para>
/// </item>
/// <item>
/// <para>
/// Index aliases
/// </para>
/// </item>
/// </list>
/// <para>
/// <strong>Wait for active shards</strong>
/// </para>
/// <para>
/// By default, index creation will only return a response to the client when the primary copies of each shard have been started, or the request times out.
/// The index creation response will indicate what happened.
/// For example, <c>acknowledged</c> indicates whether the index was successfully created in the cluster, <c>while shards_acknowledged</c> indicates whether the requisite number of shard copies were started for each shard in the index before timing out.
/// Note that it is still possible for either <c>acknowledged</c> or <c>shards_acknowledged</c> to be <c>false</c>, but for the index creation to be successful.
/// These values simply indicate whether the operation completed before the timeout.
/// If <c>acknowledged</c> is false, the request timed out before the cluster state was updated with the newly created index, but it probably will be created sometime soon.
/// If <c>shards_acknowledged</c> is false, then the request timed out before the requisite number of shards were started (by default just the primaries), even if the cluster state was successfully updated to reflect the newly created index (that is to say, <c>acknowledged</c> is <c>true</c>).
/// </para>
/// <para>
/// You can change the default of only waiting for the primary shards to start through the index setting <c>index.write.wait_for_active_shards</c>.
/// Note that changing this setting will also affect the <c>wait_for_active_shards</c> value on all subsequent write operations.
/// </para>
/// </summary>
public readonly partial struct CreateIndexRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CreateIndexRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest instance)
	{
		Instance = instance;
	}

	public CreateIndexRequestDescriptor(Elastic.Clients.Elasticsearch.IndexName index)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest(index);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public CreateIndexRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest(Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Name of the index you wish to create.
	/// Index names must meet the following criteria:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Lowercase only
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Cannot include <c>\</c>, <c>/</c>, <c>*</c>, <c>?</c>, <c>"</c>, <c>&lt;</c>, <c>></c>, <c>|</c>, <c> </c> (space character), <c>,</c>, or <c>#</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Indices prior to 7.0 could contain a colon (<c>:</c>), but that has been deprecated and will not be supported in later versions
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Cannot start with <c>-</c>, <c>_</c>, or <c>+</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Cannot be <c>.</c> or <c>..</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Cannot be longer than 255 bytes (note thtat it is bytes, so multi-byte characters will reach the limit faster)
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Names starting with <c>.</c> are deprecated, except for hidden indices and internal indices managed by plugins
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor Index(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of shard copies that must be active before proceeding with the operation.
	/// Set to <c>all</c> or any positive integer up to the total number of shards in the index (<c>number_of_replicas+1</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor WaitForActiveShards(Elastic.Clients.Elasticsearch.WaitForActiveShards? value)
	{
		Instance.WaitForActiveShards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor Aliases(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Name, Elastic.Clients.Elasticsearch.IndexManagement.Alias>? value)
	{
		Instance.Aliases = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor Aliases()
	{
		Instance.Aliases = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfNameAlias.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor Aliases(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfNameAlias>? action)
	{
		Instance.Aliases = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfNameAlias.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor Aliases<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfNameAlias<T>>? action)
	{
		Instance.Aliases = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfNameAlias<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor AddAlias(Elastic.Clients.Elasticsearch.Name key, Elastic.Clients.Elasticsearch.IndexManagement.Alias value)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Name, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor Aliases(Elastic.Clients.Elasticsearch.Name key)
	{
		Instance.Aliases = new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Name, Elastic.Clients.Elasticsearch.IndexManagement.Alias> { { key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor.Build(null) } };
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor Aliases(params Elastic.Clients.Elasticsearch.Name[] keys)
	{
		var items = new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Name, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		foreach (var key in keys)
		{
			items.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor.Build(null));
		}

		Instance.Aliases = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor AddAlias(Elastic.Clients.Elasticsearch.Name key)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Name, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor AddAlias(Elastic.Clients.Elasticsearch.Name key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor>? action)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Name, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor AddAlias<T>(Elastic.Clients.Elasticsearch.Name key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<T>>? action)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Name, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<T>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping for fields in the index. If specified, this mapping can include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Field names
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Field data types
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Mapping parameters
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor Mappings(Elastic.Clients.Elasticsearch.Mapping.TypeMapping? value)
	{
		Instance.Mappings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping for fields in the index. If specified, this mapping can include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Field names
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Field data types
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Mapping parameters
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor Mappings()
	{
		Instance.Mappings = Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping for fields in the index. If specified, this mapping can include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Field names
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Field data types
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Mapping parameters
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor Mappings(System.Action<Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor>? action)
	{
		Instance.Mappings = Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping for fields in the index. If specified, this mapping can include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Field names
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Field data types
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Mapping parameters
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor Mappings<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<T>>? action)
	{
		Instance.Mappings = Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor Settings(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings? value)
	{
		Instance.Settings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor Settings()
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor Settings(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor>? action)
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor Settings<T>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<T>>? action)
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Create an index.
/// You can use the create index API to add a new index to an Elasticsearch cluster.
/// When creating an index, you can specify the following:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// Settings for the index.
/// </para>
/// </item>
/// <item>
/// <para>
/// Mappings for fields in the index.
/// </para>
/// </item>
/// <item>
/// <para>
/// Index aliases
/// </para>
/// </item>
/// </list>
/// <para>
/// <strong>Wait for active shards</strong>
/// </para>
/// <para>
/// By default, index creation will only return a response to the client when the primary copies of each shard have been started, or the request times out.
/// The index creation response will indicate what happened.
/// For example, <c>acknowledged</c> indicates whether the index was successfully created in the cluster, <c>while shards_acknowledged</c> indicates whether the requisite number of shard copies were started for each shard in the index before timing out.
/// Note that it is still possible for either <c>acknowledged</c> or <c>shards_acknowledged</c> to be <c>false</c>, but for the index creation to be successful.
/// These values simply indicate whether the operation completed before the timeout.
/// If <c>acknowledged</c> is false, the request timed out before the cluster state was updated with the newly created index, but it probably will be created sometime soon.
/// If <c>shards_acknowledged</c> is false, then the request timed out before the requisite number of shards were started (by default just the primaries), even if the cluster state was successfully updated to reflect the newly created index (that is to say, <c>acknowledged</c> is <c>true</c>).
/// </para>
/// <para>
/// You can change the default of only waiting for the primary shards to start through the index setting <c>index.write.wait_for_active_shards</c>.
/// Note that changing this setting will also affect the <c>wait_for_active_shards</c> value on all subsequent write operations.
/// </para>
/// </summary>
public readonly partial struct CreateIndexRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CreateIndexRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest instance)
	{
		Instance = instance;
	}

	public CreateIndexRequestDescriptor(Elastic.Clients.Elasticsearch.IndexName index)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest(index);
	}

	public CreateIndexRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest(typeof(TDocument));
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest(Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Name of the index you wish to create.
	/// Index names must meet the following criteria:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Lowercase only
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Cannot include <c>\</c>, <c>/</c>, <c>*</c>, <c>?</c>, <c>"</c>, <c>&lt;</c>, <c>></c>, <c>|</c>, <c> </c> (space character), <c>,</c>, or <c>#</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Indices prior to 7.0 could contain a colon (<c>:</c>), but that has been deprecated and will not be supported in later versions
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Cannot start with <c>-</c>, <c>_</c>, or <c>+</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Cannot be <c>.</c> or <c>..</c>
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Cannot be longer than 255 bytes (note thtat it is bytes, so multi-byte characters will reach the limit faster)
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Names starting with <c>.</c> are deprecated, except for hidden indices and internal indices managed by plugins
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> Index(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of shard copies that must be active before proceeding with the operation.
	/// Set to <c>all</c> or any positive integer up to the total number of shards in the index (<c>number_of_replicas+1</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> WaitForActiveShards(Elastic.Clients.Elasticsearch.WaitForActiveShards? value)
	{
		Instance.WaitForActiveShards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> Aliases(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Name, Elastic.Clients.Elasticsearch.IndexManagement.Alias>? value)
	{
		Instance.Aliases = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> Aliases()
	{
		Instance.Aliases = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfNameAlias<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> Aliases(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfNameAlias<TDocument>>? action)
	{
		Instance.Aliases = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfNameAlias<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> AddAlias(Elastic.Clients.Elasticsearch.Name key, Elastic.Clients.Elasticsearch.IndexManagement.Alias value)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Name, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> Aliases(Elastic.Clients.Elasticsearch.Name key)
	{
		Instance.Aliases = new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Name, Elastic.Clients.Elasticsearch.IndexManagement.Alias> { { key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument>.Build(null) } };
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> Aliases(params Elastic.Clients.Elasticsearch.Name[] keys)
	{
		var items = new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Name, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		foreach (var key in keys)
		{
			items.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument>.Build(null));
		}

		Instance.Aliases = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> AddAlias(Elastic.Clients.Elasticsearch.Name key)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Name, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> AddAlias(Elastic.Clients.Elasticsearch.Name key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument>>? action)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Name, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping for fields in the index. If specified, this mapping can include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Field names
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Field data types
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Mapping parameters
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> Mappings(Elastic.Clients.Elasticsearch.Mapping.TypeMapping? value)
	{
		Instance.Mappings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping for fields in the index. If specified, this mapping can include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Field names
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Field data types
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Mapping parameters
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> Mappings()
	{
		Instance.Mappings = Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Mapping for fields in the index. If specified, this mapping can include:
	/// </para>
	/// <list type="bullet">
	/// <item>
	/// <para>
	/// Field names
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Field data types
	/// </para>
	/// </item>
	/// <item>
	/// <para>
	/// Mapping parameters
	/// </para>
	/// </item>
	/// </list>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> Mappings(System.Action<Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument>>? action)
	{
		Instance.Mappings = Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> Settings(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings? value)
	{
		Instance.Settings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> Settings()
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> Settings(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument>>? action)
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateIndexRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}