// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

public sealed partial class CreateFromRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Create an index from a source index.
/// </para>
/// <para>
/// Copy the mappings and settings from the source index to a destination index while allowing request settings and mappings to override the source values.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.CreateFromRequestConverter))]
public sealed partial class CreateFromRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CreateFromRequest(Elastic.Clients.Elasticsearch.IndexName source, Elastic.Clients.Elasticsearch.IndexName dest) : base(r => r.Required("source", source).Required("dest", dest))
	{
	}
#if NET7_0_OR_GREATER
	public CreateFromRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CreateFromRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.IndexManagementCreateFrom;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "indices.create_from";

	/// <summary>
	/// <para>
	/// The destination index or data stream name
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexName Dest { get => P<Elastic.Clients.Elasticsearch.IndexName>("dest"); set => PR("dest", value); }

	/// <summary>
	/// <para>
	/// The source index or data stream name
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexName Source { get => P<Elastic.Clients.Elasticsearch.IndexName>("source"); set => PR("source", value); }
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFrom? CreateFrom { get; set; }
}

/// <summary>
/// <para>
/// Create an index from a source index.
/// </para>
/// <para>
/// Copy the mappings and settings from the source index to a destination index while allowing request settings and mappings to override the source values.
/// </para>
/// </summary>
public readonly partial struct CreateFromRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CreateFromRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest instance)
	{
		Instance = instance;
	}

	public CreateFromRequestDescriptor(Elastic.Clients.Elasticsearch.IndexName source, Elastic.Clients.Elasticsearch.IndexName dest)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest(source, dest);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public CreateFromRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest(Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The destination index or data stream name
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor Dest(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Dest = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The source index or data stream name
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor Source(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Source = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor CreateFrom(Elastic.Clients.Elasticsearch.IndexManagement.CreateFrom? value)
	{
		Instance.CreateFrom = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor CreateFrom()
	{
		Instance.CreateFrom = Elastic.Clients.Elasticsearch.IndexManagement.CreateFromDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor CreateFrom(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromDescriptor>? action)
	{
		Instance.CreateFrom = Elastic.Clients.Elasticsearch.IndexManagement.CreateFromDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor CreateFrom<T>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromDescriptor<T>>? action)
	{
		Instance.CreateFrom = Elastic.Clients.Elasticsearch.IndexManagement.CreateFromDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Create an index from a source index.
/// </para>
/// <para>
/// Copy the mappings and settings from the source index to a destination index while allowing request settings and mappings to override the source values.
/// </para>
/// </summary>
public readonly partial struct CreateFromRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CreateFromRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest instance)
	{
		Instance = instance;
	}

	public CreateFromRequestDescriptor(Elastic.Clients.Elasticsearch.IndexName source, Elastic.Clients.Elasticsearch.IndexName dest)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest(source, dest);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public CreateFromRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest(Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The destination index or data stream name
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument> Dest(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Dest = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The source index or data stream name
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument> Source(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Source = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument> CreateFrom(Elastic.Clients.Elasticsearch.IndexManagement.CreateFrom? value)
	{
		Instance.CreateFrom = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument> CreateFrom()
	{
		Instance.CreateFrom = Elastic.Clients.Elasticsearch.IndexManagement.CreateFromDescriptor<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument> CreateFrom(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromDescriptor<TDocument>>? action)
	{
		Instance.CreateFrom = Elastic.Clients.Elasticsearch.IndexManagement.CreateFromDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CreateFromRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}