// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

public sealed partial class CloneIndexRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// The number of shard copies that must be active before proceeding with the operation.
	/// Set to <c>all</c> or any positive integer up to the total number of shards in the index (<c>number_of_replicas+1</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.WaitForActiveShards? WaitForActiveShards { get => Q<Elastic.Clients.Elasticsearch.WaitForActiveShards?>("wait_for_active_shards"); set => Q("wait_for_active_shards", value); }
}

/// <summary>
/// <para>
/// Clone an index.
/// Clone an existing index into a new index.
/// Each original primary shard is cloned into a new primary shard in the new index.
/// </para>
/// <para>
/// IMPORTANT: Elasticsearch does not apply index templates to the resulting index.
/// The API also does not copy index metadata from the original index.
/// Index metadata includes aliases, index lifecycle management phase definitions, and cross-cluster replication (CCR) follower information.
/// For example, if you clone a CCR follower index, the resulting clone will not be a follower index.
/// </para>
/// <para>
/// The clone API copies most index settings from the source index to the resulting index, with the exception of <c>index.number_of_replicas</c> and <c>index.auto_expand_replicas</c>.
/// To set the number of replicas in the resulting index, configure these settings in the clone request.
/// </para>
/// <para>
/// Cloning works as follows:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// First, it creates a new target index with the same definition as the source index.
/// </para>
/// </item>
/// <item>
/// <para>
/// Then it hard-links segments from the source index into the target index. If the file system does not support hard-linking, all segments are copied into the new index, which is a much more time consuming process.
/// </para>
/// </item>
/// <item>
/// <para>
/// Finally, it recovers the target index as though it were a closed index which had just been re-opened.
/// </para>
/// </item>
/// </list>
/// <para>
/// IMPORTANT: Indices can only be cloned if they meet the following requirements:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// The index must be marked as read-only and have a cluster health status of green.
/// </para>
/// </item>
/// <item>
/// <para>
/// The target index must not exist.
/// </para>
/// </item>
/// <item>
/// <para>
/// The source index must have the same number of primary shards as the target index.
/// </para>
/// </item>
/// <item>
/// <para>
/// The node handling the clone process must have sufficient free disk space to accommodate a second copy of the existing index.
/// </para>
/// </item>
/// </list>
/// <para>
/// The current write index on a data stream cannot be cloned.
/// In order to clone the current write index, the data stream must first be rolled over so that a new write index is created and then the previous write index can be cloned.
/// </para>
/// <para>
/// NOTE: Mappings cannot be specified in the <c>_clone</c> request. The mappings of the source index will be used for the target index.
/// </para>
/// <para>
/// <strong>Monitor the cloning process</strong>
/// </para>
/// <para>
/// The cloning process can be monitored with the cat recovery API or the cluster health API can be used to wait until all primary shards have been allocated by setting the <c>wait_for_status</c> parameter to <c>yellow</c>.
/// </para>
/// <para>
/// The <c>_clone</c> API returns as soon as the target index has been added to the cluster state, before any shards have been allocated.
/// At this point, all shards are in the state unassigned.
/// If, for any reason, the target index can't be allocated, its primary shard will remain unassigned until it can be allocated on that node.
/// </para>
/// <para>
/// Once the primary shard is allocated, it moves to state initializing, and the clone process begins.
/// When the clone operation completes, the shard will become active.
/// At that point, Elasticsearch will try to allocate any replicas and may decide to relocate the primary shard to another node.
/// </para>
/// <para>
/// <strong>Wait for active shards</strong>
/// </para>
/// <para>
/// Because the clone operation creates a new index to clone the shards to, the wait for active shards setting on index creation applies to the clone index action as well.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.CloneIndexRequestConverter))]
public sealed partial class CloneIndexRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CloneIndexRequest(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.Name target) : base(r => r.Required("index", index).Required("target", target))
	{
	}
#if NET7_0_OR_GREATER
	public CloneIndexRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CloneIndexRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.IndexManagementClone;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "indices.clone";

	/// <summary>
	/// <para>
	/// Name of the source index to clone.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexName Index { get => P<Elastic.Clients.Elasticsearch.IndexName>("index"); set => PR("index", value); }

	/// <summary>
	/// <para>
	/// Name of the target index to create.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name Target { get => P<Elastic.Clients.Elasticsearch.Name>("target"); set => PR("target", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// The number of shard copies that must be active before proceeding with the operation.
	/// Set to <c>all</c> or any positive integer up to the total number of shards in the index (<c>number_of_replicas+1</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.WaitForActiveShards? WaitForActiveShards { get => Q<Elastic.Clients.Elasticsearch.WaitForActiveShards?>("wait_for_active_shards"); set => Q("wait_for_active_shards", value); }

	/// <summary>
	/// <para>
	/// Aliases for the resulting index.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>? Aliases { get; set; }

	/// <summary>
	/// <para>
	/// Configuration options for the target index.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Settings { get; set; }
}

/// <summary>
/// <para>
/// Clone an index.
/// Clone an existing index into a new index.
/// Each original primary shard is cloned into a new primary shard in the new index.
/// </para>
/// <para>
/// IMPORTANT: Elasticsearch does not apply index templates to the resulting index.
/// The API also does not copy index metadata from the original index.
/// Index metadata includes aliases, index lifecycle management phase definitions, and cross-cluster replication (CCR) follower information.
/// For example, if you clone a CCR follower index, the resulting clone will not be a follower index.
/// </para>
/// <para>
/// The clone API copies most index settings from the source index to the resulting index, with the exception of <c>index.number_of_replicas</c> and <c>index.auto_expand_replicas</c>.
/// To set the number of replicas in the resulting index, configure these settings in the clone request.
/// </para>
/// <para>
/// Cloning works as follows:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// First, it creates a new target index with the same definition as the source index.
/// </para>
/// </item>
/// <item>
/// <para>
/// Then it hard-links segments from the source index into the target index. If the file system does not support hard-linking, all segments are copied into the new index, which is a much more time consuming process.
/// </para>
/// </item>
/// <item>
/// <para>
/// Finally, it recovers the target index as though it were a closed index which had just been re-opened.
/// </para>
/// </item>
/// </list>
/// <para>
/// IMPORTANT: Indices can only be cloned if they meet the following requirements:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// The index must be marked as read-only and have a cluster health status of green.
/// </para>
/// </item>
/// <item>
/// <para>
/// The target index must not exist.
/// </para>
/// </item>
/// <item>
/// <para>
/// The source index must have the same number of primary shards as the target index.
/// </para>
/// </item>
/// <item>
/// <para>
/// The node handling the clone process must have sufficient free disk space to accommodate a second copy of the existing index.
/// </para>
/// </item>
/// </list>
/// <para>
/// The current write index on a data stream cannot be cloned.
/// In order to clone the current write index, the data stream must first be rolled over so that a new write index is created and then the previous write index can be cloned.
/// </para>
/// <para>
/// NOTE: Mappings cannot be specified in the <c>_clone</c> request. The mappings of the source index will be used for the target index.
/// </para>
/// <para>
/// <strong>Monitor the cloning process</strong>
/// </para>
/// <para>
/// The cloning process can be monitored with the cat recovery API or the cluster health API can be used to wait until all primary shards have been allocated by setting the <c>wait_for_status</c> parameter to <c>yellow</c>.
/// </para>
/// <para>
/// The <c>_clone</c> API returns as soon as the target index has been added to the cluster state, before any shards have been allocated.
/// At this point, all shards are in the state unassigned.
/// If, for any reason, the target index can't be allocated, its primary shard will remain unassigned until it can be allocated on that node.
/// </para>
/// <para>
/// Once the primary shard is allocated, it moves to state initializing, and the clone process begins.
/// When the clone operation completes, the shard will become active.
/// At that point, Elasticsearch will try to allocate any replicas and may decide to relocate the primary shard to another node.
/// </para>
/// <para>
/// <strong>Wait for active shards</strong>
/// </para>
/// <para>
/// Because the clone operation creates a new index to clone the shards to, the wait for active shards setting on index creation applies to the clone index action as well.
/// </para>
/// </summary>
public readonly partial struct CloneIndexRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CloneIndexRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest instance)
	{
		Instance = instance;
	}

	public CloneIndexRequestDescriptor(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.Name target)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest(index, target);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public CloneIndexRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest(Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Name of the source index to clone.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor Index(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the target index to create.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor Target(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Target = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of shard copies that must be active before proceeding with the operation.
	/// Set to <c>all</c> or any positive integer up to the total number of shards in the index (<c>number_of_replicas+1</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor WaitForActiveShards(Elastic.Clients.Elasticsearch.WaitForActiveShards? value)
	{
		Instance.WaitForActiveShards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the resulting index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor Aliases(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>? value)
	{
		Instance.Aliases = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the resulting index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor Aliases()
	{
		Instance.Aliases = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfIndexNameAlias.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the resulting index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor Aliases(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfIndexNameAlias>? action)
	{
		Instance.Aliases = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfIndexNameAlias.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the resulting index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor Aliases<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfIndexNameAlias<T>>? action)
	{
		Instance.Aliases = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfIndexNameAlias<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor AddAlias(Elastic.Clients.Elasticsearch.IndexName key, Elastic.Clients.Elasticsearch.IndexManagement.Alias value)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the resulting index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor Aliases(Elastic.Clients.Elasticsearch.IndexName key)
	{
		Instance.Aliases = new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias> { { key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor.Build(null) } };
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the resulting index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor Aliases(params Elastic.Clients.Elasticsearch.IndexName[] keys)
	{
		var items = new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		foreach (var key in keys)
		{
			items.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor.Build(null));
		}

		Instance.Aliases = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor AddAlias(Elastic.Clients.Elasticsearch.IndexName key)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor AddAlias(Elastic.Clients.Elasticsearch.IndexName key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor>? action)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor AddAlias<T>(Elastic.Clients.Elasticsearch.IndexName key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<T>>? action)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<T>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the target index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor Settings(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Settings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the target index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor Settings()
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the target index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor Settings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor AddSetting(string key, object value)
	{
		Instance.Settings ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Settings.Add(key, value);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Clone an index.
/// Clone an existing index into a new index.
/// Each original primary shard is cloned into a new primary shard in the new index.
/// </para>
/// <para>
/// IMPORTANT: Elasticsearch does not apply index templates to the resulting index.
/// The API also does not copy index metadata from the original index.
/// Index metadata includes aliases, index lifecycle management phase definitions, and cross-cluster replication (CCR) follower information.
/// For example, if you clone a CCR follower index, the resulting clone will not be a follower index.
/// </para>
/// <para>
/// The clone API copies most index settings from the source index to the resulting index, with the exception of <c>index.number_of_replicas</c> and <c>index.auto_expand_replicas</c>.
/// To set the number of replicas in the resulting index, configure these settings in the clone request.
/// </para>
/// <para>
/// Cloning works as follows:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// First, it creates a new target index with the same definition as the source index.
/// </para>
/// </item>
/// <item>
/// <para>
/// Then it hard-links segments from the source index into the target index. If the file system does not support hard-linking, all segments are copied into the new index, which is a much more time consuming process.
/// </para>
/// </item>
/// <item>
/// <para>
/// Finally, it recovers the target index as though it were a closed index which had just been re-opened.
/// </para>
/// </item>
/// </list>
/// <para>
/// IMPORTANT: Indices can only be cloned if they meet the following requirements:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// The index must be marked as read-only and have a cluster health status of green.
/// </para>
/// </item>
/// <item>
/// <para>
/// The target index must not exist.
/// </para>
/// </item>
/// <item>
/// <para>
/// The source index must have the same number of primary shards as the target index.
/// </para>
/// </item>
/// <item>
/// <para>
/// The node handling the clone process must have sufficient free disk space to accommodate a second copy of the existing index.
/// </para>
/// </item>
/// </list>
/// <para>
/// The current write index on a data stream cannot be cloned.
/// In order to clone the current write index, the data stream must first be rolled over so that a new write index is created and then the previous write index can be cloned.
/// </para>
/// <para>
/// NOTE: Mappings cannot be specified in the <c>_clone</c> request. The mappings of the source index will be used for the target index.
/// </para>
/// <para>
/// <strong>Monitor the cloning process</strong>
/// </para>
/// <para>
/// The cloning process can be monitored with the cat recovery API or the cluster health API can be used to wait until all primary shards have been allocated by setting the <c>wait_for_status</c> parameter to <c>yellow</c>.
/// </para>
/// <para>
/// The <c>_clone</c> API returns as soon as the target index has been added to the cluster state, before any shards have been allocated.
/// At this point, all shards are in the state unassigned.
/// If, for any reason, the target index can't be allocated, its primary shard will remain unassigned until it can be allocated on that node.
/// </para>
/// <para>
/// Once the primary shard is allocated, it moves to state initializing, and the clone process begins.
/// When the clone operation completes, the shard will become active.
/// At that point, Elasticsearch will try to allocate any replicas and may decide to relocate the primary shard to another node.
/// </para>
/// <para>
/// <strong>Wait for active shards</strong>
/// </para>
/// <para>
/// Because the clone operation creates a new index to clone the shards to, the wait for active shards setting on index creation applies to the clone index action as well.
/// </para>
/// </summary>
public readonly partial struct CloneIndexRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CloneIndexRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest instance)
	{
		Instance = instance;
	}

	public CloneIndexRequestDescriptor(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.Name target)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest(index, target);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public CloneIndexRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest(Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Name of the source index to clone.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> Index(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the target index to create.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> Target(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Target = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of shard copies that must be active before proceeding with the operation.
	/// Set to <c>all</c> or any positive integer up to the total number of shards in the index (<c>number_of_replicas+1</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> WaitForActiveShards(Elastic.Clients.Elasticsearch.WaitForActiveShards? value)
	{
		Instance.WaitForActiveShards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the resulting index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> Aliases(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>? value)
	{
		Instance.Aliases = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the resulting index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> Aliases()
	{
		Instance.Aliases = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfIndexNameAlias<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the resulting index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> Aliases(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfIndexNameAlias<TDocument>>? action)
	{
		Instance.Aliases = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfIndexNameAlias<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> AddAlias(Elastic.Clients.Elasticsearch.IndexName key, Elastic.Clients.Elasticsearch.IndexManagement.Alias value)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the resulting index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> Aliases(Elastic.Clients.Elasticsearch.IndexName key)
	{
		Instance.Aliases = new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias> { { key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument>.Build(null) } };
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the resulting index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> Aliases(params Elastic.Clients.Elasticsearch.IndexName[] keys)
	{
		var items = new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		foreach (var key in keys)
		{
			items.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument>.Build(null));
		}

		Instance.Aliases = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> AddAlias(Elastic.Clients.Elasticsearch.IndexName key)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> AddAlias(Elastic.Clients.Elasticsearch.IndexName key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument>>? action)
	{
		Instance.Aliases ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.IndexName, Elastic.Clients.Elasticsearch.IndexManagement.Alias>();
		Instance.Aliases.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the target index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> Settings(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Settings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the target index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> Settings()
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration options for the target index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> Settings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> AddSetting(string key, object value)
	{
		Instance.Settings ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Settings.Add(key, value);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.CloneIndexRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}