// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

public sealed partial class AnalyzeIndexRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Get tokens from text analysis.
/// The analyze API performs analysis on a text string and returns the resulting tokens.
/// </para>
/// <para>
/// Generating excessive amount of tokens may cause a node to run out of memory.
/// The <c>index.analyze.max_token_count</c> setting enables you to limit the number of tokens that can be produced.
/// If more than this limit of tokens gets generated, an error occurs.
/// The <c>_analyze</c> endpoint without a specified index will always use <c>10000</c> as its limit.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.AnalyzeIndexRequestConverter))]
public sealed partial class AnalyzeIndexRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestParameters>
{
	public AnalyzeIndexRequest(Elastic.Clients.Elasticsearch.IndexName? index) : base(r => r.Optional("index", index))
	{
	}
#if NET7_0_OR_GREATER
	public AnalyzeIndexRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public AnalyzeIndexRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AnalyzeIndexRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.IndexManagementAnalyze;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "indices.analyze";

	/// <summary>
	/// <para>
	/// Index used to derive the analyzer.
	/// If specified, the <c>analyzer</c> or field parameter overrides this value.
	/// If no index is specified or the index does not have a default analyzer, the analyze API uses the standard analyzer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexName? Index { get => P<Elastic.Clients.Elasticsearch.IndexName?>("index"); set => PO("index", value); }

	/// <summary>
	/// <para>
	/// The name of the analyzer that should be applied to the provided <c>text</c>.
	/// This could be a built-in analyzer, or an analyzer that’s been configured in the index.
	/// </para>
	/// </summary>
	public string? Analyzer { get; set; }

	/// <summary>
	/// <para>
	/// Array of token attributes used to filter the output of the <c>explain</c> parameter.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Attributes { get; set; }

	/// <summary>
	/// <para>
	/// Array of character filters used to preprocess characters before the tokenizer.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Analysis.ICharFilter>? CharFilter { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes token attributes and additional details.
	/// </para>
	/// </summary>
	public bool? Explain { get; set; }

	/// <summary>
	/// <para>
	/// Field used to derive the analyzer.
	/// To use this parameter, you must specify an index.
	/// If specified, the <c>analyzer</c> parameter overrides this value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? Field { get; set; }

	/// <summary>
	/// <para>
	/// Array of token filters used to apply after the tokenizer.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Analysis.ITokenFilter>? Filter { get; set; }

	/// <summary>
	/// <para>
	/// Normalizer to use to convert text into a single token.
	/// </para>
	/// </summary>
	public string? Normalizer { get; set; }

	/// <summary>
	/// <para>
	/// Text to analyze.
	/// If an array of strings is provided, it is analyzed as a multi-value field.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Text { get; set; }

	/// <summary>
	/// <para>
	/// Tokenizer to use to convert text into tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer? Tokenizer { get; set; }
}

/// <summary>
/// <para>
/// Get tokens from text analysis.
/// The analyze API performs analysis on a text string and returns the resulting tokens.
/// </para>
/// <para>
/// Generating excessive amount of tokens may cause a node to run out of memory.
/// The <c>index.analyze.max_token_count</c> setting enables you to limit the number of tokens that can be produced.
/// If more than this limit of tokens gets generated, an error occurs.
/// The <c>_analyze</c> endpoint without a specified index will always use <c>10000</c> as its limit.
/// </para>
/// </summary>
public readonly partial struct AnalyzeIndexRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AnalyzeIndexRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest instance)
	{
		Instance = instance;
	}

	public AnalyzeIndexRequestDescriptor(Elastic.Clients.Elasticsearch.IndexName? index)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest(index);
	}

	public AnalyzeIndexRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest(Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Index used to derive the analyzer.
	/// If specified, the <c>analyzer</c> or field parameter overrides this value.
	/// If no index is specified or the index does not have a default analyzer, the analyze API uses the standard analyzer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor Index(Elastic.Clients.Elasticsearch.IndexName? value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the analyzer that should be applied to the provided <c>text</c>.
	/// This could be a built-in analyzer, or an analyzer that’s been configured in the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of token attributes used to filter the output of the <c>explain</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor Attributes(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Attributes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of token attributes used to filter the output of the <c>explain</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor Attributes(params string[] values)
	{
		Instance.Attributes = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of character filters used to preprocess characters before the tokenizer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor CharFilter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Analysis.ICharFilter>? value)
	{
		Instance.CharFilter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of character filters used to preprocess characters before the tokenizer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor CharFilter(params Elastic.Clients.Elasticsearch.Analysis.ICharFilter[] values)
	{
		Instance.CharFilter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of character filters used to preprocess characters before the tokenizer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor CharFilter(params System.Func<Elastic.Clients.Elasticsearch.Analysis.CharFilterFactory, Elastic.Clients.Elasticsearch.Analysis.ICharFilter>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Analysis.ICharFilter>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Analysis.CharFilterFactory.Build(action));
		}

		Instance.CharFilter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes token attributes and additional details.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor Explain(bool? value = true)
	{
		Instance.Explain = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field used to derive the analyzer.
	/// To use this parameter, you must specify an index.
	/// If specified, the <c>analyzer</c> parameter overrides this value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field used to derive the analyzer.
	/// To use this parameter, you must specify an index.
	/// If specified, the <c>analyzer</c> parameter overrides this value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of token filters used to apply after the tokenizer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Analysis.ITokenFilter>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of token filters used to apply after the tokenizer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor Filter(params Elastic.Clients.Elasticsearch.Analysis.ITokenFilter[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of token filters used to apply after the tokenizer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor Filter(params System.Func<Elastic.Clients.Elasticsearch.Analysis.TokenFilterFactory, Elastic.Clients.Elasticsearch.Analysis.ITokenFilter>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Analysis.ITokenFilter>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Analysis.TokenFilterFactory.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Normalizer to use to convert text into a single token.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor Normalizer(string? value)
	{
		Instance.Normalizer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Text to analyze.
	/// If an array of strings is provided, it is analyzed as a multi-value field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor Text(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Text = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Text to analyze.
	/// If an array of strings is provided, it is analyzed as a multi-value field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor Text(params string[] values)
	{
		Instance.Text = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Tokenizer to use to convert text into tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor Tokenizer(Elastic.Clients.Elasticsearch.Analysis.ITokenizer? value)
	{
		Instance.Tokenizer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Tokenizer to use to convert text into tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor Tokenizer(System.Func<Elastic.Clients.Elasticsearch.Analysis.TokenizerFactory, Elastic.Clients.Elasticsearch.Analysis.ITokenizer> action)
	{
		Instance.Tokenizer = Elastic.Clients.Elasticsearch.Analysis.TokenizerFactory.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Get tokens from text analysis.
/// The analyze API performs analysis on a text string and returns the resulting tokens.
/// </para>
/// <para>
/// Generating excessive amount of tokens may cause a node to run out of memory.
/// The <c>index.analyze.max_token_count</c> setting enables you to limit the number of tokens that can be produced.
/// If more than this limit of tokens gets generated, an error occurs.
/// The <c>_analyze</c> endpoint without a specified index will always use <c>10000</c> as its limit.
/// </para>
/// </summary>
public readonly partial struct AnalyzeIndexRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AnalyzeIndexRequestDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest instance)
	{
		Instance = instance;
	}

	public AnalyzeIndexRequestDescriptor(Elastic.Clients.Elasticsearch.IndexName? index)
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest(index);
	}

	public AnalyzeIndexRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest(typeof(TDocument));
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest instance) => new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest(Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Index used to derive the analyzer.
	/// If specified, the <c>analyzer</c> or field parameter overrides this value.
	/// If no index is specified or the index does not have a default analyzer, the analyze API uses the standard analyzer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> Index(Elastic.Clients.Elasticsearch.IndexName? value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the analyzer that should be applied to the provided <c>text</c>.
	/// This could be a built-in analyzer, or an analyzer that’s been configured in the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of token attributes used to filter the output of the <c>explain</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> Attributes(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Attributes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of token attributes used to filter the output of the <c>explain</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> Attributes(params string[] values)
	{
		Instance.Attributes = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of character filters used to preprocess characters before the tokenizer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> CharFilter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Analysis.ICharFilter>? value)
	{
		Instance.CharFilter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of character filters used to preprocess characters before the tokenizer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> CharFilter(params Elastic.Clients.Elasticsearch.Analysis.ICharFilter[] values)
	{
		Instance.CharFilter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of character filters used to preprocess characters before the tokenizer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> CharFilter(params System.Func<Elastic.Clients.Elasticsearch.Analysis.CharFilterFactory, Elastic.Clients.Elasticsearch.Analysis.ICharFilter>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Analysis.ICharFilter>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Analysis.CharFilterFactory.Build(action));
		}

		Instance.CharFilter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response includes token attributes and additional details.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> Explain(bool? value = true)
	{
		Instance.Explain = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field used to derive the analyzer.
	/// To use this parameter, you must specify an index.
	/// If specified, the <c>analyzer</c> parameter overrides this value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field used to derive the analyzer.
	/// To use this parameter, you must specify an index.
	/// If specified, the <c>analyzer</c> parameter overrides this value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of token filters used to apply after the tokenizer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Analysis.ITokenFilter>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of token filters used to apply after the tokenizer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> Filter(params Elastic.Clients.Elasticsearch.Analysis.ITokenFilter[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of token filters used to apply after the tokenizer.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> Filter(params System.Func<Elastic.Clients.Elasticsearch.Analysis.TokenFilterFactory, Elastic.Clients.Elasticsearch.Analysis.ITokenFilter>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Analysis.ITokenFilter>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Analysis.TokenFilterFactory.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Normalizer to use to convert text into a single token.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> Normalizer(string? value)
	{
		Instance.Normalizer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Text to analyze.
	/// If an array of strings is provided, it is analyzed as a multi-value field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> Text(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Text = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Text to analyze.
	/// If an array of strings is provided, it is analyzed as a multi-value field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> Text(params string[] values)
	{
		Instance.Text = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Tokenizer to use to convert text into tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> Tokenizer(Elastic.Clients.Elasticsearch.Analysis.ITokenizer? value)
	{
		Instance.Tokenizer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Tokenizer to use to convert text into tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> Tokenizer(System.Func<Elastic.Clients.Elasticsearch.Analysis.TokenizerFactory, Elastic.Clients.Elasticsearch.Analysis.ITokenizer> action)
	{
		Instance.Tokenizer = Elastic.Clients.Elasticsearch.Analysis.TokenizerFactory.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.AnalyzeIndexRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}