// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexLifecycleManagement;

public sealed partial class MigrateToDataTiersRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If true, simulates the migration from node attributes based allocation filters to data tiers, but does not perform the migration.
	/// This provides a way to retrieve the indices and ILM policies that need to be migrated.
	/// </para>
	/// </summary>
	public bool? DryRun { get => Q<bool?>("dry_run"); set => Q("dry_run", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// It can also be set to <c>-1</c> to indicate that the request should never timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }
}

/// <summary>
/// <para>
/// Migrate to data tiers routing.
/// Switch the indices, ILM policies, and legacy, composable, and component templates from using custom node attributes and attribute-based allocation filters to using data tiers.
/// Optionally, delete one legacy index template.
/// Using node roles enables ILM to automatically move the indices between data tiers.
/// </para>
/// <para>
/// Migrating away from custom node attributes routing can be manually performed.
/// This API provides an automated way of performing three out of the four manual steps listed in the migration guide:
/// </para>
/// <list type="number">
/// <item>
/// <para>
/// Stop setting the custom hot attribute on new indices.
/// </para>
/// </item>
/// <item>
/// <para>
/// Remove custom allocation settings from existing ILM policies.
/// </para>
/// </item>
/// <item>
/// <para>
/// Replace custom allocation settings from existing indices with the corresponding tier preference.
/// </para>
/// </item>
/// </list>
/// <para>
/// ILM must be stopped before performing the migration.
/// Use the stop ILM and get ILM status APIs to wait until the reported operation mode is <c>STOPPED</c>.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexLifecycleManagement.Json.MigrateToDataTiersRequestConverter))]
public sealed partial class MigrateToDataTiersRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequestParameters>
{
#if NET7_0_OR_GREATER
	public MigrateToDataTiersRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public MigrateToDataTiersRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MigrateToDataTiersRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.IndexLifecycleManagementMigrateToDataTiers;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ilm.migrate_to_data_tiers";

	/// <summary>
	/// <para>
	/// If true, simulates the migration from node attributes based allocation filters to data tiers, but does not perform the migration.
	/// This provides a way to retrieve the indices and ILM policies that need to be migrated.
	/// </para>
	/// </summary>
	public bool? DryRun { get => Q<bool?>("dry_run"); set => Q("dry_run", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// It can also be set to <c>-1</c> to indicate that the request should never timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }
	public string? LegacyTemplateToDelete { get; set; }
	public string? NodeAttribute { get; set; }
}

/// <summary>
/// <para>
/// Migrate to data tiers routing.
/// Switch the indices, ILM policies, and legacy, composable, and component templates from using custom node attributes and attribute-based allocation filters to using data tiers.
/// Optionally, delete one legacy index template.
/// Using node roles enables ILM to automatically move the indices between data tiers.
/// </para>
/// <para>
/// Migrating away from custom node attributes routing can be manually performed.
/// This API provides an automated way of performing three out of the four manual steps listed in the migration guide:
/// </para>
/// <list type="number">
/// <item>
/// <para>
/// Stop setting the custom hot attribute on new indices.
/// </para>
/// </item>
/// <item>
/// <para>
/// Remove custom allocation settings from existing ILM policies.
/// </para>
/// </item>
/// <item>
/// <para>
/// Replace custom allocation settings from existing indices with the corresponding tier preference.
/// </para>
/// </item>
/// </list>
/// <para>
/// ILM must be stopped before performing the migration.
/// Use the stop ILM and get ILM status APIs to wait until the reported operation mode is <c>STOPPED</c>.
/// </para>
/// </summary>
public readonly partial struct MigrateToDataTiersRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MigrateToDataTiersRequestDescriptor(Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequest instance)
	{
		Instance = instance;
	}

	public MigrateToDataTiersRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequestDescriptor(Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequest instance) => new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequest(Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If true, simulates the migration from node attributes based allocation filters to data tiers, but does not perform the migration.
	/// This provides a way to retrieve the indices and ILM policies that need to be migrated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequestDescriptor DryRun(bool? value = true)
	{
		Instance.DryRun = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// It can also be set to <c>-1</c> to indicate that the request should never timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequestDescriptor LegacyTemplateToDelete(string? value)
	{
		Instance.LegacyTemplateToDelete = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequestDescriptor NodeAttribute(string? value)
	{
		Instance.NodeAttribute = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequest Build(System.Action<Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequestDescriptor(new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.MigrateToDataTiersRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}