// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.GetResponseConverterFactory))]
public sealed partial class GetResponse<TDocument> : Elastic.Transport.Products.Elasticsearch.ElasticsearchResponse
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetResponse()
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetResponse(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If the <c>stored_fields</c> parameter is set to <c>true</c> and <c>found</c> is <c>true</c>, it contains the document fields stored in the index.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyDictionary<string, object>? Fields { get; set; }

	/// <summary>
	/// <para>
	/// Indicates whether the document exists.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool Found { get; set; }

	/// <summary>
	/// <para>
	/// The unique identifier for the document.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Id { get; set; }
	public System.Collections.Generic.IReadOnlyCollection<string>? Ignored { get; set; }

	/// <summary>
	/// <para>
	/// The name of the index the document belongs to.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Index { get; set; }

	/// <summary>
	/// <para>
	/// The primary term assigned to the document for the indexing operation.
	/// </para>
	/// </summary>
	public long? PrimaryTerm { get; set; }

	/// <summary>
	/// <para>
	/// The explicit routing, if set.
	/// </para>
	/// </summary>
	public string? Routing { get; set; }

	/// <summary>
	/// <para>
	/// The sequence number assigned to the document for the indexing operation.
	/// Sequence numbers are used to ensure an older version of a document doesn't overwrite a newer version.
	/// </para>
	/// </summary>
	public long? SeqNo { get; set; }

	/// <summary>
	/// <para>
	/// If <c>found</c> is <c>true</c>, it contains the document data formatted in JSON.
	/// If the <c>_source</c> parameter is set to <c>false</c> or the <c>stored_fields</c> parameter is set to <c>true</c>, it is excluded.
	/// </para>
	/// </summary>
	public TDocument? Source { get; set; }

	/// <summary>
	/// <para>
	/// The document version, which is ncremented each time the document is updated.
	/// </para>
	/// </summary>
	public long? Version { get; set; }
}