// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

public sealed partial class GetRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Indicates whether the request forces synthetic <c>_source</c>.
	/// Use this parameter to test if the mapping supports synthetic <c>_source</c> and to get a sense of the worst case performance.
	/// Fetches with this parameter enabled will be slower than enabling synthetic source natively in the index.
	/// </para>
	/// </summary>
	public bool? ForceSyntheticSource { get => Q<bool?>("force_synthetic_source"); set => Q("force_synthetic_source", value); }

	/// <summary>
	/// <para>
	/// The node or shard the operation should be performed on.
	/// By default, the operation is randomized between the shard replicas.
	/// </para>
	/// <para>
	/// If it is set to <c>_local</c>, the operation will prefer to be run on a local allocated shard when possible.
	/// If it is set to a custom value, the value is used to guarantee that the same shards will be used for the same custom value.
	/// This can help with "jumping values" when hitting different shards in different refresh states.
	/// A sample value can be something like the web session ID or the user name.
	/// </para>
	/// </summary>
	public string? Preference { get => Q<string?>("preference"); set => Q("preference", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request is real-time as opposed to near-real-time.
	/// </para>
	/// </summary>
	public bool? Realtime { get => Q<bool?>("realtime"); set => Q("realtime", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request refreshes the relevant shards before retrieving the document.
	/// Setting it to <c>true</c> should be done after careful thought and verification that this does not cause a heavy load on the system (and slow down indexing).
	/// </para>
	/// </summary>
	public bool? Refresh { get => Q<bool?>("refresh"); set => Q("refresh", value); }

	/// <summary>
	/// <para>
	/// A custom value used to route operations to a specific shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Routing? Routing { get => Q<Elastic.Clients.Elasticsearch.Routing?>("routing"); set => Q("routing", value); }

	/// <summary>
	/// <para>
	/// Indicates whether to return the <c>_source</c> field (<c>true</c> or <c>false</c>) or lists the fields to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam? Source { get => Q<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam?>("_source"); set => Q("_source", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to exclude from the response.
	/// You can also use this parameter to exclude fields from the subset specified in <c>_source_includes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? SourceExcludes { get => Q<Elastic.Clients.Elasticsearch.Fields?>("_source_excludes"); set => Q("_source_excludes", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to include in the response.
	/// If this parameter is specified, only these source fields are returned.
	/// You can exclude fields from this subset using the <c>_source_excludes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? SourceIncludes { get => Q<Elastic.Clients.Elasticsearch.Fields?>("_source_includes"); set => Q("_source_includes", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of stored fields to return as part of a hit.
	/// If no fields are specified, no stored fields are included in the response.
	/// If this field is specified, the <c>_source</c> parameter defaults to <c>false</c>.
	/// Only leaf fields can be retrieved with the <c>stored_fields</c> option.
	/// Object fields can't be returned; if specified, the request fails.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? StoredFields { get => Q<Elastic.Clients.Elasticsearch.Fields?>("stored_fields"); set => Q("stored_fields", value); }

	/// <summary>
	/// <para>
	/// The version number for concurrency control.
	/// It must match the current version of the document for the request to succeed.
	/// </para>
	/// </summary>
	public long? Version { get => Q<long?>("version"); set => Q("version", value); }

	/// <summary>
	/// <para>
	/// The version type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.VersionType? VersionType { get => Q<Elastic.Clients.Elasticsearch.VersionType?>("version_type"); set => Q("version_type", value); }
}

/// <summary>
/// <para>
/// Get a document by its ID.
/// </para>
/// <para>
/// Get a document and its source or stored fields from an index.
/// </para>
/// <para>
/// By default, this API is realtime and is not affected by the refresh rate of the index (when data will become visible for search).
/// In the case where stored fields are requested with the <c>stored_fields</c> parameter and the document has been updated but is not yet refreshed, the API will have to parse and analyze the source to extract the stored fields.
/// To turn off realtime behavior, set the <c>realtime</c> parameter to false.
/// </para>
/// <para>
/// <strong>Source filtering</strong>
/// </para>
/// <para>
/// By default, the API returns the contents of the <c>_source</c> field unless you have used the <c>stored_fields</c> parameter or the <c>_source</c> field is turned off.
/// You can turn off <c>_source</c> retrieval by using the <c>_source</c> parameter:
/// </para>
/// <code>
/// GET my-index-000001/_doc/0?_source=false
/// </code>
/// <para>
/// If you only need one or two fields from the <c>_source</c>, use the <c>_source_includes</c> or <c>_source_excludes</c> parameters to include or filter out particular fields.
/// This can be helpful with large documents where partial retrieval can save on network overhead
/// Both parameters take a comma separated list of fields or wildcard expressions.
/// For example:
/// </para>
/// <code>
/// GET my-index-000001/_doc/0?_source_includes=*.id&amp;_source_excludes=entities
/// </code>
/// <para>
/// If you only want to specify includes, you can use a shorter notation:
/// </para>
/// <code>
/// GET my-index-000001/_doc/0?_source=*.id
/// </code>
/// <para>
/// <strong>Routing</strong>
/// </para>
/// <para>
/// If routing is used during indexing, the routing value also needs to be specified to retrieve a document.
/// For example:
/// </para>
/// <code>
/// GET my-index-000001/_doc/2?routing=user1
/// </code>
/// <para>
/// This request gets the document with ID 2, but it is routed based on the user.
/// The document is not fetched if the correct routing is not specified.
/// </para>
/// <para>
/// <strong>Distributed</strong>
/// </para>
/// <para>
/// The GET operation is hashed into a specific shard ID.
/// It is then redirected to one of the replicas within that shard ID and returns the result.
/// The replicas are the primary shard and its replicas within that shard ID group.
/// This means that the more replicas you have, the better your GET scaling will be.
/// </para>
/// <para>
/// <strong>Versioning support</strong>
/// </para>
/// <para>
/// You can use the <c>version</c> parameter to retrieve the document only if its current version is equal to the specified one.
/// </para>
/// <para>
/// Internally, Elasticsearch has marked the old document as deleted and added an entirely new document.
/// The old version of the document doesn't disappear immediately, although you won't be able to access it.
/// Elasticsearch cleans up deleted documents in the background as you continue to index more data.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.GetRequestConverter))]
public sealed partial class GetRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.GetRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetRequest(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.Id id) : base(r => r.Required("index", index).Required("id", id))
	{
	}
#if NET7_0_OR_GREATER
	public GetRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.NoNamespaceGet;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "get";

	/// <summary>
	/// <para>
	/// A unique document identifier.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id Id { get => P<Elastic.Clients.Elasticsearch.Id>("id"); set => PR("id", value); }

	/// <summary>
	/// <para>
	/// The name of the index that contains the document.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexName Index { get => P<Elastic.Clients.Elasticsearch.IndexName>("index"); set => PR("index", value); }

	/// <summary>
	/// <para>
	/// Indicates whether the request forces synthetic <c>_source</c>.
	/// Use this parameter to test if the mapping supports synthetic <c>_source</c> and to get a sense of the worst case performance.
	/// Fetches with this parameter enabled will be slower than enabling synthetic source natively in the index.
	/// </para>
	/// </summary>
	public bool? ForceSyntheticSource { get => Q<bool?>("force_synthetic_source"); set => Q("force_synthetic_source", value); }

	/// <summary>
	/// <para>
	/// The node or shard the operation should be performed on.
	/// By default, the operation is randomized between the shard replicas.
	/// </para>
	/// <para>
	/// If it is set to <c>_local</c>, the operation will prefer to be run on a local allocated shard when possible.
	/// If it is set to a custom value, the value is used to guarantee that the same shards will be used for the same custom value.
	/// This can help with "jumping values" when hitting different shards in different refresh states.
	/// A sample value can be something like the web session ID or the user name.
	/// </para>
	/// </summary>
	public string? Preference { get => Q<string?>("preference"); set => Q("preference", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request is real-time as opposed to near-real-time.
	/// </para>
	/// </summary>
	public bool? Realtime { get => Q<bool?>("realtime"); set => Q("realtime", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request refreshes the relevant shards before retrieving the document.
	/// Setting it to <c>true</c> should be done after careful thought and verification that this does not cause a heavy load on the system (and slow down indexing).
	/// </para>
	/// </summary>
	public bool? Refresh { get => Q<bool?>("refresh"); set => Q("refresh", value); }

	/// <summary>
	/// <para>
	/// A custom value used to route operations to a specific shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Routing? Routing { get => Q<Elastic.Clients.Elasticsearch.Routing?>("routing"); set => Q("routing", value); }

	/// <summary>
	/// <para>
	/// Indicates whether to return the <c>_source</c> field (<c>true</c> or <c>false</c>) or lists the fields to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam? Source { get => Q<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam?>("_source"); set => Q("_source", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to exclude from the response.
	/// You can also use this parameter to exclude fields from the subset specified in <c>_source_includes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? SourceExcludes { get => Q<Elastic.Clients.Elasticsearch.Fields?>("_source_excludes"); set => Q("_source_excludes", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to include in the response.
	/// If this parameter is specified, only these source fields are returned.
	/// You can exclude fields from this subset using the <c>_source_excludes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? SourceIncludes { get => Q<Elastic.Clients.Elasticsearch.Fields?>("_source_includes"); set => Q("_source_includes", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of stored fields to return as part of a hit.
	/// If no fields are specified, no stored fields are included in the response.
	/// If this field is specified, the <c>_source</c> parameter defaults to <c>false</c>.
	/// Only leaf fields can be retrieved with the <c>stored_fields</c> option.
	/// Object fields can't be returned; if specified, the request fails.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? StoredFields { get => Q<Elastic.Clients.Elasticsearch.Fields?>("stored_fields"); set => Q("stored_fields", value); }

	/// <summary>
	/// <para>
	/// The version number for concurrency control.
	/// It must match the current version of the document for the request to succeed.
	/// </para>
	/// </summary>
	public long? Version { get => Q<long?>("version"); set => Q("version", value); }

	/// <summary>
	/// <para>
	/// The version type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.VersionType? VersionType { get => Q<Elastic.Clients.Elasticsearch.VersionType?>("version_type"); set => Q("version_type", value); }
}

/// <summary>
/// <para>
/// Get a document by its ID.
/// </para>
/// <para>
/// Get a document and its source or stored fields from an index.
/// </para>
/// <para>
/// By default, this API is realtime and is not affected by the refresh rate of the index (when data will become visible for search).
/// In the case where stored fields are requested with the <c>stored_fields</c> parameter and the document has been updated but is not yet refreshed, the API will have to parse and analyze the source to extract the stored fields.
/// To turn off realtime behavior, set the <c>realtime</c> parameter to false.
/// </para>
/// <para>
/// <strong>Source filtering</strong>
/// </para>
/// <para>
/// By default, the API returns the contents of the <c>_source</c> field unless you have used the <c>stored_fields</c> parameter or the <c>_source</c> field is turned off.
/// You can turn off <c>_source</c> retrieval by using the <c>_source</c> parameter:
/// </para>
/// <code>
/// GET my-index-000001/_doc/0?_source=false
/// </code>
/// <para>
/// If you only need one or two fields from the <c>_source</c>, use the <c>_source_includes</c> or <c>_source_excludes</c> parameters to include or filter out particular fields.
/// This can be helpful with large documents where partial retrieval can save on network overhead
/// Both parameters take a comma separated list of fields or wildcard expressions.
/// For example:
/// </para>
/// <code>
/// GET my-index-000001/_doc/0?_source_includes=*.id&amp;_source_excludes=entities
/// </code>
/// <para>
/// If you only want to specify includes, you can use a shorter notation:
/// </para>
/// <code>
/// GET my-index-000001/_doc/0?_source=*.id
/// </code>
/// <para>
/// <strong>Routing</strong>
/// </para>
/// <para>
/// If routing is used during indexing, the routing value also needs to be specified to retrieve a document.
/// For example:
/// </para>
/// <code>
/// GET my-index-000001/_doc/2?routing=user1
/// </code>
/// <para>
/// This request gets the document with ID 2, but it is routed based on the user.
/// The document is not fetched if the correct routing is not specified.
/// </para>
/// <para>
/// <strong>Distributed</strong>
/// </para>
/// <para>
/// The GET operation is hashed into a specific shard ID.
/// It is then redirected to one of the replicas within that shard ID and returns the result.
/// The replicas are the primary shard and its replicas within that shard ID group.
/// This means that the more replicas you have, the better your GET scaling will be.
/// </para>
/// <para>
/// <strong>Versioning support</strong>
/// </para>
/// <para>
/// You can use the <c>version</c> parameter to retrieve the document only if its current version is equal to the specified one.
/// </para>
/// <para>
/// Internally, Elasticsearch has marked the old document as deleted and added an entirely new document.
/// The old version of the document doesn't disappear immediately, although you won't be able to access it.
/// Elasticsearch cleans up deleted documents in the background as you continue to index more data.
/// </para>
/// </summary>
public readonly partial struct GetRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.GetRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetRequestDescriptor(Elastic.Clients.Elasticsearch.GetRequest instance)
	{
		Instance = instance;
	}

	public GetRequestDescriptor(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.Id id)
	{
		Instance = new Elastic.Clients.Elasticsearch.GetRequest(index, id);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public GetRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.GetRequestDescriptor(Elastic.Clients.Elasticsearch.GetRequest instance) => new Elastic.Clients.Elasticsearch.GetRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.GetRequest(Elastic.Clients.Elasticsearch.GetRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A unique document identifier.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the index that contains the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor Index(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether the request forces synthetic <c>_source</c>.
	/// Use this parameter to test if the mapping supports synthetic <c>_source</c> and to get a sense of the worst case performance.
	/// Fetches with this parameter enabled will be slower than enabling synthetic source natively in the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor ForceSyntheticSource(bool? value = true)
	{
		Instance.ForceSyntheticSource = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The node or shard the operation should be performed on.
	/// By default, the operation is randomized between the shard replicas.
	/// </para>
	/// <para>
	/// If it is set to <c>_local</c>, the operation will prefer to be run on a local allocated shard when possible.
	/// If it is set to a custom value, the value is used to guarantee that the same shards will be used for the same custom value.
	/// This can help with "jumping values" when hitting different shards in different refresh states.
	/// A sample value can be something like the web session ID or the user name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor Preference(string? value)
	{
		Instance.Preference = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request is real-time as opposed to near-real-time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor Realtime(bool? value = true)
	{
		Instance.Realtime = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request refreshes the relevant shards before retrieving the document.
	/// Setting it to <c>true</c> should be done after careful thought and verification that this does not cause a heavy load on the system (and slow down indexing).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor Refresh(bool? value = true)
	{
		Instance.Refresh = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A custom value used to route operations to a specific shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor Routing(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.Routing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether to return the <c>_source</c> field (<c>true</c> or <c>false</c>) or lists the fields to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor Source(Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam? value)
	{
		Instance.Source = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether to return the <c>_source</c> field (<c>true</c> or <c>false</c>) or lists the fields to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor Source(System.Func<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParamFactory, Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParamFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether to return the <c>_source</c> field (<c>true</c> or <c>false</c>) or lists the fields to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor Source<T>(System.Func<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParamFactory<T>, Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParamFactory<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to exclude from the response.
	/// You can also use this parameter to exclude fields from the subset specified in <c>_source_includes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor SourceExcludes(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.SourceExcludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to exclude from the response.
	/// You can also use this parameter to exclude fields from the subset specified in <c>_source_includes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor SourceExcludes<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.SourceExcludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to include in the response.
	/// If this parameter is specified, only these source fields are returned.
	/// You can exclude fields from this subset using the <c>_source_excludes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor SourceIncludes(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.SourceIncludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to include in the response.
	/// If this parameter is specified, only these source fields are returned.
	/// You can exclude fields from this subset using the <c>_source_excludes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor SourceIncludes<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.SourceIncludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of stored fields to return as part of a hit.
	/// If no fields are specified, no stored fields are included in the response.
	/// If this field is specified, the <c>_source</c> parameter defaults to <c>false</c>.
	/// Only leaf fields can be retrieved with the <c>stored_fields</c> option.
	/// Object fields can't be returned; if specified, the request fails.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor StoredFields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.StoredFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of stored fields to return as part of a hit.
	/// If no fields are specified, no stored fields are included in the response.
	/// If this field is specified, the <c>_source</c> parameter defaults to <c>false</c>.
	/// Only leaf fields can be retrieved with the <c>stored_fields</c> option.
	/// Object fields can't be returned; if specified, the request fails.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor StoredFields<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.StoredFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The version number for concurrency control.
	/// It must match the current version of the document for the request to succeed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor Version(long? value)
	{
		Instance.Version = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The version type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor VersionType(Elastic.Clients.Elasticsearch.VersionType? value)
	{
		Instance.VersionType = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.GetRequest Build(System.Action<Elastic.Clients.Elasticsearch.GetRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.GetRequestDescriptor(new Elastic.Clients.Elasticsearch.GetRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.GetRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.GetRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.GetRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.GetRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.GetRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.GetRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.GetRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Get a document by its ID.
/// </para>
/// <para>
/// Get a document and its source or stored fields from an index.
/// </para>
/// <para>
/// By default, this API is realtime and is not affected by the refresh rate of the index (when data will become visible for search).
/// In the case where stored fields are requested with the <c>stored_fields</c> parameter and the document has been updated but is not yet refreshed, the API will have to parse and analyze the source to extract the stored fields.
/// To turn off realtime behavior, set the <c>realtime</c> parameter to false.
/// </para>
/// <para>
/// <strong>Source filtering</strong>
/// </para>
/// <para>
/// By default, the API returns the contents of the <c>_source</c> field unless you have used the <c>stored_fields</c> parameter or the <c>_source</c> field is turned off.
/// You can turn off <c>_source</c> retrieval by using the <c>_source</c> parameter:
/// </para>
/// <code>
/// GET my-index-000001/_doc/0?_source=false
/// </code>
/// <para>
/// If you only need one or two fields from the <c>_source</c>, use the <c>_source_includes</c> or <c>_source_excludes</c> parameters to include or filter out particular fields.
/// This can be helpful with large documents where partial retrieval can save on network overhead
/// Both parameters take a comma separated list of fields or wildcard expressions.
/// For example:
/// </para>
/// <code>
/// GET my-index-000001/_doc/0?_source_includes=*.id&amp;_source_excludes=entities
/// </code>
/// <para>
/// If you only want to specify includes, you can use a shorter notation:
/// </para>
/// <code>
/// GET my-index-000001/_doc/0?_source=*.id
/// </code>
/// <para>
/// <strong>Routing</strong>
/// </para>
/// <para>
/// If routing is used during indexing, the routing value also needs to be specified to retrieve a document.
/// For example:
/// </para>
/// <code>
/// GET my-index-000001/_doc/2?routing=user1
/// </code>
/// <para>
/// This request gets the document with ID 2, but it is routed based on the user.
/// The document is not fetched if the correct routing is not specified.
/// </para>
/// <para>
/// <strong>Distributed</strong>
/// </para>
/// <para>
/// The GET operation is hashed into a specific shard ID.
/// It is then redirected to one of the replicas within that shard ID and returns the result.
/// The replicas are the primary shard and its replicas within that shard ID group.
/// This means that the more replicas you have, the better your GET scaling will be.
/// </para>
/// <para>
/// <strong>Versioning support</strong>
/// </para>
/// <para>
/// You can use the <c>version</c> parameter to retrieve the document only if its current version is equal to the specified one.
/// </para>
/// <para>
/// Internally, Elasticsearch has marked the old document as deleted and added an entirely new document.
/// The old version of the document doesn't disappear immediately, although you won't be able to access it.
/// Elasticsearch cleans up deleted documents in the background as you continue to index more data.
/// </para>
/// </summary>
public readonly partial struct GetRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.GetRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetRequestDescriptor(Elastic.Clients.Elasticsearch.GetRequest instance)
	{
		Instance = instance;
	}

	public GetRequestDescriptor(Elastic.Clients.Elasticsearch.IndexName index, Elastic.Clients.Elasticsearch.Id id)
	{
		Instance = new Elastic.Clients.Elasticsearch.GetRequest(index, id);
	}

	public GetRequestDescriptor(string index, Elastic.Clients.Elasticsearch.Id id)
	{
		Instance = new Elastic.Clients.Elasticsearch.GetRequest((Elastic.Clients.Elasticsearch.IndexName)index, id);
	}

	public GetRequestDescriptor(TDocument document)
	{
		Instance = new Elastic.Clients.Elasticsearch.GetRequest(typeof(TDocument), Elastic.Clients.Elasticsearch.Id.From(document));
	}

	public GetRequestDescriptor(TDocument document, Elastic.Clients.Elasticsearch.Id id)
	{
		Instance = new Elastic.Clients.Elasticsearch.GetRequest(typeof(TDocument), id);
	}

	public GetRequestDescriptor(Elastic.Clients.Elasticsearch.Id id)
	{
		Instance = new Elastic.Clients.Elasticsearch.GetRequest(typeof(TDocument), id);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public GetRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.GetRequest instance) => new Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.GetRequest(Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A unique document identifier.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the index that contains the document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> Index(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether the request forces synthetic <c>_source</c>.
	/// Use this parameter to test if the mapping supports synthetic <c>_source</c> and to get a sense of the worst case performance.
	/// Fetches with this parameter enabled will be slower than enabling synthetic source natively in the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> ForceSyntheticSource(bool? value = true)
	{
		Instance.ForceSyntheticSource = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The node or shard the operation should be performed on.
	/// By default, the operation is randomized between the shard replicas.
	/// </para>
	/// <para>
	/// If it is set to <c>_local</c>, the operation will prefer to be run on a local allocated shard when possible.
	/// If it is set to a custom value, the value is used to guarantee that the same shards will be used for the same custom value.
	/// This can help with "jumping values" when hitting different shards in different refresh states.
	/// A sample value can be something like the web session ID or the user name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> Preference(string? value)
	{
		Instance.Preference = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request is real-time as opposed to near-real-time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> Realtime(bool? value = true)
	{
		Instance.Realtime = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request refreshes the relevant shards before retrieving the document.
	/// Setting it to <c>true</c> should be done after careful thought and verification that this does not cause a heavy load on the system (and slow down indexing).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> Refresh(bool? value = true)
	{
		Instance.Refresh = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A custom value used to route operations to a specific shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> Routing(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.Routing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether to return the <c>_source</c> field (<c>true</c> or <c>false</c>) or lists the fields to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> Source(Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam? value)
	{
		Instance.Source = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether to return the <c>_source</c> field (<c>true</c> or <c>false</c>) or lists the fields to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> Source(System.Func<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParamFactory<TDocument>, Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParamFactory<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to exclude from the response.
	/// You can also use this parameter to exclude fields from the subset specified in <c>_source_includes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> SourceExcludes(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.SourceExcludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to exclude from the response.
	/// You can also use this parameter to exclude fields from the subset specified in <c>_source_includes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> SourceExcludes(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.SourceExcludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to include in the response.
	/// If this parameter is specified, only these source fields are returned.
	/// You can exclude fields from this subset using the <c>_source_excludes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> SourceIncludes(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.SourceIncludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of source fields to include in the response.
	/// If this parameter is specified, only these source fields are returned.
	/// You can exclude fields from this subset using the <c>_source_excludes</c> query parameter.
	/// If the <c>_source</c> parameter is <c>false</c>, this parameter is ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> SourceIncludes(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.SourceIncludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of stored fields to return as part of a hit.
	/// If no fields are specified, no stored fields are included in the response.
	/// If this field is specified, the <c>_source</c> parameter defaults to <c>false</c>.
	/// Only leaf fields can be retrieved with the <c>stored_fields</c> option.
	/// Object fields can't be returned; if specified, the request fails.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> StoredFields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.StoredFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of stored fields to return as part of a hit.
	/// If no fields are specified, no stored fields are included in the response.
	/// If this field is specified, the <c>_source</c> parameter defaults to <c>false</c>.
	/// Only leaf fields can be retrieved with the <c>stored_fields</c> option.
	/// Object fields can't be returned; if specified, the request fails.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> StoredFields(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.StoredFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The version number for concurrency control.
	/// It must match the current version of the document for the request to succeed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> Version(long? value)
	{
		Instance.Version = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The version type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> VersionType(Elastic.Clients.Elasticsearch.VersionType? value)
	{
		Instance.VersionType = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.GetRequest Build(System.Action<Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.GetRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.GetRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}