// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

public sealed partial class FieldCapsRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If false, the request returns an error if any wildcard expression, index alias,
	/// or <c>_all</c> value targets only missing or closed indices. This behavior applies even if the request targets other open indices. For example, a request
	/// targeting <c>foo*,bar*</c> returns an error if an index starts with foo but no index starts with bar.
	/// </para>
	/// </summary>
	public bool? AllowNoIndices { get => Q<bool?>("allow_no_indices"); set => Q("allow_no_indices", value); }

	/// <summary>
	/// <para>
	/// The type of index that wildcard patterns can match. If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams. Supports comma-separated values, such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? ExpandWildcards { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>?>("expand_wildcards"); set => Q("expand_wildcards", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of filters to apply to the response.
	/// </para>
	/// </summary>
	public string? Filters { get => Q<string?>("filters"); set => Q("filters", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, missing or closed indices are not included in the response.
	/// </para>
	/// </summary>
	public bool? IgnoreUnavailable { get => Q<bool?>("ignore_unavailable"); set => Q("ignore_unavailable", value); }

	/// <summary>
	/// <para>
	/// If false, empty fields are not included in the response.
	/// </para>
	/// </summary>
	public bool? IncludeEmptyFields { get => Q<bool?>("include_empty_fields"); set => Q("include_empty_fields", value); }

	/// <summary>
	/// <para>
	/// If true, unmapped fields are included in the response.
	/// </para>
	/// </summary>
	public bool? IncludeUnmapped { get => Q<bool?>("include_unmapped"); set => Q("include_unmapped", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of field types to include.
	/// Any fields that do not match one of these types will be excluded from the results.
	/// It defaults to empty, meaning that all field types are returned.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Types { get => Q<System.Collections.Generic.ICollection<string>?>("types"); set => Q("types", value); }
}

/// <summary>
/// <para>
/// Get the field capabilities.
/// </para>
/// <para>
/// Get information about the capabilities of fields among multiple indices.
/// </para>
/// <para>
/// For data streams, the API returns field capabilities among the stream’s backing indices.
/// It returns runtime fields like any other field.
/// For example, a runtime field with a type of keyword is returned the same as any other field that belongs to the <c>keyword</c> family.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.FieldCapsRequestConverter))]
public sealed partial class FieldCapsRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.FieldCapsRequestParameters>
{
	public FieldCapsRequest(Elastic.Clients.Elasticsearch.Indices? indices) : base(r => r.Optional("index", indices))
	{
	}
#if NET7_0_OR_GREATER
	public FieldCapsRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public FieldCapsRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FieldCapsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.NoNamespaceFieldCaps;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "field_caps";

	/// <summary>
	/// <para>
	/// A comma-separated list of data streams, indices, and aliases used to limit the request. Supports wildcards (*). To target all data streams and indices, omit this parameter or use * or _all.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Indices? Indices { get => P<Elastic.Clients.Elasticsearch.Indices?>("index"); set => PO("index", value); }

	/// <summary>
	/// <para>
	/// If false, the request returns an error if any wildcard expression, index alias,
	/// or <c>_all</c> value targets only missing or closed indices. This behavior applies even if the request targets other open indices. For example, a request
	/// targeting <c>foo*,bar*</c> returns an error if an index starts with foo but no index starts with bar.
	/// </para>
	/// </summary>
	public bool? AllowNoIndices { get => Q<bool?>("allow_no_indices"); set => Q("allow_no_indices", value); }

	/// <summary>
	/// <para>
	/// The type of index that wildcard patterns can match. If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams. Supports comma-separated values, such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? ExpandWildcards { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>?>("expand_wildcards"); set => Q("expand_wildcards", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of filters to apply to the response.
	/// </para>
	/// </summary>
	public string? Filters { get => Q<string?>("filters"); set => Q("filters", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, missing or closed indices are not included in the response.
	/// </para>
	/// </summary>
	public bool? IgnoreUnavailable { get => Q<bool?>("ignore_unavailable"); set => Q("ignore_unavailable", value); }

	/// <summary>
	/// <para>
	/// If false, empty fields are not included in the response.
	/// </para>
	/// </summary>
	public bool? IncludeEmptyFields { get => Q<bool?>("include_empty_fields"); set => Q("include_empty_fields", value); }

	/// <summary>
	/// <para>
	/// If true, unmapped fields are included in the response.
	/// </para>
	/// </summary>
	public bool? IncludeUnmapped { get => Q<bool?>("include_unmapped"); set => Q("include_unmapped", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of field types to include.
	/// Any fields that do not match one of these types will be excluded from the results.
	/// It defaults to empty, meaning that all field types are returned.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Types { get => Q<System.Collections.Generic.ICollection<string>?>("types"); set => Q("types", value); }

	/// <summary>
	/// <para>
	/// A list of fields to retrieve capabilities for. Wildcard (<c>*</c>) expressions are supported.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? Fields { get; set; }

	/// <summary>
	/// <para>
	/// Filter indices if the provided query rewrites to <c>match_none</c> on every shard.
	/// </para>
	/// <para>
	/// IMPORTANT: The filtering is done on a best-effort basis, it uses index statistics and mappings to rewrite queries to <c>match_none</c> instead of fully running the request.
	/// For instance a range query over a date field can rewrite to <c>match_none</c> if all documents within a shard (including deleted documents) are outside of the provided range.
	/// However, not all queries can rewrite to <c>match_none</c> so this API may return an index even if the provided filter matches no document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? IndexFilter { get; set; }

	/// <summary>
	/// <para>
	/// Define ad-hoc runtime fields in the request similar to the way it is done in search requests.
	/// These fields exist only as part of the query and take precedence over fields defined with the same name in the index mappings.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? RuntimeMappings { get; set; }
}

/// <summary>
/// <para>
/// Get the field capabilities.
/// </para>
/// <para>
/// Get information about the capabilities of fields among multiple indices.
/// </para>
/// <para>
/// For data streams, the API returns field capabilities among the stream’s backing indices.
/// It returns runtime fields like any other field.
/// For example, a runtime field with a type of keyword is returned the same as any other field that belongs to the <c>keyword</c> family.
/// </para>
/// </summary>
public readonly partial struct FieldCapsRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.FieldCapsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldCapsRequestDescriptor(Elastic.Clients.Elasticsearch.FieldCapsRequest instance)
	{
		Instance = instance;
	}

	public FieldCapsRequestDescriptor(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		Instance = new Elastic.Clients.Elasticsearch.FieldCapsRequest(indices);
	}

	public FieldCapsRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.FieldCapsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor(Elastic.Clients.Elasticsearch.FieldCapsRequest instance) => new Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.FieldCapsRequest(Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A comma-separated list of data streams, indices, and aliases used to limit the request. Supports wildcards (*). To target all data streams and indices, omit this parameter or use * or _all.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor Indices(Elastic.Clients.Elasticsearch.Indices? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If false, the request returns an error if any wildcard expression, index alias,
	/// or <c>_all</c> value targets only missing or closed indices. This behavior applies even if the request targets other open indices. For example, a request
	/// targeting <c>foo*,bar*</c> returns an error if an index starts with foo but no index starts with bar.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor AllowNoIndices(bool? value = true)
	{
		Instance.AllowNoIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of index that wildcard patterns can match. If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams. Supports comma-separated values, such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor ExpandWildcards(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? value)
	{
		Instance.ExpandWildcards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of index that wildcard patterns can match. If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams. Supports comma-separated values, such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor ExpandWildcards(params Elastic.Clients.Elasticsearch.ExpandWildcard[] values)
	{
		Instance.ExpandWildcards = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of filters to apply to the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor Filters(string? value)
	{
		Instance.Filters = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, missing or closed indices are not included in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor IgnoreUnavailable(bool? value = true)
	{
		Instance.IgnoreUnavailable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If false, empty fields are not included in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor IncludeEmptyFields(bool? value = true)
	{
		Instance.IncludeEmptyFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, unmapped fields are included in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor IncludeUnmapped(bool? value = true)
	{
		Instance.IncludeUnmapped = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of field types to include.
	/// Any fields that do not match one of these types will be excluded from the results.
	/// It defaults to empty, meaning that all field types are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor Types(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Types = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of field types to include.
	/// Any fields that do not match one of these types will be excluded from the results.
	/// It defaults to empty, meaning that all field types are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor Types(params string[] values)
	{
		Instance.Types = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to retrieve capabilities for. Wildcard (<c>*</c>) expressions are supported.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor Fields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to retrieve capabilities for. Wildcard (<c>*</c>) expressions are supported.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor Fields<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filter indices if the provided query rewrites to <c>match_none</c> on every shard.
	/// </para>
	/// <para>
	/// IMPORTANT: The filtering is done on a best-effort basis, it uses index statistics and mappings to rewrite queries to <c>match_none</c> instead of fully running the request.
	/// For instance a range query over a date field can rewrite to <c>match_none</c> if all documents within a shard (including deleted documents) are outside of the provided range.
	/// However, not all queries can rewrite to <c>match_none</c> so this API may return an index even if the provided filter matches no document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor IndexFilter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.IndexFilter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filter indices if the provided query rewrites to <c>match_none</c> on every shard.
	/// </para>
	/// <para>
	/// IMPORTANT: The filtering is done on a best-effort basis, it uses index statistics and mappings to rewrite queries to <c>match_none</c> instead of fully running the request.
	/// For instance a range query over a date field can rewrite to <c>match_none</c> if all documents within a shard (including deleted documents) are outside of the provided range.
	/// However, not all queries can rewrite to <c>match_none</c> so this API may return an index even if the provided filter matches no document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor IndexFilter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.IndexFilter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Filter indices if the provided query rewrites to <c>match_none</c> on every shard.
	/// </para>
	/// <para>
	/// IMPORTANT: The filtering is done on a best-effort basis, it uses index statistics and mappings to rewrite queries to <c>match_none</c> instead of fully running the request.
	/// For instance a range query over a date field can rewrite to <c>match_none</c> if all documents within a shard (including deleted documents) are outside of the provided range.
	/// However, not all queries can rewrite to <c>match_none</c> so this API may return an index even if the provided filter matches no document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor IndexFilter<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.IndexFilter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Define ad-hoc runtime fields in the request similar to the way it is done in search requests.
	/// These fields exist only as part of the query and take precedence over fields defined with the same name in the index mappings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor RuntimeMappings(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.RuntimeMappings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Define ad-hoc runtime fields in the request similar to the way it is done in search requests.
	/// These fields exist only as part of the query and take precedence over fields defined with the same name in the index mappings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor RuntimeMappings()
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Define ad-hoc runtime fields in the request similar to the way it is done in search requests.
	/// These fields exist only as part of the query and take precedence over fields defined with the same name in the index mappings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor RuntimeMappings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Define ad-hoc runtime fields in the request similar to the way it is done in search requests.
	/// These fields exist only as part of the query and take precedence over fields defined with the same name in the index mappings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor RuntimeMappings<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor AddRuntimeMapping<T>(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.FieldCapsRequest Build(System.Action<Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.FieldCapsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor(new Elastic.Clients.Elasticsearch.FieldCapsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Get the field capabilities.
/// </para>
/// <para>
/// Get information about the capabilities of fields among multiple indices.
/// </para>
/// <para>
/// For data streams, the API returns field capabilities among the stream’s backing indices.
/// It returns runtime fields like any other field.
/// For example, a runtime field with a type of keyword is returned the same as any other field that belongs to the <c>keyword</c> family.
/// </para>
/// </summary>
public readonly partial struct FieldCapsRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.FieldCapsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldCapsRequestDescriptor(Elastic.Clients.Elasticsearch.FieldCapsRequest instance)
	{
		Instance = instance;
	}

	public FieldCapsRequestDescriptor(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		Instance = new Elastic.Clients.Elasticsearch.FieldCapsRequest(indices);
	}

	public FieldCapsRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.FieldCapsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.FieldCapsRequest instance) => new Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.FieldCapsRequest(Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A comma-separated list of data streams, indices, and aliases used to limit the request. Supports wildcards (*). To target all data streams and indices, omit this parameter or use * or _all.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> Indices(Elastic.Clients.Elasticsearch.Indices? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If false, the request returns an error if any wildcard expression, index alias,
	/// or <c>_all</c> value targets only missing or closed indices. This behavior applies even if the request targets other open indices. For example, a request
	/// targeting <c>foo*,bar*</c> returns an error if an index starts with foo but no index starts with bar.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> AllowNoIndices(bool? value = true)
	{
		Instance.AllowNoIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of index that wildcard patterns can match. If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams. Supports comma-separated values, such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> ExpandWildcards(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? value)
	{
		Instance.ExpandWildcards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of index that wildcard patterns can match. If the request can target data streams, this argument determines whether wildcard expressions match hidden data streams. Supports comma-separated values, such as <c>open,hidden</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> ExpandWildcards(params Elastic.Clients.Elasticsearch.ExpandWildcard[] values)
	{
		Instance.ExpandWildcards = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of filters to apply to the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> Filters(string? value)
	{
		Instance.Filters = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, missing or closed indices are not included in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> IgnoreUnavailable(bool? value = true)
	{
		Instance.IgnoreUnavailable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If false, empty fields are not included in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> IncludeEmptyFields(bool? value = true)
	{
		Instance.IncludeEmptyFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, unmapped fields are included in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> IncludeUnmapped(bool? value = true)
	{
		Instance.IncludeUnmapped = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of field types to include.
	/// Any fields that do not match one of these types will be excluded from the results.
	/// It defaults to empty, meaning that all field types are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> Types(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Types = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of field types to include.
	/// Any fields that do not match one of these types will be excluded from the results.
	/// It defaults to empty, meaning that all field types are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> Types(params string[] values)
	{
		Instance.Types = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to retrieve capabilities for. Wildcard (<c>*</c>) expressions are supported.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> Fields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to retrieve capabilities for. Wildcard (<c>*</c>) expressions are supported.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> Fields(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filter indices if the provided query rewrites to <c>match_none</c> on every shard.
	/// </para>
	/// <para>
	/// IMPORTANT: The filtering is done on a best-effort basis, it uses index statistics and mappings to rewrite queries to <c>match_none</c> instead of fully running the request.
	/// For instance a range query over a date field can rewrite to <c>match_none</c> if all documents within a shard (including deleted documents) are outside of the provided range.
	/// However, not all queries can rewrite to <c>match_none</c> so this API may return an index even if the provided filter matches no document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> IndexFilter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.IndexFilter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filter indices if the provided query rewrites to <c>match_none</c> on every shard.
	/// </para>
	/// <para>
	/// IMPORTANT: The filtering is done on a best-effort basis, it uses index statistics and mappings to rewrite queries to <c>match_none</c> instead of fully running the request.
	/// For instance a range query over a date field can rewrite to <c>match_none</c> if all documents within a shard (including deleted documents) are outside of the provided range.
	/// However, not all queries can rewrite to <c>match_none</c> so this API may return an index even if the provided filter matches no document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> IndexFilter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.IndexFilter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Define ad-hoc runtime fields in the request similar to the way it is done in search requests.
	/// These fields exist only as part of the query and take precedence over fields defined with the same name in the index mappings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> RuntimeMappings(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.RuntimeMappings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Define ad-hoc runtime fields in the request similar to the way it is done in search requests.
	/// These fields exist only as part of the query and take precedence over fields defined with the same name in the index mappings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> RuntimeMappings()
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Define ad-hoc runtime fields in the request similar to the way it is done in search requests.
	/// These fields exist only as part of the query and take precedence over fields defined with the same name in the index mappings.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> RuntimeMappings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> AddRuntimeMapping(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> AddRuntimeMapping(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.FieldCapsRequest Build(System.Action<Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.FieldCapsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.FieldCapsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldCapsRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}