// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Features;

public sealed partial class GetFeaturesRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }
}

/// <summary>
/// <para>
/// Get the features.
/// Get a list of features that can be included in snapshots using the <c>feature_states</c> field when creating a snapshot.
/// You can use this API to determine which feature states to include when taking a snapshot.
/// By default, all feature states are included in a snapshot if that snapshot includes the global state, or none if it does not.
/// </para>
/// <para>
/// A feature state includes one or more system indices necessary for a given feature to function.
/// In order to ensure data integrity, all system indices that comprise a feature state are snapshotted and restored together.
/// </para>
/// <para>
/// The features listed by this API are a combination of built-in features and features defined by plugins.
/// In order for a feature state to be listed in this API and recognized as a valid feature state by the create snapshot API, the plugin that defines that feature must be installed on the master node.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Features.Json.GetFeaturesRequestConverter))]
public sealed partial class GetFeaturesRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Features.GetFeaturesRequestParameters>
{
#if NET7_0_OR_GREATER
	public GetFeaturesRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public GetFeaturesRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetFeaturesRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.FeaturesGetFeatures;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "features.get_features";

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }
}

/// <summary>
/// <para>
/// Get the features.
/// Get a list of features that can be included in snapshots using the <c>feature_states</c> field when creating a snapshot.
/// You can use this API to determine which feature states to include when taking a snapshot.
/// By default, all feature states are included in a snapshot if that snapshot includes the global state, or none if it does not.
/// </para>
/// <para>
/// A feature state includes one or more system indices necessary for a given feature to function.
/// In order to ensure data integrity, all system indices that comprise a feature state are snapshotted and restored together.
/// </para>
/// <para>
/// The features listed by this API are a combination of built-in features and features defined by plugins.
/// In order for a feature state to be listed in this API and recognized as a valid feature state by the create snapshot API, the plugin that defines that feature must be installed on the master node.
/// </para>
/// </summary>
public readonly partial struct GetFeaturesRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Features.GetFeaturesRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetFeaturesRequestDescriptor(Elastic.Clients.Elasticsearch.Features.GetFeaturesRequest instance)
	{
		Instance = instance;
	}

	public GetFeaturesRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Features.GetFeaturesRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Features.GetFeaturesRequestDescriptor(Elastic.Clients.Elasticsearch.Features.GetFeaturesRequest instance) => new Elastic.Clients.Elasticsearch.Features.GetFeaturesRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Features.GetFeaturesRequest(Elastic.Clients.Elasticsearch.Features.GetFeaturesRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Features.GetFeaturesRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Features.GetFeaturesRequest Build(System.Action<Elastic.Clients.Elasticsearch.Features.GetFeaturesRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Features.GetFeaturesRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Features.GetFeaturesRequestDescriptor(new Elastic.Clients.Elasticsearch.Features.GetFeaturesRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Features.GetFeaturesRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Features.GetFeaturesRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Features.GetFeaturesRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Features.GetFeaturesRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Features.GetFeaturesRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Features.GetFeaturesRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Features.GetFeaturesRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}