// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Esql;

public sealed partial class EsqlQueryRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If <c>true</c>, partial results will be returned if there are shard failures, but the query can continue to execute on other clusters and shards.
	/// If <c>false</c>, the query will fail if there are any failures.
	/// </para>
	/// <para>
	/// To override the default behavior, you can set the <c>esql.query.allow_partial_results</c> cluster setting to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? AllowPartialResults { get => Q<bool?>("allow_partial_results"); set => Q("allow_partial_results", value); }

	/// <summary>
	/// <para>
	/// The character to use between values within a CSV row. Only valid for the CSV format.
	/// </para>
	/// </summary>
	public string? Delimiter { get => Q<string?>("delimiter"); set => Q("delimiter", value); }

	/// <summary>
	/// <para>
	/// Should columns that are entirely <c>null</c> be removed from the <c>columns</c> and <c>values</c> portion of the results?
	/// Defaults to <c>false</c>. If <c>true</c> then the response will include an extra section under the name <c>all_columns</c> which has the name of all columns.
	/// </para>
	/// </summary>
	public bool? DropNullColumns { get => Q<bool?>("drop_null_columns"); set => Q("drop_null_columns", value); }

	/// <summary>
	/// <para>
	/// A short version of the Accept header, e.g. json, yaml.
	/// </para>
	/// <para>
	/// <c>csv</c>, <c>tsv</c>, and <c>txt</c> formats will return results in a tabular format, excluding other metadata fields from the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlFormat? Format { get => Q<Elastic.Clients.Elasticsearch.Esql.EsqlFormat?>("format"); set => Q("format", value); }
}

/// <summary>
/// <para>
/// Run an ES|QL query.
/// Get search results for an ES|QL (Elasticsearch query language) query.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Esql.Json.EsqlQueryRequestConverter))]
public sealed partial class EsqlQueryRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EsqlQueryRequest(string query)
	{
		Query = query;
	}
#if NET7_0_OR_GREATER
	public EsqlQueryRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public EsqlQueryRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal EsqlQueryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.EsqlQuery;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "esql.query";

	/// <summary>
	/// <para>
	/// If <c>true</c>, partial results will be returned if there are shard failures, but the query can continue to execute on other clusters and shards.
	/// If <c>false</c>, the query will fail if there are any failures.
	/// </para>
	/// <para>
	/// To override the default behavior, you can set the <c>esql.query.allow_partial_results</c> cluster setting to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? AllowPartialResults { get => Q<bool?>("allow_partial_results"); set => Q("allow_partial_results", value); }

	/// <summary>
	/// <para>
	/// The character to use between values within a CSV row. Only valid for the CSV format.
	/// </para>
	/// </summary>
	public string? Delimiter { get => Q<string?>("delimiter"); set => Q("delimiter", value); }

	/// <summary>
	/// <para>
	/// Should columns that are entirely <c>null</c> be removed from the <c>columns</c> and <c>values</c> portion of the results?
	/// Defaults to <c>false</c>. If <c>true</c> then the response will include an extra section under the name <c>all_columns</c> which has the name of all columns.
	/// </para>
	/// </summary>
	public bool? DropNullColumns { get => Q<bool?>("drop_null_columns"); set => Q("drop_null_columns", value); }

	/// <summary>
	/// <para>
	/// A short version of the Accept header, e.g. json, yaml.
	/// </para>
	/// <para>
	/// <c>csv</c>, <c>tsv</c>, and <c>txt</c> formats will return results in a tabular format, excluding other metadata fields from the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlFormat? Format { get => Q<Elastic.Clients.Elasticsearch.Esql.EsqlFormat?>("format"); set => Q("format", value); }

	/// <summary>
	/// <para>
	/// By default, ES|QL returns results as rows. For example, FROM returns each individual document as one row. For the JSON, YAML, CBOR and smile formats, ES|QL can return the results in a columnar fashion where one row represents all the values of a certain column in the results.
	/// </para>
	/// </summary>
	public bool? Columnar { get; set; }

	/// <summary>
	/// <para>
	/// Specify a Query DSL query in the filter parameter to filter the set of documents that an ES|QL query runs on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? Filter { get; set; }

	/// <summary>
	/// <para>
	/// When set to <c>true</c> and performing a cross-cluster query, the response will include an extra <c>_clusters</c>
	/// object with information about the clusters that participated in the search along with info such as shards
	/// count.
	/// </para>
	/// </summary>
	public bool? IncludeCcsMetadata { get; set; }
	public string? Locale { get; set; }

	/// <summary>
	/// <para>
	/// To avoid any attempts of hacking or code injection, extract the values in a separate list of parameters. Use question mark placeholders (?) in the query string for each of the parameters.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>? Params { get; set; }

	/// <summary>
	/// <para>
	/// If provided and <c>true</c> the response will include an extra <c>profile</c> object
	/// with information on how the query was executed. This information is for human debugging
	/// and its format can change at any time but it can give some insight into the performance
	/// of each part of the query.
	/// </para>
	/// </summary>
	public bool? Profile { get; set; }

	/// <summary>
	/// <para>
	/// The ES|QL query API accepts an ES|QL query string in the query parameter, runs it, and returns the results.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Query { get; set; }
}

/// <summary>
/// <para>
/// Run an ES|QL query.
/// Get search results for an ES|QL (Elasticsearch query language) query.
/// </para>
/// </summary>
public readonly partial struct EsqlQueryRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EsqlQueryRequestDescriptor(Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequest instance)
	{
		Instance = instance;
	}

	public EsqlQueryRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor(Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequest instance) => new Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequest(Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If <c>true</c>, partial results will be returned if there are shard failures, but the query can continue to execute on other clusters and shards.
	/// If <c>false</c>, the query will fail if there are any failures.
	/// </para>
	/// <para>
	/// To override the default behavior, you can set the <c>esql.query.allow_partial_results</c> cluster setting to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor AllowPartialResults(bool? value = true)
	{
		Instance.AllowPartialResults = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The character to use between values within a CSV row. Only valid for the CSV format.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor Delimiter(string? value)
	{
		Instance.Delimiter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Should columns that are entirely <c>null</c> be removed from the <c>columns</c> and <c>values</c> portion of the results?
	/// Defaults to <c>false</c>. If <c>true</c> then the response will include an extra section under the name <c>all_columns</c> which has the name of all columns.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor DropNullColumns(bool? value = true)
	{
		Instance.DropNullColumns = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A short version of the Accept header, e.g. json, yaml.
	/// </para>
	/// <para>
	/// <c>csv</c>, <c>tsv</c>, and <c>txt</c> formats will return results in a tabular format, excluding other metadata fields from the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor Format(Elastic.Clients.Elasticsearch.Esql.EsqlFormat? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// By default, ES|QL returns results as rows. For example, FROM returns each individual document as one row. For the JSON, YAML, CBOR and smile formats, ES|QL can return the results in a columnar fashion where one row represents all the values of a certain column in the results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor Columnar(bool? value = true)
	{
		Instance.Columnar = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify a Query DSL query in the filter parameter to filter the set of documents that an ES|QL query runs on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor Filter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify a Query DSL query in the filter parameter to filter the set of documents that an ES|QL query runs on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor Filter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify a Query DSL query in the filter parameter to filter the set of documents that an ES|QL query runs on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor Filter<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// When set to <c>true</c> and performing a cross-cluster query, the response will include an extra <c>_clusters</c>
	/// object with information about the clusters that participated in the search along with info such as shards
	/// count.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor IncludeCcsMetadata(bool? value = true)
	{
		Instance.IncludeCcsMetadata = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor Locale(string? value)
	{
		Instance.Locale = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// To avoid any attempts of hacking or code injection, extract the values in a separate list of parameters. Use question mark placeholders (?) in the query string for each of the parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor Params(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>? value)
	{
		Instance.Params = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// To avoid any attempts of hacking or code injection, extract the values in a separate list of parameters. Use question mark placeholders (?) in the query string for each of the parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor Params(params Elastic.Clients.Elasticsearch.FieldValue[] values)
	{
		Instance.Params = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If provided and <c>true</c> the response will include an extra <c>profile</c> object
	/// with information on how the query was executed. This information is for human debugging
	/// and its format can change at any time but it can give some insight into the performance
	/// of each part of the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor Profile(bool? value = true)
	{
		Instance.Profile = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The ES|QL query API accepts an ES|QL query string in the query parameter, runs it, and returns the results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor Query(string value)
	{
		Instance.Query = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequest Build(System.Action<Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor(new Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Run an ES|QL query.
/// Get search results for an ES|QL (Elasticsearch query language) query.
/// </para>
/// </summary>
public readonly partial struct EsqlQueryRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EsqlQueryRequestDescriptor(Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequest instance)
	{
		Instance = instance;
	}

	public EsqlQueryRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequest instance) => new Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequest(Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If <c>true</c>, partial results will be returned if there are shard failures, but the query can continue to execute on other clusters and shards.
	/// If <c>false</c>, the query will fail if there are any failures.
	/// </para>
	/// <para>
	/// To override the default behavior, you can set the <c>esql.query.allow_partial_results</c> cluster setting to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> AllowPartialResults(bool? value = true)
	{
		Instance.AllowPartialResults = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The character to use between values within a CSV row. Only valid for the CSV format.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> Delimiter(string? value)
	{
		Instance.Delimiter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Should columns that are entirely <c>null</c> be removed from the <c>columns</c> and <c>values</c> portion of the results?
	/// Defaults to <c>false</c>. If <c>true</c> then the response will include an extra section under the name <c>all_columns</c> which has the name of all columns.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> DropNullColumns(bool? value = true)
	{
		Instance.DropNullColumns = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A short version of the Accept header, e.g. json, yaml.
	/// </para>
	/// <para>
	/// <c>csv</c>, <c>tsv</c>, and <c>txt</c> formats will return results in a tabular format, excluding other metadata fields from the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> Format(Elastic.Clients.Elasticsearch.Esql.EsqlFormat? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// By default, ES|QL returns results as rows. For example, FROM returns each individual document as one row. For the JSON, YAML, CBOR and smile formats, ES|QL can return the results in a columnar fashion where one row represents all the values of a certain column in the results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> Columnar(bool? value = true)
	{
		Instance.Columnar = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify a Query DSL query in the filter parameter to filter the set of documents that an ES|QL query runs on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> Filter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify a Query DSL query in the filter parameter to filter the set of documents that an ES|QL query runs on.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> Filter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// When set to <c>true</c> and performing a cross-cluster query, the response will include an extra <c>_clusters</c>
	/// object with information about the clusters that participated in the search along with info such as shards
	/// count.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> IncludeCcsMetadata(bool? value = true)
	{
		Instance.IncludeCcsMetadata = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> Locale(string? value)
	{
		Instance.Locale = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// To avoid any attempts of hacking or code injection, extract the values in a separate list of parameters. Use question mark placeholders (?) in the query string for each of the parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> Params(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>? value)
	{
		Instance.Params = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// To avoid any attempts of hacking or code injection, extract the values in a separate list of parameters. Use question mark placeholders (?) in the query string for each of the parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> Params(params Elastic.Clients.Elasticsearch.FieldValue[] values)
	{
		Instance.Params = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If provided and <c>true</c> the response will include an extra <c>profile</c> object
	/// with information on how the query was executed. This information is for human debugging
	/// and its format can change at any time but it can give some insight into the performance
	/// of each part of the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> Profile(bool? value = true)
	{
		Instance.Profile = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The ES|QL query API accepts an ES|QL query string in the query parameter, runs it, and returns the results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> Query(string value)
	{
		Instance.Query = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequest Build(System.Action<Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Esql.EsqlQueryRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}