// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Eql;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Eql.Json.EqlSearchResponseConverterFactory))]
public sealed partial class EqlSearchResponse<TEvent> : Elastic.Transport.Products.Elasticsearch.ElasticsearchResponse
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EqlSearchResponse()
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal EqlSearchResponse(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Contains matching events and sequences. Also contains related metadata.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Eql.EqlHits<TEvent> Hits { get; set; }

	/// <summary>
	/// <para>
	/// Identifier for the search.
	/// </para>
	/// </summary>
	public string? Id { get; set; }

	/// <summary>
	/// <para>
	/// If true, the response does not contain complete search results.
	/// </para>
	/// </summary>
	public bool? IsPartial { get; set; }

	/// <summary>
	/// <para>
	/// If true, the search request is still executing.
	/// </para>
	/// </summary>
	public bool? IsRunning { get; set; }

	/// <summary>
	/// <para>
	/// Contains information about shard failures (if any), in case allow_partial_search_results=true
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.ShardFailure>? ShardFailures { get; set; }

	/// <summary>
	/// <para>
	/// If true, the request timed out before completion.
	/// </para>
	/// </summary>
	public bool? TimedOut { get; set; }

	/// <summary>
	/// <para>
	/// Milliseconds it took Elasticsearch to execute the request.
	/// </para>
	/// </summary>
	public System.TimeSpan? Took { get; set; }
}