// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Eql;

public sealed partial class EqlSearchRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes <c>_all</c> string or when no indices have been specified)
	/// </para>
	/// </summary>
	public bool? AllowNoIndices { get => Q<bool?>("allow_no_indices"); set => Q("allow_no_indices", value); }

	/// <summary>
	/// <para>
	/// Indicates whether network round-trips should be minimized as part of cross-cluster search requests execution
	/// </para>
	/// </summary>
	public bool? CcsMinimizeRoundtrips { get => Q<bool?>("ccs_minimize_roundtrips"); set => Q("ccs_minimize_roundtrips", value); }

	/// <summary>
	/// <para>
	/// Whether to expand wildcard expression to concrete indices that are open, closed or both.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? ExpandWildcards { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>?>("expand_wildcards"); set => Q("expand_wildcards", value); }

	/// <summary>
	/// <para>
	/// If true, missing or closed indices are not included in the response.
	/// </para>
	/// </summary>
	public bool? IgnoreUnavailable { get => Q<bool?>("ignore_unavailable"); set => Q("ignore_unavailable", value); }
}

/// <summary>
/// <para>
/// Get EQL search results.
/// Returns search results for an Event Query Language (EQL) query.
/// EQL assumes each document in a data stream or index corresponds to an event.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Eql.Json.EqlSearchRequestConverter))]
public sealed partial class EqlSearchRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EqlSearchRequest(Elastic.Clients.Elasticsearch.Indices indices) : base(r => r.Required("index", indices))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EqlSearchRequest(Elastic.Clients.Elasticsearch.Indices indices, string query) : base(r => r.Required("index", indices))
	{
		Query = query;
	}
#if NET7_0_OR_GREATER
	public EqlSearchRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal EqlSearchRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.EqlSearch;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "eql.search";

	/// <summary>
	/// <para>
	/// The name of the index to scope the operation
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Indices Indices { get => P<Elastic.Clients.Elasticsearch.Indices>("index"); set => PR("index", value); }

	/// <summary>
	/// <para>
	/// Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes <c>_all</c> string or when no indices have been specified)
	/// </para>
	/// </summary>
	public bool? AllowNoIndices { get => Q<bool?>("allow_no_indices"); set => Q("allow_no_indices", value); }

	/// <summary>
	/// <para>
	/// Indicates whether network round-trips should be minimized as part of cross-cluster search requests execution
	/// </para>
	/// </summary>
	public bool? CcsMinimizeRoundtrips { get => Q<bool?>("ccs_minimize_roundtrips"); set => Q("ccs_minimize_roundtrips", value); }

	/// <summary>
	/// <para>
	/// Whether to expand wildcard expression to concrete indices that are open, closed or both.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? ExpandWildcards { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>?>("expand_wildcards"); set => Q("expand_wildcards", value); }

	/// <summary>
	/// <para>
	/// If true, missing or closed indices are not included in the response.
	/// </para>
	/// </summary>
	public bool? IgnoreUnavailable { get => Q<bool?>("ignore_unavailable"); set => Q("ignore_unavailable", value); }

	/// <summary>
	/// <para>
	/// Allow query execution also in case of shard failures.
	/// If true, the query will keep running and will return results based on the available shards.
	/// For sequences, the behavior can be further refined using allow_partial_sequence_results
	/// </para>
	/// </summary>
	public bool? AllowPartialSearchResults { get; set; }

	/// <summary>
	/// <para>
	/// This flag applies only to sequences and has effect only if allow_partial_search_results=true.
	/// If true, the sequence query will return results based on the available shards, ignoring the others.
	/// If false, the sequence query will return successfully, but will always have empty results.
	/// </para>
	/// </summary>
	public bool? AllowPartialSequenceResults { get; set; }
	public bool? CaseSensitive { get; set; }

	/// <summary>
	/// <para>
	/// Field containing the event classification, such as process, file, or network.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? EventCategoryField { get; set; }

	/// <summary>
	/// <para>
	/// Maximum number of events to search at a time for sequence queries.
	/// </para>
	/// </summary>
	public int? FetchSize { get; set; }

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The response returns values for field names matching these patterns in the fields property of each hit.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? Fields { get; set; }

	/// <summary>
	/// <para>
	/// Query, written in Query DSL, used to filter the events on which the EQL query runs.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? Filter { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? KeepAlive { get; set; }
	public bool? KeepOnCompletion { get; set; }

	/// <summary>
	/// <para>
	/// By default, the response of a sample query contains up to <c>10</c> samples, with one sample per unique set of join keys. Use the <c>size</c>
	/// parameter to get a smaller or larger set of samples. To retrieve more than one sample per set of join keys, use the
	/// <c>max_samples_per_key</c> parameter. Pipes are not supported for sample queries.
	/// </para>
	/// </summary>
	public int? MaxSamplesPerKey { get; set; }

	/// <summary>
	/// <para>
	/// EQL query you wish to run.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Query { get; set; }
	public Elastic.Clients.Elasticsearch.Eql.ResultPosition? ResultPosition { get; set; }
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? RuntimeMappings { get; set; }

	/// <summary>
	/// <para>
	/// For basic queries, the maximum number of matching events to return. Defaults to 10
	/// </para>
	/// </summary>
	public int? Size { get; set; }

	/// <summary>
	/// <para>
	/// Field used to sort hits with the same timestamp in ascending order
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? TiebreakerField { get; set; }

	/// <summary>
	/// <para>
	/// Field containing event timestamp. Default "@timestamp"
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? TimestampField { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? WaitForCompletionTimeout { get; set; }
}

/// <summary>
/// <para>
/// Get EQL search results.
/// Returns search results for an Event Query Language (EQL) query.
/// EQL assumes each document in a data stream or index corresponds to an event.
/// </para>
/// </summary>
public readonly partial struct EqlSearchRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Eql.EqlSearchRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EqlSearchRequestDescriptor(Elastic.Clients.Elasticsearch.Eql.EqlSearchRequest instance)
	{
		Instance = instance;
	}

	public EqlSearchRequestDescriptor(Elastic.Clients.Elasticsearch.Indices indices)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Eql.EqlSearchRequest(indices);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public EqlSearchRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor(Elastic.Clients.Elasticsearch.Eql.EqlSearchRequest instance) => new Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Eql.EqlSearchRequest(Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the index to scope the operation
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor Indices(Elastic.Clients.Elasticsearch.Indices value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes <c>_all</c> string or when no indices have been specified)
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor AllowNoIndices(bool? value = true)
	{
		Instance.AllowNoIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether network round-trips should be minimized as part of cross-cluster search requests execution
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor CcsMinimizeRoundtrips(bool? value = true)
	{
		Instance.CcsMinimizeRoundtrips = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to expand wildcard expression to concrete indices that are open, closed or both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor ExpandWildcards(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? value)
	{
		Instance.ExpandWildcards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to expand wildcard expression to concrete indices that are open, closed or both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor ExpandWildcards(params Elastic.Clients.Elasticsearch.ExpandWildcard[] values)
	{
		Instance.ExpandWildcards = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, missing or closed indices are not included in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor IgnoreUnavailable(bool? value = true)
	{
		Instance.IgnoreUnavailable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Allow query execution also in case of shard failures.
	/// If true, the query will keep running and will return results based on the available shards.
	/// For sequences, the behavior can be further refined using allow_partial_sequence_results
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor AllowPartialSearchResults(bool? value = true)
	{
		Instance.AllowPartialSearchResults = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This flag applies only to sequences and has effect only if allow_partial_search_results=true.
	/// If true, the sequence query will return results based on the available shards, ignoring the others.
	/// If false, the sequence query will return successfully, but will always have empty results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor AllowPartialSequenceResults(bool? value = true)
	{
		Instance.AllowPartialSequenceResults = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor CaseSensitive(bool? value = true)
	{
		Instance.CaseSensitive = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field containing the event classification, such as process, file, or network.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor EventCategoryField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.EventCategoryField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field containing the event classification, such as process, file, or network.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor EventCategoryField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.EventCategoryField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of events to search at a time for sequence queries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor FetchSize(int? value)
	{
		Instance.FetchSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The response returns values for field names matching these patterns in the fields property of each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor Fields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The response returns values for field names matching these patterns in the fields property of each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor Fields(params Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat[] values)
	{
		Instance.Fields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The response returns values for field names matching these patterns in the fields property of each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor Fields(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor.Build(action));
		}

		Instance.Fields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The response returns values for field names matching these patterns in the fields property of each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor Fields<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<T>.Build(action));
		}

		Instance.Fields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query, written in Query DSL, used to filter the events on which the EQL query runs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query, written in Query DSL, used to filter the events on which the EQL query runs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor Filter(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Query, written in Query DSL, used to filter the events on which the EQL query runs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor Filter(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query, written in Query DSL, used to filter the events on which the EQL query runs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor Filter<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor KeepAlive(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.KeepAlive = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor KeepOnCompletion(bool? value = true)
	{
		Instance.KeepOnCompletion = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// By default, the response of a sample query contains up to <c>10</c> samples, with one sample per unique set of join keys. Use the <c>size</c>
	/// parameter to get a smaller or larger set of samples. To retrieve more than one sample per set of join keys, use the
	/// <c>max_samples_per_key</c> parameter. Pipes are not supported for sample queries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor MaxSamplesPerKey(int? value)
	{
		Instance.MaxSamplesPerKey = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// EQL query you wish to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor Query(string value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor ResultPosition(Elastic.Clients.Elasticsearch.Eql.ResultPosition? value)
	{
		Instance.ResultPosition = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor RuntimeMappings(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.RuntimeMappings = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor RuntimeMappings()
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor RuntimeMappings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor RuntimeMappings<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor AddRuntimeMapping<T>(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// For basic queries, the maximum number of matching events to return. Defaults to 10
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field used to sort hits with the same timestamp in ascending order
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor TiebreakerField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TiebreakerField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field used to sort hits with the same timestamp in ascending order
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor TiebreakerField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.TiebreakerField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field containing event timestamp. Default "@timestamp"
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor TimestampField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TimestampField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field containing event timestamp. Default "@timestamp"
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor TimestampField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.TimestampField = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor WaitForCompletionTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.WaitForCompletionTimeout = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Eql.EqlSearchRequest Build(System.Action<Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor(new Elastic.Clients.Elasticsearch.Eql.EqlSearchRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Get EQL search results.
/// Returns search results for an Event Query Language (EQL) query.
/// EQL assumes each document in a data stream or index corresponds to an event.
/// </para>
/// </summary>
public readonly partial struct EqlSearchRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Eql.EqlSearchRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EqlSearchRequestDescriptor(Elastic.Clients.Elasticsearch.Eql.EqlSearchRequest instance)
	{
		Instance = instance;
	}

	public EqlSearchRequestDescriptor(Elastic.Clients.Elasticsearch.Indices indices)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Eql.EqlSearchRequest(indices);
#pragma warning restore CS0618
	}

	public EqlSearchRequestDescriptor()
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Eql.EqlSearchRequest(typeof(TDocument));
#pragma warning restore CS0618
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Eql.EqlSearchRequest instance) => new Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Eql.EqlSearchRequest(Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the index to scope the operation
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> Indices(Elastic.Clients.Elasticsearch.Indices value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes <c>_all</c> string or when no indices have been specified)
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> AllowNoIndices(bool? value = true)
	{
		Instance.AllowNoIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether network round-trips should be minimized as part of cross-cluster search requests execution
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> CcsMinimizeRoundtrips(bool? value = true)
	{
		Instance.CcsMinimizeRoundtrips = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to expand wildcard expression to concrete indices that are open, closed or both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> ExpandWildcards(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? value)
	{
		Instance.ExpandWildcards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to expand wildcard expression to concrete indices that are open, closed or both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> ExpandWildcards(params Elastic.Clients.Elasticsearch.ExpandWildcard[] values)
	{
		Instance.ExpandWildcards = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, missing or closed indices are not included in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> IgnoreUnavailable(bool? value = true)
	{
		Instance.IgnoreUnavailable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Allow query execution also in case of shard failures.
	/// If true, the query will keep running and will return results based on the available shards.
	/// For sequences, the behavior can be further refined using allow_partial_sequence_results
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> AllowPartialSearchResults(bool? value = true)
	{
		Instance.AllowPartialSearchResults = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// This flag applies only to sequences and has effect only if allow_partial_search_results=true.
	/// If true, the sequence query will return results based on the available shards, ignoring the others.
	/// If false, the sequence query will return successfully, but will always have empty results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> AllowPartialSequenceResults(bool? value = true)
	{
		Instance.AllowPartialSequenceResults = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> CaseSensitive(bool? value = true)
	{
		Instance.CaseSensitive = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field containing the event classification, such as process, file, or network.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> EventCategoryField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.EventCategoryField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field containing the event classification, such as process, file, or network.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> EventCategoryField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.EventCategoryField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of events to search at a time for sequence queries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> FetchSize(int? value)
	{
		Instance.FetchSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The response returns values for field names matching these patterns in the fields property of each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> Fields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The response returns values for field names matching these patterns in the fields property of each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> Fields(params Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat[] values)
	{
		Instance.Fields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The response returns values for field names matching these patterns in the fields property of each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> Fields(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>.Build(action));
		}

		Instance.Fields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query, written in Query DSL, used to filter the events on which the EQL query runs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> Filter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.Query>? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query, written in Query DSL, used to filter the events on which the EQL query runs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> Filter(params Elastic.Clients.Elasticsearch.QueryDsl.Query[] values)
	{
		Instance.Filter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Query, written in Query DSL, used to filter the events on which the EQL query runs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> Filter(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.Query>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action));
		}

		Instance.Filter = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> KeepAlive(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.KeepAlive = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> KeepOnCompletion(bool? value = true)
	{
		Instance.KeepOnCompletion = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// By default, the response of a sample query contains up to <c>10</c> samples, with one sample per unique set of join keys. Use the <c>size</c>
	/// parameter to get a smaller or larger set of samples. To retrieve more than one sample per set of join keys, use the
	/// <c>max_samples_per_key</c> parameter. Pipes are not supported for sample queries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> MaxSamplesPerKey(int? value)
	{
		Instance.MaxSamplesPerKey = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// EQL query you wish to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> Query(string value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> ResultPosition(Elastic.Clients.Elasticsearch.Eql.ResultPosition? value)
	{
		Instance.ResultPosition = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> RuntimeMappings(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.RuntimeMappings = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> RuntimeMappings()
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> RuntimeMappings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> AddRuntimeMapping(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> AddRuntimeMapping(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// For basic queries, the maximum number of matching events to return. Defaults to 10
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field used to sort hits with the same timestamp in ascending order
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> TiebreakerField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TiebreakerField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field used to sort hits with the same timestamp in ascending order
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> TiebreakerField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.TiebreakerField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field containing event timestamp. Default "@timestamp"
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> TimestampField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.TimestampField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Field containing event timestamp. Default "@timestamp"
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> TimestampField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.TimestampField = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> WaitForCompletionTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.WaitForCompletionTimeout = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Eql.EqlSearchRequest Build(System.Action<Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Eql.EqlSearchRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Eql.EqlSearchRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}