// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Enrich;

public sealed partial class PutPolicyRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }
}

/// <summary>
/// <para>
/// Create an enrich policy.
/// Creates an enrich policy.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Enrich.Json.PutPolicyRequestConverter))]
public sealed partial class PutPolicyRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutPolicyRequest(Elastic.Clients.Elasticsearch.Name name) : base(r => r.Required("name", name))
	{
	}
#if NET7_0_OR_GREATER
	public PutPolicyRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutPolicyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.EnrichPutPolicy;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "enrich.put_policy";

	/// <summary>
	/// <para>
	/// Name of the enrich policy to create or update.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name Name { get => P<Elastic.Clients.Elasticsearch.Name>("name"); set => PR("name", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// Matches enrich data to incoming documents based on a <c>geo_shape</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy? GeoMatch { get; set; }

	/// <summary>
	/// <para>
	/// Matches enrich data to incoming documents based on a <c>term</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy? Match { get; set; }

	/// <summary>
	/// <para>
	/// Matches a number, date, or IP address in incoming documents to a range in the enrich index based on a <c>term</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy? Range { get; set; }
}

/// <summary>
/// <para>
/// Create an enrich policy.
/// Creates an enrich policy.
/// </para>
/// </summary>
public readonly partial struct PutPolicyRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutPolicyRequestDescriptor(Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequest instance)
	{
		Instance = instance;
	}

	public PutPolicyRequestDescriptor(Elastic.Clients.Elasticsearch.Name name)
	{
		Instance = new Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequest(name);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutPolicyRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor(Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequest instance) => new Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequest(Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Name of the enrich policy to create or update.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches enrich data to incoming documents based on a <c>geo_shape</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor GeoMatch(Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy? value)
	{
		Instance.GeoMatch = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches enrich data to incoming documents based on a <c>geo_shape</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor GeoMatch(System.Action<Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor> action)
	{
		Instance.GeoMatch = Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches enrich data to incoming documents based on a <c>geo_shape</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor GeoMatch<T>(System.Action<Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<T>> action)
	{
		Instance.GeoMatch = Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches enrich data to incoming documents based on a <c>term</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor Match(Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy? value)
	{
		Instance.Match = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches enrich data to incoming documents based on a <c>term</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor Match(System.Action<Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor> action)
	{
		Instance.Match = Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches enrich data to incoming documents based on a <c>term</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor Match<T>(System.Action<Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<T>> action)
	{
		Instance.Match = Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches a number, date, or IP address in incoming documents to a range in the enrich index based on a <c>term</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor Range(Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy? value)
	{
		Instance.Range = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches a number, date, or IP address in incoming documents to a range in the enrich index based on a <c>term</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor Range(System.Action<Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor> action)
	{
		Instance.Range = Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches a number, date, or IP address in incoming documents to a range in the enrich index based on a <c>term</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor Range<T>(System.Action<Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<T>> action)
	{
		Instance.Range = Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequest Build(System.Action<Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor(new Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Create an enrich policy.
/// Creates an enrich policy.
/// </para>
/// </summary>
public readonly partial struct PutPolicyRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutPolicyRequestDescriptor(Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequest instance)
	{
		Instance = instance;
	}

	public PutPolicyRequestDescriptor(Elastic.Clients.Elasticsearch.Name name)
	{
		Instance = new Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequest(name);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutPolicyRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequest instance) => new Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequest(Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Name of the enrich policy to create or update.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument> Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument> MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches enrich data to incoming documents based on a <c>geo_shape</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument> GeoMatch(Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy? value)
	{
		Instance.GeoMatch = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches enrich data to incoming documents based on a <c>geo_shape</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument> GeoMatch(System.Action<Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument>> action)
	{
		Instance.GeoMatch = Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches enrich data to incoming documents based on a <c>term</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument> Match(Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy? value)
	{
		Instance.Match = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches enrich data to incoming documents based on a <c>term</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument> Match(System.Action<Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument>> action)
	{
		Instance.Match = Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches a number, date, or IP address in incoming documents to a range in the enrich index based on a <c>term</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument> Range(Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy? value)
	{
		Instance.Range = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Matches a number, date, or IP address in incoming documents to a range in the enrich index based on a <c>term</c> query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument> Range(System.Action<Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument>> action)
	{
		Instance.Range = Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequest Build(System.Action<Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.PutPolicyRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}