// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.DanglingIndices;

public sealed partial class ListDanglingIndicesRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Get the dangling indices.
/// </para>
/// <para>
/// If Elasticsearch encounters index data that is absent from the current cluster state, those indices are considered to be dangling.
/// For example, this can happen if you delete more than <c>cluster.indices.tombstones.size</c> indices while an Elasticsearch node is offline.
/// </para>
/// <para>
/// Use this API to list dangling indices, which you can then import or delete.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.DanglingIndices.Json.ListDanglingIndicesRequestConverter))]
public sealed partial class ListDanglingIndicesRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequestParameters>
{
#if NET7_0_OR_GREATER
	public ListDanglingIndicesRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ListDanglingIndicesRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ListDanglingIndicesRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.DanglingIndicesListDanglingIndices;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "dangling_indices.list_dangling_indices";
}

/// <summary>
/// <para>
/// Get the dangling indices.
/// </para>
/// <para>
/// If Elasticsearch encounters index data that is absent from the current cluster state, those indices are considered to be dangling.
/// For example, this can happen if you delete more than <c>cluster.indices.tombstones.size</c> indices while an Elasticsearch node is offline.
/// </para>
/// <para>
/// Use this API to list dangling indices, which you can then import or delete.
/// </para>
/// </summary>
public readonly partial struct ListDanglingIndicesRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ListDanglingIndicesRequestDescriptor(Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequest instance)
	{
		Instance = instance;
	}

	public ListDanglingIndicesRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequestDescriptor(Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequest instance) => new Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequest(Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequestDescriptor descriptor) => descriptor.Instance;

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequest Build(System.Action<Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequestDescriptor(new Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.DanglingIndices.ListDanglingIndicesRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}