// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.CrossClusterReplication;

public sealed partial class PutAutoFollowPatternRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }
}

/// <summary>
/// <para>
/// Create or update auto-follow patterns.
/// Create a collection of cross-cluster replication auto-follow patterns for a remote cluster.
/// Newly created indices on the remote cluster that match any of the patterns are automatically configured as follower indices.
/// Indices on the remote cluster that were created before the auto-follow pattern was created will not be auto-followed even if they match the pattern.
/// </para>
/// <para>
/// This API can also be used to update auto-follow patterns.
/// NOTE: Follower indices that were configured automatically before updating an auto-follow pattern will remain unchanged even if they do not match against the new patterns.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.CrossClusterReplication.Json.PutAutoFollowPatternRequestConverter))]
public sealed partial class PutAutoFollowPatternRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutAutoFollowPatternRequest(Elastic.Clients.Elasticsearch.Name name) : base(r => r.Required("name", name))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutAutoFollowPatternRequest(Elastic.Clients.Elasticsearch.Name name, string remoteCluster) : base(r => r.Required("name", name))
	{
		RemoteCluster = remoteCluster;
	}
#if NET7_0_OR_GREATER
	public PutAutoFollowPatternRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutAutoFollowPatternRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.CrossClusterReplicationPutAutoFollowPattern;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ccr.put_auto_follow_pattern";

	/// <summary>
	/// <para>
	/// The name of the collection of auto-follow patterns.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name Name { get => P<Elastic.Clients.Elasticsearch.Name>("name"); set => PR("name", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// The name of follower index. The template {{leader_index}} can be used to derive the name of the follower index from the name of the leader index. When following a data stream, use {{leader_index}}; CCR does not support changes to the names of a follower data stream’s backing indices.
	/// </para>
	/// </summary>
	public string? FollowIndexPattern { get; set; }

	/// <summary>
	/// <para>
	/// An array of simple index patterns that can be used to exclude indices from being auto-followed. Indices in the remote cluster whose names are matching one or more leader_index_patterns and one or more leader_index_exclusion_patterns won’t be followed.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? LeaderIndexExclusionPatterns { get; set; }

	/// <summary>
	/// <para>
	/// An array of simple index patterns to match against indices in the remote cluster specified by the remote_cluster field.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? LeaderIndexPatterns { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of outstanding reads requests from the remote cluster.
	/// </para>
	/// </summary>
	public int? MaxOutstandingReadRequests { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of outstanding reads requests from the remote cluster.
	/// </para>
	/// </summary>
	public int? MaxOutstandingWriteRequests { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of operations to pull per read from the remote cluster.
	/// </para>
	/// </summary>
	public int? MaxReadRequestOperationCount { get; set; }

	/// <summary>
	/// <para>
	/// The maximum size in bytes of per read of a batch of operations pulled from the remote cluster.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? MaxReadRequestSize { get; set; }

	/// <summary>
	/// <para>
	/// The maximum time to wait before retrying an operation that failed exceptionally. An exponential backoff strategy is employed when retrying.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MaxRetryDelay { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of operations that can be queued for writing. When this limit is reached, reads from the remote cluster will be deferred until the number of queued operations goes below the limit.
	/// </para>
	/// </summary>
	public int? MaxWriteBufferCount { get; set; }

	/// <summary>
	/// <para>
	/// The maximum total bytes of operations that can be queued for writing. When this limit is reached, reads from the remote cluster will be deferred until the total bytes of queued operations goes below the limit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? MaxWriteBufferSize { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of operations per bulk write request executed on the follower.
	/// </para>
	/// </summary>
	public int? MaxWriteRequestOperationCount { get; set; }

	/// <summary>
	/// <para>
	/// The maximum total bytes of operations per bulk write request executed on the follower.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? MaxWriteRequestSize { get; set; }

	/// <summary>
	/// <para>
	/// The maximum time to wait for new operations on the remote cluster when the follower index is synchronized with the leader index. When the timeout has elapsed, the poll for operations will return to the follower so that it can update some statistics. Then the follower will immediately attempt to read from the leader again.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? ReadPollTimeout { get; set; }

	/// <summary>
	/// <para>
	/// The remote cluster containing the leader indices to match against.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string RemoteCluster { get; set; }

	/// <summary>
	/// <para>
	/// Settings to override from the leader index. Note that certain settings can not be overrode (e.g., index.number_of_shards).
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Settings { get; set; }
}

/// <summary>
/// <para>
/// Create or update auto-follow patterns.
/// Create a collection of cross-cluster replication auto-follow patterns for a remote cluster.
/// Newly created indices on the remote cluster that match any of the patterns are automatically configured as follower indices.
/// Indices on the remote cluster that were created before the auto-follow pattern was created will not be auto-followed even if they match the pattern.
/// </para>
/// <para>
/// This API can also be used to update auto-follow patterns.
/// NOTE: Follower indices that were configured automatically before updating an auto-follow pattern will remain unchanged even if they do not match against the new patterns.
/// </para>
/// </summary>
public readonly partial struct PutAutoFollowPatternRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutAutoFollowPatternRequestDescriptor(Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequest instance)
	{
		Instance = instance;
	}

	public PutAutoFollowPatternRequestDescriptor(Elastic.Clients.Elasticsearch.Name name)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequest(name);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutAutoFollowPatternRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor(Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequest instance) => new Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequest(Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the collection of auto-follow patterns.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of follower index. The template {{leader_index}} can be used to derive the name of the follower index from the name of the leader index. When following a data stream, use {{leader_index}}; CCR does not support changes to the names of a follower data stream’s backing indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor FollowIndexPattern(string? value)
	{
		Instance.FollowIndexPattern = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of simple index patterns that can be used to exclude indices from being auto-followed. Indices in the remote cluster whose names are matching one or more leader_index_patterns and one or more leader_index_exclusion_patterns won’t be followed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor LeaderIndexExclusionPatterns(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.LeaderIndexExclusionPatterns = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of simple index patterns that can be used to exclude indices from being auto-followed. Indices in the remote cluster whose names are matching one or more leader_index_patterns and one or more leader_index_exclusion_patterns won’t be followed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor LeaderIndexExclusionPatterns(params string[] values)
	{
		Instance.LeaderIndexExclusionPatterns = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of simple index patterns to match against indices in the remote cluster specified by the remote_cluster field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor LeaderIndexPatterns(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.LeaderIndexPatterns = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of simple index patterns to match against indices in the remote cluster specified by the remote_cluster field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor LeaderIndexPatterns(params string[] values)
	{
		Instance.LeaderIndexPatterns = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of outstanding reads requests from the remote cluster.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor MaxOutstandingReadRequests(int? value)
	{
		Instance.MaxOutstandingReadRequests = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of outstanding reads requests from the remote cluster.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor MaxOutstandingWriteRequests(int? value)
	{
		Instance.MaxOutstandingWriteRequests = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of operations to pull per read from the remote cluster.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor MaxReadRequestOperationCount(int? value)
	{
		Instance.MaxReadRequestOperationCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum size in bytes of per read of a batch of operations pulled from the remote cluster.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor MaxReadRequestSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MaxReadRequestSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum size in bytes of per read of a batch of operations pulled from the remote cluster.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor MaxReadRequestSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MaxReadRequestSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum time to wait before retrying an operation that failed exceptionally. An exponential backoff strategy is employed when retrying.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor MaxRetryDelay(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MaxRetryDelay = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of operations that can be queued for writing. When this limit is reached, reads from the remote cluster will be deferred until the number of queued operations goes below the limit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor MaxWriteBufferCount(int? value)
	{
		Instance.MaxWriteBufferCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum total bytes of operations that can be queued for writing. When this limit is reached, reads from the remote cluster will be deferred until the total bytes of queued operations goes below the limit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor MaxWriteBufferSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MaxWriteBufferSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum total bytes of operations that can be queued for writing. When this limit is reached, reads from the remote cluster will be deferred until the total bytes of queued operations goes below the limit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor MaxWriteBufferSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MaxWriteBufferSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of operations per bulk write request executed on the follower.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor MaxWriteRequestOperationCount(int? value)
	{
		Instance.MaxWriteRequestOperationCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum total bytes of operations per bulk write request executed on the follower.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor MaxWriteRequestSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MaxWriteRequestSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum total bytes of operations per bulk write request executed on the follower.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor MaxWriteRequestSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MaxWriteRequestSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum time to wait for new operations on the remote cluster when the follower index is synchronized with the leader index. When the timeout has elapsed, the poll for operations will return to the follower so that it can update some statistics. Then the follower will immediately attempt to read from the leader again.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor ReadPollTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.ReadPollTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The remote cluster containing the leader indices to match against.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor RemoteCluster(string value)
	{
		Instance.RemoteCluster = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to override from the leader index. Note that certain settings can not be overrode (e.g., index.number_of_shards).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor Settings(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Settings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to override from the leader index. Note that certain settings can not be overrode (e.g., index.number_of_shards).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor Settings()
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to override from the leader index. Note that certain settings can not be overrode (e.g., index.number_of_shards).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor Settings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor AddSetting(string key, object value)
	{
		Instance.Settings ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Settings.Add(key, value);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequest Build(System.Action<Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor(new Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.PutAutoFollowPatternRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}