// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.CrossClusterReplication;

public sealed partial class ForgetFollowerRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Forget a follower.
/// Remove the cross-cluster replication follower retention leases from the leader.
/// </para>
/// <para>
/// A following index takes out retention leases on its leader index.
/// These leases are used to increase the likelihood that the shards of the leader index retain the history of operations that the shards of the following index need to run replication.
/// When a follower index is converted to a regular index by the unfollow API (either by directly calling the API or by index lifecycle management tasks), these leases are removed.
/// However, removal of the leases can fail, for example when the remote cluster containing the leader index is unavailable.
/// While the leases will eventually expire on their own, their extended existence can cause the leader index to hold more history than necessary and prevent index lifecycle management from performing some operations on the leader index.
/// This API exists to enable manually removing the leases when the unfollow API is unable to do so.
/// </para>
/// <para>
/// NOTE: This API does not stop replication by a following index. If you use this API with a follower index that is still actively following, the following index will add back retention leases on the leader.
/// The only purpose of this API is to handle the case of failure to remove the following retention leases after the unfollow API is invoked.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.CrossClusterReplication.Json.ForgetFollowerRequestConverter))]
public sealed partial class ForgetFollowerRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ForgetFollowerRequest(Elastic.Clients.Elasticsearch.IndexName index) : base(r => r.Required("index", index))
	{
	}
#if NET7_0_OR_GREATER
	public ForgetFollowerRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ForgetFollowerRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.CrossClusterReplicationForgetFollower;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "ccr.forget_follower";

	/// <summary>
	/// <para>
	/// the name of the leader index for which specified follower retention leases should be removed
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexName Index { get => P<Elastic.Clients.Elasticsearch.IndexName>("index"); set => PR("index", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
	public string? FollowerCluster { get; set; }
	public Elastic.Clients.Elasticsearch.IndexName? FollowerIndex { get; set; }
	public string? FollowerIndexUuid { get; set; }
	public string? LeaderRemoteCluster { get; set; }
}

/// <summary>
/// <para>
/// Forget a follower.
/// Remove the cross-cluster replication follower retention leases from the leader.
/// </para>
/// <para>
/// A following index takes out retention leases on its leader index.
/// These leases are used to increase the likelihood that the shards of the leader index retain the history of operations that the shards of the following index need to run replication.
/// When a follower index is converted to a regular index by the unfollow API (either by directly calling the API or by index lifecycle management tasks), these leases are removed.
/// However, removal of the leases can fail, for example when the remote cluster containing the leader index is unavailable.
/// While the leases will eventually expire on their own, their extended existence can cause the leader index to hold more history than necessary and prevent index lifecycle management from performing some operations on the leader index.
/// This API exists to enable manually removing the leases when the unfollow API is unable to do so.
/// </para>
/// <para>
/// NOTE: This API does not stop replication by a following index. If you use this API with a follower index that is still actively following, the following index will add back retention leases on the leader.
/// The only purpose of this API is to handle the case of failure to remove the following retention leases after the unfollow API is invoked.
/// </para>
/// </summary>
public readonly partial struct ForgetFollowerRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ForgetFollowerRequestDescriptor(Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequest instance)
	{
		Instance = instance;
	}

	public ForgetFollowerRequestDescriptor(Elastic.Clients.Elasticsearch.IndexName index)
	{
		Instance = new Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequest(index);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public ForgetFollowerRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor(Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequest instance) => new Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequest(Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// the name of the leader index for which specified follower retention leases should be removed
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor Index(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor FollowerCluster(string? value)
	{
		Instance.FollowerCluster = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor FollowerIndex(Elastic.Clients.Elasticsearch.IndexName? value)
	{
		Instance.FollowerIndex = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor FollowerIndexUuid(string? value)
	{
		Instance.FollowerIndexUuid = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor LeaderRemoteCluster(string? value)
	{
		Instance.LeaderRemoteCluster = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequest Build(System.Action<Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor(new Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Forget a follower.
/// Remove the cross-cluster replication follower retention leases from the leader.
/// </para>
/// <para>
/// A following index takes out retention leases on its leader index.
/// These leases are used to increase the likelihood that the shards of the leader index retain the history of operations that the shards of the following index need to run replication.
/// When a follower index is converted to a regular index by the unfollow API (either by directly calling the API or by index lifecycle management tasks), these leases are removed.
/// However, removal of the leases can fail, for example when the remote cluster containing the leader index is unavailable.
/// While the leases will eventually expire on their own, their extended existence can cause the leader index to hold more history than necessary and prevent index lifecycle management from performing some operations on the leader index.
/// This API exists to enable manually removing the leases when the unfollow API is unable to do so.
/// </para>
/// <para>
/// NOTE: This API does not stop replication by a following index. If you use this API with a follower index that is still actively following, the following index will add back retention leases on the leader.
/// The only purpose of this API is to handle the case of failure to remove the following retention leases after the unfollow API is invoked.
/// </para>
/// </summary>
public readonly partial struct ForgetFollowerRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ForgetFollowerRequestDescriptor(Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequest instance)
	{
		Instance = instance;
	}

	public ForgetFollowerRequestDescriptor(Elastic.Clients.Elasticsearch.IndexName index)
	{
		Instance = new Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequest(index);
	}

	public ForgetFollowerRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequest(typeof(TDocument));
	}

	public static explicit operator Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequest instance) => new Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequest(Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// the name of the leader index for which specified follower retention leases should be removed
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor<TDocument> Index(Elastic.Clients.Elasticsearch.IndexName value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor<TDocument> Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor<TDocument> FollowerCluster(string? value)
	{
		Instance.FollowerCluster = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor<TDocument> FollowerIndex(Elastic.Clients.Elasticsearch.IndexName? value)
	{
		Instance.FollowerIndex = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor<TDocument> FollowerIndexUuid(string? value)
	{
		Instance.FollowerIndexUuid = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor<TDocument> LeaderRemoteCluster(string? value)
	{
		Instance.LeaderRemoteCluster = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequest Build(System.Action<Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}