// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.CrossClusterReplication.Json;

public sealed partial class ForgetFollowerRequestConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequest>
{
	private static readonly System.Text.Json.JsonEncodedText PropFollowerCluster = System.Text.Json.JsonEncodedText.Encode("follower_cluster");
	private static readonly System.Text.Json.JsonEncodedText PropFollowerIndex = System.Text.Json.JsonEncodedText.Encode("follower_index");
	private static readonly System.Text.Json.JsonEncodedText PropFollowerIndexUuid = System.Text.Json.JsonEncodedText.Encode("follower_index_uuid");
	private static readonly System.Text.Json.JsonEncodedText PropLeaderRemoteCluster = System.Text.Json.JsonEncodedText.Encode("leader_remote_cluster");

	public override Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequest Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propFollowerCluster = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexName?> propFollowerIndex = default;
		LocalJsonValue<string?> propFollowerIndexUuid = default;
		LocalJsonValue<string?> propLeaderRemoteCluster = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propFollowerCluster.TryReadProperty(ref reader, options, PropFollowerCluster, null))
			{
				continue;
			}

			if (propFollowerIndex.TryReadProperty(ref reader, options, PropFollowerIndex, null))
			{
				continue;
			}

			if (propFollowerIndexUuid.TryReadProperty(ref reader, options, PropFollowerIndexUuid, null))
			{
				continue;
			}

			if (propLeaderRemoteCluster.TryReadProperty(ref reader, options, PropLeaderRemoteCluster, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			FollowerCluster = propFollowerCluster.Value,
			FollowerIndex = propFollowerIndex.Value,
			FollowerIndexUuid = propFollowerIndexUuid.Value,
			LeaderRemoteCluster = propLeaderRemoteCluster.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.CrossClusterReplication.ForgetFollowerRequest value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropFollowerCluster, value.FollowerCluster, null, null);
		writer.WriteProperty(options, PropFollowerIndex, value.FollowerIndex, null, null);
		writer.WriteProperty(options, PropFollowerIndexUuid, value.FollowerIndexUuid, null, null);
		writer.WriteProperty(options, PropLeaderRemoteCluster, value.LeaderRemoteCluster, null, null);
		writer.WriteEndObject();
	}
}