// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.CrossClusterReplication.Json;

public sealed partial class FollowResponseConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.CrossClusterReplication.FollowResponse>
{
	private static readonly System.Text.Json.JsonEncodedText PropFollowIndexCreated = System.Text.Json.JsonEncodedText.Encode("follow_index_created");
	private static readonly System.Text.Json.JsonEncodedText PropFollowIndexShardsAcked = System.Text.Json.JsonEncodedText.Encode("follow_index_shards_acked");
	private static readonly System.Text.Json.JsonEncodedText PropIndexFollowingStarted = System.Text.Json.JsonEncodedText.Encode("index_following_started");

	public override Elastic.Clients.Elasticsearch.CrossClusterReplication.FollowResponse Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<bool> propFollowIndexCreated = default;
		LocalJsonValue<bool> propFollowIndexShardsAcked = default;
		LocalJsonValue<bool> propIndexFollowingStarted = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propFollowIndexCreated.TryReadProperty(ref reader, options, PropFollowIndexCreated, null))
			{
				continue;
			}

			if (propFollowIndexShardsAcked.TryReadProperty(ref reader, options, PropFollowIndexShardsAcked, null))
			{
				continue;
			}

			if (propIndexFollowingStarted.TryReadProperty(ref reader, options, PropIndexFollowingStarted, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.CrossClusterReplication.FollowResponse(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			FollowIndexCreated = propFollowIndexCreated.Value,
			FollowIndexShardsAcked = propFollowIndexShardsAcked.Value,
			IndexFollowingStarted = propIndexFollowingStarted.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.CrossClusterReplication.FollowResponse value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropFollowIndexCreated, value.FollowIndexCreated, null, null);
		writer.WriteProperty(options, PropFollowIndexShardsAcked, value.FollowIndexShardsAcked, null, null);
		writer.WriteProperty(options, PropIndexFollowingStarted, value.IndexFollowingStarted, null, null);
		writer.WriteEndObject();
	}
}