// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.HealthResponseConverter))]
public sealed partial class HealthResponse : Elastic.Transport.Products.Elasticsearch.ElasticsearchResponse
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HealthResponse()
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal HealthResponse(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The number of active primary shards.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int ActivePrimaryShards { get; set; }

	/// <summary>
	/// <para>
	/// The total number of active primary and replica shards.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int ActiveShards { get; set; }

	/// <summary>
	/// <para>
	/// The ratio of active shards in the cluster expressed as a string formatted percentage.
	/// </para>
	/// </summary>
	public string? ActiveShardsPercent { get; set; }

	/// <summary>
	/// <para>
	/// The ratio of active shards in the cluster expressed as a percentage.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	double ActiveShardsPercentAsNumber { get; set; }

	/// <summary>
	/// <para>
	/// The name of the cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ClusterName { get; set; }

	/// <summary>
	/// <para>
	/// The number of shards whose allocation has been delayed by the timeout settings.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int DelayedUnassignedShards { get; set; }
	public System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Cluster.IndexHealthStats>? Indices { get; set; }

	/// <summary>
	/// <para>
	/// The number of shards that are under initialization.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int InitializingShards { get; set; }

	/// <summary>
	/// <para>
	/// The number of nodes that are dedicated data nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int NumberOfDataNodes { get; set; }

	/// <summary>
	/// <para>
	/// The number of unfinished fetches.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int NumberOfInFlightFetch { get; set; }

	/// <summary>
	/// <para>
	/// The number of nodes within the cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int NumberOfNodes { get; set; }

	/// <summary>
	/// <para>
	/// The number of cluster-level changes that have not yet been executed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int NumberOfPendingTasks { get; set; }

	/// <summary>
	/// <para>
	/// The number of shards that are under relocation.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int RelocatingShards { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.HealthStatus Status { get; set; }

	/// <summary>
	/// <para>
	/// The time since the earliest initiated task is waiting for being performed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? TaskMaxWaitingInQueue { get; set; }

	/// <summary>
	/// <para>
	/// The time expressed in milliseconds since the earliest initiated task is waiting for being performed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan TaskMaxWaitingInQueueMillis { get; set; }

	/// <summary>
	/// <para>
	/// If false the response returned within the period of time that is specified by the timeout parameter (30s by default)
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool TimedOut { get; set; }

	/// <summary>
	/// <para>
	/// The number of primary shards that are not allocated.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int UnassignedPrimaryShards { get; set; }

	/// <summary>
	/// <para>
	/// The number of shards that are not allocated.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int UnassignedShards { get; set; }
}