// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

public sealed partial class GetComponentTemplateRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If <c>true</c>, returns settings in flat format.
	/// </para>
	/// </summary>
	public bool? FlatSettings { get => Q<bool?>("flat_settings"); set => Q("flat_settings", value); }

	/// <summary>
	/// <para>
	/// Return all default configurations for the component template (default: false)
	/// </para>
	/// </summary>
	public bool? IncludeDefaults { get => Q<bool?>("include_defaults"); set => Q("include_defaults", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request retrieves information from the local node only.
	/// If <c>false</c>, information is retrieved from the master node.
	/// </para>
	/// </summary>
	public bool? Local { get => Q<bool?>("local"); set => Q("local", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// Filter out results, for example to filter out sensitive information. Supports wildcards or full settings keys
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? SettingsFilter { get => Q<System.Collections.Generic.ICollection<string>?>("settings_filter"); set => Q("settings_filter", value); }
}

/// <summary>
/// <para>
/// Get component templates.
/// Get information about component templates.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.GetComponentTemplateRequestConverter))]
public sealed partial class GetComponentTemplateRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestParameters>
{
	public GetComponentTemplateRequest(Elastic.Clients.Elasticsearch.Name? name) : base(r => r.Optional("name", name))
	{
	}
#if NET7_0_OR_GREATER
	public GetComponentTemplateRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public GetComponentTemplateRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetComponentTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.ClusterGetComponentTemplate;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "cluster.get_component_template";

	/// <summary>
	/// <para>
	/// Comma-separated list of component template names used to limit the request.
	/// Wildcard (<c>*</c>) expressions are supported.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Name? Name { get => P<Elastic.Clients.Elasticsearch.Name?>("name"); set => PO("name", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, returns settings in flat format.
	/// </para>
	/// </summary>
	public bool? FlatSettings { get => Q<bool?>("flat_settings"); set => Q("flat_settings", value); }

	/// <summary>
	/// <para>
	/// Return all default configurations for the component template (default: false)
	/// </para>
	/// </summary>
	public bool? IncludeDefaults { get => Q<bool?>("include_defaults"); set => Q("include_defaults", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request retrieves information from the local node only.
	/// If <c>false</c>, information is retrieved from the master node.
	/// </para>
	/// </summary>
	public bool? Local { get => Q<bool?>("local"); set => Q("local", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// Filter out results, for example to filter out sensitive information. Supports wildcards or full settings keys
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? SettingsFilter { get => Q<System.Collections.Generic.ICollection<string>?>("settings_filter"); set => Q("settings_filter", value); }
}

/// <summary>
/// <para>
/// Get component templates.
/// Get information about component templates.
/// </para>
/// </summary>
public readonly partial struct GetComponentTemplateRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetComponentTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest instance)
	{
		Instance = instance;
	}

	public GetComponentTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.Name? name)
	{
		Instance = new Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest(name);
	}

	public GetComponentTemplateRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor(Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest instance) => new Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest(Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Comma-separated list of component template names used to limit the request.
	/// Wildcard (<c>*</c>) expressions are supported.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor Name(Elastic.Clients.Elasticsearch.Name? value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, returns settings in flat format.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor FlatSettings(bool? value = true)
	{
		Instance.FlatSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Return all default configurations for the component template (default: false)
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor IncludeDefaults(bool? value = true)
	{
		Instance.IncludeDefaults = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request retrieves information from the local node only.
	/// If <c>false</c>, information is retrieved from the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor Local(bool? value = true)
	{
		Instance.Local = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filter out results, for example to filter out sensitive information. Supports wildcards or full settings keys
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor SettingsFilter(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.SettingsFilter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filter out results, for example to filter out sensitive information. Supports wildcards or full settings keys
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor SettingsFilter(params string[] values)
	{
		Instance.SettingsFilter = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest Build(System.Action<Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor(new Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.GetComponentTemplateRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}