// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.ClusterStatsResponseConverter))]
public sealed partial class ClusterStatsResponse : Elastic.Transport.Products.Elasticsearch.ElasticsearchResponse
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClusterStatsResponse()
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ClusterStatsResponse(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Cross-cluster stats
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.CCSStats Ccs { get; set; }

	/// <summary>
	/// <para>
	/// Name of the cluster, based on the cluster name setting.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ClusterName { get; set; }

	/// <summary>
	/// <para>
	/// Unique identifier for the cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ClusterUuid { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about indices with shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.ClusterIndices Indices { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about nodes selected by the request’s node filters.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.ClusterNodes Nodes { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about the number of nodes selected by the request’s node filters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.NodeStatistics? NodeStats { get; set; }

	/// <summary>
	/// <para>
	/// Contains stats on repository feature usage exposed in cluster stats for telemetry.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyDictionary<string, System.Collections.Generic.IReadOnlyDictionary<string, long>> Repositories { get; set; }

	/// <summary>
	/// <para>
	/// Contains stats cluster snapshots.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.ClusterSnapshotStats Snapshots { get; set; }

	/// <summary>
	/// <para>
	/// Health status of the cluster, based on the state of its primary and replica shards.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.HealthStatus? Status { get; set; }

	/// <summary>
	/// <para>
	/// Unix timestamp, in milliseconds, for the last time the cluster statistics were refreshed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Timestamp { get; set; }
}