// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

public sealed partial class ClusterStatsRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Include remote cluster data into the response
	/// </para>
	/// </summary>
	public bool? IncludeRemotes { get => Q<bool?>("include_remotes"); set => Q("include_remotes", value); }

	/// <summary>
	/// <para>
	/// Period to wait for each node to respond.
	/// If a node does not respond before its timeout expires, the response does not include its stats.
	/// However, timed out nodes are included in the response’s <c>_nodes.failed</c> property. Defaults to no timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Get cluster statistics.
/// Get basic index metrics (shard numbers, store size, memory usage) and information about the current nodes that form the cluster (number, roles, os, jvm versions, memory usage, cpu and installed plugins).
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.ClusterStatsRequestConverter))]
public sealed partial class ClusterStatsRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestParameters>
{
	public ClusterStatsRequest(Elastic.Clients.Elasticsearch.NodeIds? nodeId) : base(r => r.Optional("node_id", nodeId))
	{
	}
#if NET7_0_OR_GREATER
	public ClusterStatsRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ClusterStatsRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ClusterStatsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.ClusterStats;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "cluster.stats";

	/// <summary>
	/// <para>
	/// Comma-separated list of node filters used to limit returned information. Defaults to all nodes in the cluster.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.NodeIds? NodeId { get => P<Elastic.Clients.Elasticsearch.NodeIds?>("node_id"); set => PO("node_id", value); }

	/// <summary>
	/// <para>
	/// Include remote cluster data into the response
	/// </para>
	/// </summary>
	public bool? IncludeRemotes { get => Q<bool?>("include_remotes"); set => Q("include_remotes", value); }

	/// <summary>
	/// <para>
	/// Period to wait for each node to respond.
	/// If a node does not respond before its timeout expires, the response does not include its stats.
	/// However, timed out nodes are included in the response’s <c>_nodes.failed</c> property. Defaults to no timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Get cluster statistics.
/// Get basic index metrics (shard numbers, store size, memory usage) and information about the current nodes that form the cluster (number, roles, os, jvm versions, memory usage, cpu and installed plugins).
/// </para>
/// </summary>
public readonly partial struct ClusterStatsRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClusterStatsRequestDescriptor(Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest instance)
	{
		Instance = instance;
	}

	public ClusterStatsRequestDescriptor(Elastic.Clients.Elasticsearch.NodeIds? nodeId)
	{
		Instance = new Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest(nodeId);
	}

	public ClusterStatsRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor(Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest instance) => new Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest(Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Comma-separated list of node filters used to limit returned information. Defaults to all nodes in the cluster.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor NodeId(Elastic.Clients.Elasticsearch.NodeIds? value)
	{
		Instance.NodeId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Include remote cluster data into the response
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor IncludeRemotes(bool? value = true)
	{
		Instance.IncludeRemotes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for each node to respond.
	/// If a node does not respond before its timeout expires, the response does not include its stats.
	/// However, timed out nodes are included in the response’s <c>_nodes.failed</c> property. Defaults to no timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest Build(System.Action<Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor(new Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.ClusterStatsRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}