// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

public sealed partial class ClusterInfoRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Get cluster info.
/// Returns basic information about the cluster.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.ClusterInfoRequestConverter))]
public sealed partial class ClusterInfoRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClusterInfoRequest(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ClusterInfoTarget> target) : base(r => r.Required("target", target))
	{
	}
#if NET7_0_OR_GREATER
	public ClusterInfoRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ClusterInfoRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.ClusterInfo;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "cluster.info";

	/// <summary>
	/// <para>
	/// Limits the information returned to the specific target. Supports a comma-separated list, such as http,ingest.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ClusterInfoTarget> Target { get => P<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ClusterInfoTarget>>("target"); set => PR("target", value); }
}

/// <summary>
/// <para>
/// Get cluster info.
/// Returns basic information about the cluster.
/// </para>
/// </summary>
public readonly partial struct ClusterInfoRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClusterInfoRequestDescriptor(Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequest instance)
	{
		Instance = instance;
	}

	public ClusterInfoRequestDescriptor(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ClusterInfoTarget> target)
	{
		Instance = new Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequest(target);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public ClusterInfoRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor(Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequest instance) => new Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequest(Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Limits the information returned to the specific target. Supports a comma-separated list, such as http,ingest.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor Target(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ClusterInfoTarget> value)
	{
		Instance.Target = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limits the information returned to the specific target. Supports a comma-separated list, such as http,ingest.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor Target(params Elastic.Clients.Elasticsearch.ClusterInfoTarget[] values)
	{
		Instance.Target = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequest Build(System.Action<Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor(new Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.ClusterInfoRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}