// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class AllocationExplainResponseConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.AllocationExplainResponse>
{
	private static readonly System.Text.Json.JsonEncodedText PropAllocateExplanation = System.Text.Json.JsonEncodedText.Encode("allocate_explanation");
	private static readonly System.Text.Json.JsonEncodedText PropAllocationDelay = System.Text.Json.JsonEncodedText.Encode("allocation_delay");
	private static readonly System.Text.Json.JsonEncodedText PropAllocationDelayInMillis = System.Text.Json.JsonEncodedText.Encode("allocation_delay_in_millis");
	private static readonly System.Text.Json.JsonEncodedText PropCanAllocate = System.Text.Json.JsonEncodedText.Encode("can_allocate");
	private static readonly System.Text.Json.JsonEncodedText PropCanMoveToOtherNode = System.Text.Json.JsonEncodedText.Encode("can_move_to_other_node");
	private static readonly System.Text.Json.JsonEncodedText PropCanRebalanceCluster = System.Text.Json.JsonEncodedText.Encode("can_rebalance_cluster");
	private static readonly System.Text.Json.JsonEncodedText PropCanRebalanceClusterDecisions = System.Text.Json.JsonEncodedText.Encode("can_rebalance_cluster_decisions");
	private static readonly System.Text.Json.JsonEncodedText PropCanRebalanceToOtherNode = System.Text.Json.JsonEncodedText.Encode("can_rebalance_to_other_node");
	private static readonly System.Text.Json.JsonEncodedText PropCanRemainDecisions = System.Text.Json.JsonEncodedText.Encode("can_remain_decisions");
	private static readonly System.Text.Json.JsonEncodedText PropCanRemainOnCurrentNode = System.Text.Json.JsonEncodedText.Encode("can_remain_on_current_node");
	private static readonly System.Text.Json.JsonEncodedText PropClusterInfo = System.Text.Json.JsonEncodedText.Encode("cluster_info");
	private static readonly System.Text.Json.JsonEncodedText PropConfiguredDelay = System.Text.Json.JsonEncodedText.Encode("configured_delay");
	private static readonly System.Text.Json.JsonEncodedText PropConfiguredDelayInMillis = System.Text.Json.JsonEncodedText.Encode("configured_delay_in_millis");
	private static readonly System.Text.Json.JsonEncodedText PropCurrentNode = System.Text.Json.JsonEncodedText.Encode("current_node");
	private static readonly System.Text.Json.JsonEncodedText PropCurrentState = System.Text.Json.JsonEncodedText.Encode("current_state");
	private static readonly System.Text.Json.JsonEncodedText PropIndex = System.Text.Json.JsonEncodedText.Encode("index");
	private static readonly System.Text.Json.JsonEncodedText PropMoveExplanation = System.Text.Json.JsonEncodedText.Encode("move_explanation");
	private static readonly System.Text.Json.JsonEncodedText PropNodeAllocationDecisions = System.Text.Json.JsonEncodedText.Encode("node_allocation_decisions");
	private static readonly System.Text.Json.JsonEncodedText PropNote = System.Text.Json.JsonEncodedText.Encode("note");
	private static readonly System.Text.Json.JsonEncodedText PropPrimary = System.Text.Json.JsonEncodedText.Encode("primary");
	private static readonly System.Text.Json.JsonEncodedText PropRebalanceExplanation = System.Text.Json.JsonEncodedText.Encode("rebalance_explanation");
	private static readonly System.Text.Json.JsonEncodedText PropRemainingDelay = System.Text.Json.JsonEncodedText.Encode("remaining_delay");
	private static readonly System.Text.Json.JsonEncodedText PropRemainingDelayInMillis = System.Text.Json.JsonEncodedText.Encode("remaining_delay_in_millis");
	private static readonly System.Text.Json.JsonEncodedText PropShard = System.Text.Json.JsonEncodedText.Encode("shard");
	private static readonly System.Text.Json.JsonEncodedText PropUnassignedInfo = System.Text.Json.JsonEncodedText.Encode("unassigned_info");

	public override Elastic.Clients.Elasticsearch.Cluster.AllocationExplainResponse Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propAllocateExplanation = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propAllocationDelay = default;
		LocalJsonValue<System.TimeSpan?> propAllocationDelayInMillis = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.Decision?> propCanAllocate = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.Decision?> propCanMoveToOtherNode = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.Decision?> propCanRebalanceCluster = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.AllocationDecision>?> propCanRebalanceClusterDecisions = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.Decision?> propCanRebalanceToOtherNode = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.AllocationDecision>?> propCanRemainDecisions = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.Decision?> propCanRemainOnCurrentNode = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.ClusterInfo?> propClusterInfo = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propConfiguredDelay = default;
		LocalJsonValue<System.TimeSpan?> propConfiguredDelayInMillis = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.CurrentNode?> propCurrentNode = default;
		LocalJsonValue<string> propCurrentState = default;
		LocalJsonValue<string> propIndex = default;
		LocalJsonValue<string?> propMoveExplanation = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.NodeAllocationExplanation>?> propNodeAllocationDecisions = default;
		LocalJsonValue<string?> propNote = default;
		LocalJsonValue<bool> propPrimary = default;
		LocalJsonValue<string?> propRebalanceExplanation = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propRemainingDelay = default;
		LocalJsonValue<System.TimeSpan?> propRemainingDelayInMillis = default;
		LocalJsonValue<int> propShard = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.UnassignedInformation?> propUnassignedInfo = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAllocateExplanation.TryReadProperty(ref reader, options, PropAllocateExplanation, null))
			{
				continue;
			}

			if (propAllocationDelay.TryReadProperty(ref reader, options, PropAllocationDelay, null))
			{
				continue;
			}

			if (propAllocationDelayInMillis.TryReadProperty(ref reader, options, PropAllocationDelayInMillis, static System.TimeSpan? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker))))
			{
				continue;
			}

			if (propCanAllocate.TryReadProperty(ref reader, options, PropCanAllocate, static Elastic.Clients.Elasticsearch.Cluster.Decision? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.Cluster.Decision>(o)))
			{
				continue;
			}

			if (propCanMoveToOtherNode.TryReadProperty(ref reader, options, PropCanMoveToOtherNode, static Elastic.Clients.Elasticsearch.Cluster.Decision? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.Cluster.Decision>(o)))
			{
				continue;
			}

			if (propCanRebalanceCluster.TryReadProperty(ref reader, options, PropCanRebalanceCluster, static Elastic.Clients.Elasticsearch.Cluster.Decision? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.Cluster.Decision>(o)))
			{
				continue;
			}

			if (propCanRebalanceClusterDecisions.TryReadProperty(ref reader, options, PropCanRebalanceClusterDecisions, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.AllocationDecision>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Cluster.AllocationDecision>(o, null)))
			{
				continue;
			}

			if (propCanRebalanceToOtherNode.TryReadProperty(ref reader, options, PropCanRebalanceToOtherNode, static Elastic.Clients.Elasticsearch.Cluster.Decision? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.Cluster.Decision>(o)))
			{
				continue;
			}

			if (propCanRemainDecisions.TryReadProperty(ref reader, options, PropCanRemainDecisions, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.AllocationDecision>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Cluster.AllocationDecision>(o, null)))
			{
				continue;
			}

			if (propCanRemainOnCurrentNode.TryReadProperty(ref reader, options, PropCanRemainOnCurrentNode, static Elastic.Clients.Elasticsearch.Cluster.Decision? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.Cluster.Decision>(o)))
			{
				continue;
			}

			if (propClusterInfo.TryReadProperty(ref reader, options, PropClusterInfo, null))
			{
				continue;
			}

			if (propConfiguredDelay.TryReadProperty(ref reader, options, PropConfiguredDelay, null))
			{
				continue;
			}

			if (propConfiguredDelayInMillis.TryReadProperty(ref reader, options, PropConfiguredDelayInMillis, static System.TimeSpan? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker))))
			{
				continue;
			}

			if (propCurrentNode.TryReadProperty(ref reader, options, PropCurrentNode, null))
			{
				continue;
			}

			if (propCurrentState.TryReadProperty(ref reader, options, PropCurrentState, null))
			{
				continue;
			}

			if (propIndex.TryReadProperty(ref reader, options, PropIndex, null))
			{
				continue;
			}

			if (propMoveExplanation.TryReadProperty(ref reader, options, PropMoveExplanation, null))
			{
				continue;
			}

			if (propNodeAllocationDecisions.TryReadProperty(ref reader, options, PropNodeAllocationDecisions, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.NodeAllocationExplanation>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Cluster.NodeAllocationExplanation>(o, null)))
			{
				continue;
			}

			if (propNote.TryReadProperty(ref reader, options, PropNote, null))
			{
				continue;
			}

			if (propPrimary.TryReadProperty(ref reader, options, PropPrimary, null))
			{
				continue;
			}

			if (propRebalanceExplanation.TryReadProperty(ref reader, options, PropRebalanceExplanation, null))
			{
				continue;
			}

			if (propRemainingDelay.TryReadProperty(ref reader, options, PropRemainingDelay, null))
			{
				continue;
			}

			if (propRemainingDelayInMillis.TryReadProperty(ref reader, options, PropRemainingDelayInMillis, static System.TimeSpan? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker))))
			{
				continue;
			}

			if (propShard.TryReadProperty(ref reader, options, PropShard, null))
			{
				continue;
			}

			if (propUnassignedInfo.TryReadProperty(ref reader, options, PropUnassignedInfo, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Cluster.AllocationExplainResponse(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AllocateExplanation = propAllocateExplanation.Value,
			AllocationDelay = propAllocationDelay.Value,
			AllocationDelayInMillis = propAllocationDelayInMillis.Value,
			CanAllocate = propCanAllocate.Value,
			CanMoveToOtherNode = propCanMoveToOtherNode.Value,
			CanRebalanceCluster = propCanRebalanceCluster.Value,
			CanRebalanceClusterDecisions = propCanRebalanceClusterDecisions.Value,
			CanRebalanceToOtherNode = propCanRebalanceToOtherNode.Value,
			CanRemainDecisions = propCanRemainDecisions.Value,
			CanRemainOnCurrentNode = propCanRemainOnCurrentNode.Value,
			ClusterInfo = propClusterInfo.Value,
			ConfiguredDelay = propConfiguredDelay.Value,
			ConfiguredDelayInMillis = propConfiguredDelayInMillis.Value,
			CurrentNode = propCurrentNode.Value,
			CurrentState = propCurrentState.Value,
			Index = propIndex.Value,
			MoveExplanation = propMoveExplanation.Value,
			NodeAllocationDecisions = propNodeAllocationDecisions.Value,
			Note = propNote.Value,
			Primary = propPrimary.Value,
			RebalanceExplanation = propRebalanceExplanation.Value,
			RemainingDelay = propRemainingDelay.Value,
			RemainingDelayInMillis = propRemainingDelayInMillis.Value,
			Shard = propShard.Value,
			UnassignedInfo = propUnassignedInfo.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.AllocationExplainResponse value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAllocateExplanation, value.AllocateExplanation, null, null);
		writer.WriteProperty(options, PropAllocationDelay, value.AllocationDelay, null, null);
		writer.WriteProperty(options, PropAllocationDelayInMillis, value.AllocationDelayInMillis, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan? v) => w.WriteNullableValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker)));
		writer.WriteProperty(options, PropCanAllocate, value.CanAllocate, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Cluster.Decision? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.Cluster.Decision>(o, v));
		writer.WriteProperty(options, PropCanMoveToOtherNode, value.CanMoveToOtherNode, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Cluster.Decision? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.Cluster.Decision>(o, v));
		writer.WriteProperty(options, PropCanRebalanceCluster, value.CanRebalanceCluster, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Cluster.Decision? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.Cluster.Decision>(o, v));
		writer.WriteProperty(options, PropCanRebalanceClusterDecisions, value.CanRebalanceClusterDecisions, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.AllocationDecision>? v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Cluster.AllocationDecision>(o, v, null));
		writer.WriteProperty(options, PropCanRebalanceToOtherNode, value.CanRebalanceToOtherNode, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Cluster.Decision? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.Cluster.Decision>(o, v));
		writer.WriteProperty(options, PropCanRemainDecisions, value.CanRemainDecisions, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.AllocationDecision>? v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Cluster.AllocationDecision>(o, v, null));
		writer.WriteProperty(options, PropCanRemainOnCurrentNode, value.CanRemainOnCurrentNode, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Cluster.Decision? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.Cluster.Decision>(o, v));
		writer.WriteProperty(options, PropClusterInfo, value.ClusterInfo, null, null);
		writer.WriteProperty(options, PropConfiguredDelay, value.ConfiguredDelay, null, null);
		writer.WriteProperty(options, PropConfiguredDelayInMillis, value.ConfiguredDelayInMillis, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan? v) => w.WriteNullableValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker)));
		writer.WriteProperty(options, PropCurrentNode, value.CurrentNode, null, null);
		writer.WriteProperty(options, PropCurrentState, value.CurrentState, null, null);
		writer.WriteProperty(options, PropIndex, value.Index, null, null);
		writer.WriteProperty(options, PropMoveExplanation, value.MoveExplanation, null, null);
		writer.WriteProperty(options, PropNodeAllocationDecisions, value.NodeAllocationDecisions, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.NodeAllocationExplanation>? v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Cluster.NodeAllocationExplanation>(o, v, null));
		writer.WriteProperty(options, PropNote, value.Note, null, null);
		writer.WriteProperty(options, PropPrimary, value.Primary, null, null);
		writer.WriteProperty(options, PropRebalanceExplanation, value.RebalanceExplanation, null, null);
		writer.WriteProperty(options, PropRemainingDelay, value.RemainingDelay, null, null);
		writer.WriteProperty(options, PropRemainingDelayInMillis, value.RemainingDelayInMillis, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan? v) => w.WriteNullableValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker)));
		writer.WriteProperty(options, PropShard, value.Shard, null, null);
		writer.WriteProperty(options, PropUnassignedInfo, value.UnassignedInfo, null, null);
		writer.WriteEndObject();
	}
}