// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

public sealed partial class AllocationExplainRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If true, returns information about disk usage and shard sizes.
	/// </para>
	/// </summary>
	public bool? IncludeDiskInfo { get => Q<bool?>("include_disk_info"); set => Q("include_disk_info", value); }

	/// <summary>
	/// <para>
	/// If true, returns YES decisions in explanation.
	/// </para>
	/// </summary>
	public bool? IncludeYesDecisions { get => Q<bool?>("include_yes_decisions"); set => Q("include_yes_decisions", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }
}

/// <summary>
/// <para>
/// Explain the shard allocations.
/// Get explanations for shard allocations in the cluster.
/// For unassigned shards, it provides an explanation for why the shard is unassigned.
/// For assigned shards, it provides an explanation for why the shard is remaining on its current node and has not moved or rebalanced to another node.
/// This API can be very useful when attempting to diagnose why a shard is unassigned or why a shard continues to remain on its current node when you might expect otherwise.
/// Refer to the linked documentation for examples of how to troubleshoot allocation issues using this API.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.AllocationExplainRequestConverter))]
public sealed partial class AllocationExplainRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestParameters>
{
#if NET7_0_OR_GREATER
	public AllocationExplainRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public AllocationExplainRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AllocationExplainRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.ClusterAllocationExplain;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "cluster.allocation_explain";

	/// <summary>
	/// <para>
	/// If true, returns information about disk usage and shard sizes.
	/// </para>
	/// </summary>
	public bool? IncludeDiskInfo { get => Q<bool?>("include_disk_info"); set => Q("include_disk_info", value); }

	/// <summary>
	/// <para>
	/// If true, returns YES decisions in explanation.
	/// </para>
	/// </summary>
	public bool? IncludeYesDecisions { get => Q<bool?>("include_yes_decisions"); set => Q("include_yes_decisions", value); }

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// Specifies the node ID or the name of the node to only explain a shard that is currently located on the specified node.
	/// </para>
	/// </summary>
	public string? CurrentNode { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the name of the index that you would like an explanation for.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexName? Index { get; set; }

	/// <summary>
	/// <para>
	/// If true, returns explanation for the primary shard for the given shard ID.
	/// </para>
	/// </summary>
	public bool? Primary { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the ID of the shard that you would like an explanation for.
	/// </para>
	/// </summary>
	public int? Shard { get; set; }
}

/// <summary>
/// <para>
/// Explain the shard allocations.
/// Get explanations for shard allocations in the cluster.
/// For unassigned shards, it provides an explanation for why the shard is unassigned.
/// For assigned shards, it provides an explanation for why the shard is remaining on its current node and has not moved or rebalanced to another node.
/// This API can be very useful when attempting to diagnose why a shard is unassigned or why a shard continues to remain on its current node when you might expect otherwise.
/// Refer to the linked documentation for examples of how to troubleshoot allocation issues using this API.
/// </para>
/// </summary>
public readonly partial struct AllocationExplainRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AllocationExplainRequestDescriptor(Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequest instance)
	{
		Instance = instance;
	}

	public AllocationExplainRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor(Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequest instance) => new Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequest(Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If true, returns information about disk usage and shard sizes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor IncludeDiskInfo(bool? value = true)
	{
		Instance.IncludeDiskInfo = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, returns YES decisions in explanation.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor IncludeYesDecisions(bool? value = true)
	{
		Instance.IncludeYesDecisions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Period to wait for a connection to the master node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the node ID or the name of the node to only explain a shard that is currently located on the specified node.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor CurrentNode(string? value)
	{
		Instance.CurrentNode = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the name of the index that you would like an explanation for.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor Index(Elastic.Clients.Elasticsearch.IndexName? value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, returns explanation for the primary shard for the given shard ID.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor Primary(bool? value = true)
	{
		Instance.Primary = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the ID of the shard that you would like an explanation for.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor Shard(int? value)
	{
		Instance.Shard = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequest Build(System.Action<Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor(new Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Cluster.AllocationExplainRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}