// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

public sealed partial class ClosePointInTimeRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Close a point in time.
/// A point in time must be opened explicitly before being used in search requests.
/// The <c>keep_alive</c> parameter tells Elasticsearch how long it should persist.
/// A point in time is automatically closed when the <c>keep_alive</c> period has elapsed.
/// However, keeping points in time has a cost; close them as soon as they are no longer required for search requests.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.ClosePointInTimeRequestConverter))]
public sealed partial class ClosePointInTimeRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.ClosePointInTimeRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClosePointInTimeRequest(Elastic.Clients.Elasticsearch.Id id)
	{
		Id = id;
	}
#if NET7_0_OR_GREATER
	public ClosePointInTimeRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ClosePointInTimeRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ClosePointInTimeRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.NoNamespaceClosePointInTime;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.DELETE;

	internal override bool SupportsBody => true;

	internal override string OperationName => "close_point_in_time";

	/// <summary>
	/// <para>
	/// The ID of the point-in-time.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id Id { get; set; }
}

/// <summary>
/// <para>
/// Close a point in time.
/// A point in time must be opened explicitly before being used in search requests.
/// The <c>keep_alive</c> parameter tells Elasticsearch how long it should persist.
/// A point in time is automatically closed when the <c>keep_alive</c> period has elapsed.
/// However, keeping points in time has a cost; close them as soon as they are no longer required for search requests.
/// </para>
/// </summary>
public readonly partial struct ClosePointInTimeRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.ClosePointInTimeRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClosePointInTimeRequestDescriptor(Elastic.Clients.Elasticsearch.ClosePointInTimeRequest instance)
	{
		Instance = instance;
	}

	public ClosePointInTimeRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.ClosePointInTimeRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.ClosePointInTimeRequestDescriptor(Elastic.Clients.Elasticsearch.ClosePointInTimeRequest instance) => new Elastic.Clients.Elasticsearch.ClosePointInTimeRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.ClosePointInTimeRequest(Elastic.Clients.Elasticsearch.ClosePointInTimeRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The ID of the point-in-time.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ClosePointInTimeRequestDescriptor Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.ClosePointInTimeRequest Build(System.Action<Elastic.Clients.Elasticsearch.ClosePointInTimeRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.ClosePointInTimeRequestDescriptor(new Elastic.Clients.Elasticsearch.ClosePointInTimeRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.ClosePointInTimeRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ClosePointInTimeRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ClosePointInTimeRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ClosePointInTimeRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ClosePointInTimeRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ClosePointInTimeRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.ClosePointInTimeRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}