// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.AsyncSearch;

public sealed partial class SubmitAsyncSearchRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes <c>_all</c> string or when no indices have been specified)
	/// </para>
	/// </summary>
	public bool? AllowNoIndices { get => Q<bool?>("allow_no_indices"); set => Q("allow_no_indices", value); }

	/// <summary>
	/// <para>
	/// Indicate if an error should be returned if there is a partial search failure or timeout
	/// </para>
	/// </summary>
	public bool? AllowPartialSearchResults { get => Q<bool?>("allow_partial_search_results"); set => Q("allow_partial_search_results", value); }

	/// <summary>
	/// <para>
	/// The analyzer to use for the query string
	/// </para>
	/// </summary>
	public string? Analyzer { get => Q<string?>("analyzer"); set => Q("analyzer", value); }

	/// <summary>
	/// <para>
	/// Specify whether wildcard and prefix queries should be analyzed (default: false)
	/// </para>
	/// </summary>
	public bool? AnalyzeWildcard { get => Q<bool?>("analyze_wildcard"); set => Q("analyze_wildcard", value); }

	/// <summary>
	/// <para>
	/// Affects how often partial results become available, which happens whenever shard results are reduced.
	/// A partial reduction is performed every time the coordinating node has received a certain number of new shard responses (5 by default).
	/// </para>
	/// </summary>
	public long? BatchedReduceSize { get => Q<long?>("batched_reduce_size"); set => Q("batched_reduce_size", value); }

	/// <summary>
	/// <para>
	/// The default value is the only supported value.
	/// </para>
	/// </summary>
	public bool? CcsMinimizeRoundtrips { get => Q<bool?>("ccs_minimize_roundtrips"); set => Q("ccs_minimize_roundtrips", value); }

	/// <summary>
	/// <para>
	/// The default operator for query string query (AND or OR)
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Operator? DefaultOperator { get => Q<Elastic.Clients.Elasticsearch.QueryDsl.Operator?>("default_operator"); set => Q("default_operator", value); }

	/// <summary>
	/// <para>
	/// The field to use as default where no field prefix is given in the query string
	/// </para>
	/// </summary>
	public string? Df { get => Q<string?>("df"); set => Q("df", value); }

	/// <summary>
	/// <para>
	/// Whether to expand wildcard expression to concrete indices that are open, closed or both.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? ExpandWildcards { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>?>("expand_wildcards"); set => Q("expand_wildcards", value); }

	/// <summary>
	/// <para>
	/// Whether specified concrete, expanded or aliased indices should be ignored when throttled
	/// </para>
	/// </summary>
	public bool? IgnoreThrottled { get => Q<bool?>("ignore_throttled"); set => Q("ignore_throttled", value); }

	/// <summary>
	/// <para>
	/// Whether specified concrete indices should be ignored when unavailable (missing or closed)
	/// </para>
	/// </summary>
	public bool? IgnoreUnavailable { get => Q<bool?>("ignore_unavailable"); set => Q("ignore_unavailable", value); }

	/// <summary>
	/// <para>
	/// Specifies how long the async search needs to be available.
	/// Ongoing async searches and any saved search results are deleted after this period.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? KeepAlive { get => Q<Elastic.Clients.Elasticsearch.Duration?>("keep_alive"); set => Q("keep_alive", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, results are stored for later retrieval when the search completes within the <c>wait_for_completion_timeout</c>.
	/// </para>
	/// </summary>
	public bool? KeepOnCompletion { get => Q<bool?>("keep_on_completion"); set => Q("keep_on_completion", value); }

	/// <summary>
	/// <para>
	/// Specify whether format-based query failures (such as providing text to a numeric field) should be ignored
	/// </para>
	/// </summary>
	public bool? Lenient { get => Q<bool?>("lenient"); set => Q("lenient", value); }

	/// <summary>
	/// <para>
	/// The number of concurrent shard requests per node this search executes concurrently. This value should be used to limit the impact of the search on the cluster in order to limit the number of concurrent shard requests
	/// </para>
	/// </summary>
	public int? MaxConcurrentShardRequests { get => Q<int?>("max_concurrent_shard_requests"); set => Q("max_concurrent_shard_requests", value); }

	/// <summary>
	/// <para>
	/// Specify the node or shard the operation should be performed on (default: random)
	/// </para>
	/// </summary>
	public string? Preference { get => Q<string?>("preference"); set => Q("preference", value); }

	/// <summary>
	/// <para>
	/// Query in the Lucene query string syntax
	/// </para>
	/// </summary>
	public string? QueryLuceneSyntax { get => Q<string?>("q"); set => Q("q", value); }

	/// <summary>
	/// <para>
	/// Specify if request cache should be used for this request or not, defaults to true
	/// </para>
	/// </summary>
	public bool? RequestCache { get => Q<bool?>("request_cache"); set => Q("request_cache", value); }

	/// <summary>
	/// <para>
	/// Indicates whether hits.total should be rendered as an integer or an object in the rest search response
	/// </para>
	/// </summary>
	public bool? RestTotalHitsAsInt { get => Q<bool?>("rest_total_hits_as_int"); set => Q("rest_total_hits_as_int", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of specific routing values
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Routing? Routing { get => Q<Elastic.Clients.Elasticsearch.Routing?>("routing"); set => Q("routing", value); }

	/// <summary>
	/// <para>
	/// Search operation type
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchType? SearchType { get => Q<Elastic.Clients.Elasticsearch.SearchType?>("search_type"); set => Q("search_type", value); }

	/// <summary>
	/// <para>
	/// A list of fields to exclude from the returned _source field
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? SourceExcludes { get => Q<Elastic.Clients.Elasticsearch.Fields?>("_source_excludes"); set => Q("_source_excludes", value); }

	/// <summary>
	/// <para>
	/// A list of fields to extract and return from the _source field
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? SourceIncludes { get => Q<Elastic.Clients.Elasticsearch.Fields?>("_source_includes"); set => Q("_source_includes", value); }

	/// <summary>
	/// <para>
	/// Specifies which field to use for suggestions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? SuggestField { get => Q<Elastic.Clients.Elasticsearch.Field?>("suggest_field"); set => Q("suggest_field", value); }

	/// <summary>
	/// <para>
	/// Specify suggest mode
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SuggestMode? SuggestMode { get => Q<Elastic.Clients.Elasticsearch.SuggestMode?>("suggest_mode"); set => Q("suggest_mode", value); }

	/// <summary>
	/// <para>
	/// How many suggestions to return in response
	/// </para>
	/// </summary>
	public long? SuggestSize { get => Q<long?>("suggest_size"); set => Q("suggest_size", value); }

	/// <summary>
	/// <para>
	/// The source text for which the suggestions should be returned.
	/// </para>
	/// </summary>
	public string? SuggestText { get => Q<string?>("suggest_text"); set => Q("suggest_text", value); }

	/// <summary>
	/// <para>
	/// Specify whether aggregation and suggester names should be prefixed by their respective types in the response
	/// </para>
	/// </summary>
	public bool? TypedKeys { get => Q<bool?>("typed_keys"); set => Q("typed_keys", value); }

	/// <summary>
	/// <para>
	/// Blocks and waits until the search is completed up to a certain timeout.
	/// When the async search completes within the timeout, the response won’t include the ID as the results are not stored in the cluster.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? WaitForCompletionTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("wait_for_completion_timeout"); set => Q("wait_for_completion_timeout", value); }
}

/// <summary>
/// <para>
/// Run an async search.
/// </para>
/// <para>
/// When the primary sort of the results is an indexed field, shards get sorted based on minimum and maximum value that they hold for that field. Partial results become available following the sort criteria that was requested.
/// </para>
/// <para>
/// Warning: Asynchronous search does not support scroll or search requests that include only the suggest section.
/// </para>
/// <para>
/// By default, Elasticsearch does not allow you to store an async search response larger than 10Mb and an attempt to do this results in an error.
/// The maximum allowed size for a stored async search response can be set by changing the <c>search.max_async_search_response_size</c> cluster level setting.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.AsyncSearch.Json.SubmitAsyncSearchRequestConverter))]
public partial class SubmitAsyncSearchRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestParameters>
{
	public SubmitAsyncSearchRequest(Elastic.Clients.Elasticsearch.Indices? indices) : base(r => r.Optional("index", indices))
	{
	}
#if NET7_0_OR_GREATER
	public SubmitAsyncSearchRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public SubmitAsyncSearchRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SubmitAsyncSearchRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.AsyncSearchSubmit;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "async_search.submit";

	/// <summary>
	/// <para>
	/// A comma-separated list of index names to search; use <c>_all</c> or empty string to perform the operation on all indices
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Indices? Indices { get => P<Elastic.Clients.Elasticsearch.Indices?>("index"); set => PO("index", value); }

	/// <summary>
	/// <para>
	/// Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes <c>_all</c> string or when no indices have been specified)
	/// </para>
	/// </summary>
	public bool? AllowNoIndices { get => Q<bool?>("allow_no_indices"); set => Q("allow_no_indices", value); }

	/// <summary>
	/// <para>
	/// Indicate if an error should be returned if there is a partial search failure or timeout
	/// </para>
	/// </summary>
	public bool? AllowPartialSearchResults { get => Q<bool?>("allow_partial_search_results"); set => Q("allow_partial_search_results", value); }

	/// <summary>
	/// <para>
	/// The analyzer to use for the query string
	/// </para>
	/// </summary>
	public string? Analyzer { get => Q<string?>("analyzer"); set => Q("analyzer", value); }

	/// <summary>
	/// <para>
	/// Specify whether wildcard and prefix queries should be analyzed (default: false)
	/// </para>
	/// </summary>
	public bool? AnalyzeWildcard { get => Q<bool?>("analyze_wildcard"); set => Q("analyze_wildcard", value); }

	/// <summary>
	/// <para>
	/// Affects how often partial results become available, which happens whenever shard results are reduced.
	/// A partial reduction is performed every time the coordinating node has received a certain number of new shard responses (5 by default).
	/// </para>
	/// </summary>
	public long? BatchedReduceSize { get => Q<long?>("batched_reduce_size"); set => Q("batched_reduce_size", value); }

	/// <summary>
	/// <para>
	/// The default value is the only supported value.
	/// </para>
	/// </summary>
	public bool? CcsMinimizeRoundtrips { get => Q<bool?>("ccs_minimize_roundtrips"); set => Q("ccs_minimize_roundtrips", value); }

	/// <summary>
	/// <para>
	/// The default operator for query string query (AND or OR)
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Operator? DefaultOperator { get => Q<Elastic.Clients.Elasticsearch.QueryDsl.Operator?>("default_operator"); set => Q("default_operator", value); }

	/// <summary>
	/// <para>
	/// The field to use as default where no field prefix is given in the query string
	/// </para>
	/// </summary>
	public string? Df { get => Q<string?>("df"); set => Q("df", value); }

	/// <summary>
	/// <para>
	/// Whether to expand wildcard expression to concrete indices that are open, closed or both.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? ExpandWildcards { get => Q<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>?>("expand_wildcards"); set => Q("expand_wildcards", value); }

	/// <summary>
	/// <para>
	/// Whether specified concrete, expanded or aliased indices should be ignored when throttled
	/// </para>
	/// </summary>
	public bool? IgnoreThrottled { get => Q<bool?>("ignore_throttled"); set => Q("ignore_throttled", value); }

	/// <summary>
	/// <para>
	/// Whether specified concrete indices should be ignored when unavailable (missing or closed)
	/// </para>
	/// </summary>
	public bool? IgnoreUnavailable { get => Q<bool?>("ignore_unavailable"); set => Q("ignore_unavailable", value); }

	/// <summary>
	/// <para>
	/// Specifies how long the async search needs to be available.
	/// Ongoing async searches and any saved search results are deleted after this period.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? KeepAlive { get => Q<Elastic.Clients.Elasticsearch.Duration?>("keep_alive"); set => Q("keep_alive", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, results are stored for later retrieval when the search completes within the <c>wait_for_completion_timeout</c>.
	/// </para>
	/// </summary>
	public bool? KeepOnCompletion { get => Q<bool?>("keep_on_completion"); set => Q("keep_on_completion", value); }

	/// <summary>
	/// <para>
	/// Specify whether format-based query failures (such as providing text to a numeric field) should be ignored
	/// </para>
	/// </summary>
	public bool? Lenient { get => Q<bool?>("lenient"); set => Q("lenient", value); }

	/// <summary>
	/// <para>
	/// The number of concurrent shard requests per node this search executes concurrently. This value should be used to limit the impact of the search on the cluster in order to limit the number of concurrent shard requests
	/// </para>
	/// </summary>
	public int? MaxConcurrentShardRequests { get => Q<int?>("max_concurrent_shard_requests"); set => Q("max_concurrent_shard_requests", value); }

	/// <summary>
	/// <para>
	/// Specify the node or shard the operation should be performed on (default: random)
	/// </para>
	/// </summary>
	public string? Preference { get => Q<string?>("preference"); set => Q("preference", value); }

	/// <summary>
	/// <para>
	/// Query in the Lucene query string syntax
	/// </para>
	/// </summary>
	public string? QueryLuceneSyntax { get => Q<string?>("q"); set => Q("q", value); }

	/// <summary>
	/// <para>
	/// Specify if request cache should be used for this request or not, defaults to true
	/// </para>
	/// </summary>
	public bool? RequestCache { get => Q<bool?>("request_cache"); set => Q("request_cache", value); }

	/// <summary>
	/// <para>
	/// Indicates whether hits.total should be rendered as an integer or an object in the rest search response
	/// </para>
	/// </summary>
	public bool? RestTotalHitsAsInt { get => Q<bool?>("rest_total_hits_as_int"); set => Q("rest_total_hits_as_int", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of specific routing values
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Routing? Routing { get => Q<Elastic.Clients.Elasticsearch.Routing?>("routing"); set => Q("routing", value); }

	/// <summary>
	/// <para>
	/// Search operation type
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SearchType? SearchType { get => Q<Elastic.Clients.Elasticsearch.SearchType?>("search_type"); set => Q("search_type", value); }

	/// <summary>
	/// <para>
	/// A list of fields to exclude from the returned _source field
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? SourceExcludes { get => Q<Elastic.Clients.Elasticsearch.Fields?>("_source_excludes"); set => Q("_source_excludes", value); }

	/// <summary>
	/// <para>
	/// A list of fields to extract and return from the _source field
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? SourceIncludes { get => Q<Elastic.Clients.Elasticsearch.Fields?>("_source_includes"); set => Q("_source_includes", value); }

	/// <summary>
	/// <para>
	/// Specifies which field to use for suggestions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Field? SuggestField { get => Q<Elastic.Clients.Elasticsearch.Field?>("suggest_field"); set => Q("suggest_field", value); }

	/// <summary>
	/// <para>
	/// Specify suggest mode
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SuggestMode? SuggestMode { get => Q<Elastic.Clients.Elasticsearch.SuggestMode?>("suggest_mode"); set => Q("suggest_mode", value); }

	/// <summary>
	/// <para>
	/// How many suggestions to return in response
	/// </para>
	/// </summary>
	public long? SuggestSize { get => Q<long?>("suggest_size"); set => Q("suggest_size", value); }

	/// <summary>
	/// <para>
	/// The source text for which the suggestions should be returned.
	/// </para>
	/// </summary>
	public string? SuggestText { get => Q<string?>("suggest_text"); set => Q("suggest_text", value); }

	/// <summary>
	/// <para>
	/// Specify whether aggregation and suggester names should be prefixed by their respective types in the response
	/// </para>
	/// </summary>
	public bool? TypedKeys { get => Q<bool?>("typed_keys"); set => Q("typed_keys", value); }

	/// <summary>
	/// <para>
	/// Blocks and waits until the search is completed up to a certain timeout.
	/// When the async search completes within the timeout, the response won’t include the ID as the results are not stored in the cluster.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? WaitForCompletionTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("wait_for_completion_timeout"); set => Q("wait_for_completion_timeout", value); }
	public System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>? Aggregations { get; set; }
	public Elastic.Clients.Elasticsearch.Core.Search.FieldCollapse? Collapse { get; set; }

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The request returns doc values for field
	/// names matching these patterns in the hits.fields property of the response.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? DocvalueFields { get; set; }

	/// <summary>
	/// <para>
	/// If true, returns detailed information about score computation as part of a hit.
	/// </para>
	/// </summary>
	public bool? Explain { get; set; }

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Ext { get; set; }

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The request returns values for field names
	/// matching these patterns in the hits.fields property of the response.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? Fields { get; set; }

	/// <summary>
	/// <para>
	/// Starting document offset. By default, you cannot page through more than 10,000
	/// hits using the from and size parameters. To page through more hits, use the
	/// search_after parameter.
	/// </para>
	/// </summary>
	public int? From { get; set; }
	public Elastic.Clients.Elasticsearch.Core.Search.Highlight? Highlight { get; set; }

	/// <summary>
	/// <para>
	/// Boosts the _score of documents from specified indices.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>>? IndicesBoost { get; set; }

	/// <summary>
	/// <para>
	/// Defines the approximate kNN search to run.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.KnnSearch>? Knn { get; set; }

	/// <summary>
	/// <para>
	/// Minimum _score for matching documents. Documents with a lower _score are
	/// not included in search results and results collected by aggregations.
	/// </para>
	/// </summary>
	public double? MinScore { get; set; }

	/// <summary>
	/// <para>
	/// Limits the search to a point in time (PIT). If you provide a PIT, you
	/// cannot specify an &lt;index> in the request path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReference? Pit { get; set; }
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? PostFilter { get; set; }
	public bool? Profile { get; set; }

	/// <summary>
	/// <para>
	/// Defines the search definition using the Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? Query { get; set; }
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.Rescore>? Rescore { get; set; }

	/// <summary>
	/// <para>
	/// Defines one or more runtime fields in the search request. These fields take
	/// precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? RuntimeMappings { get; set; }

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.ScriptField>? ScriptFields { get; set; }
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>? SearchAfter { get; set; }

	/// <summary>
	/// <para>
	/// If true, returns sequence number and primary term of the last modification
	/// of each hit. See Optimistic concurrency control.
	/// </para>
	/// </summary>
	public bool? SeqNoPrimaryTerm { get; set; }

	/// <summary>
	/// <para>
	/// The number of hits to return. By default, you cannot page through more
	/// than 10,000 hits using the from and size parameters. To page through more
	/// hits, use the search_after parameter.
	/// </para>
	/// </summary>
	public int? Size { get; set; }
	public Elastic.Clients.Elasticsearch.SlicedScroll? Slice { get; set; }
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? Sort { get; set; }

	/// <summary>
	/// <para>
	/// Indicates which source fields are returned for matching documents. These
	/// fields are returned in the hits._source property of the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfig? Source { get; set; }

	/// <summary>
	/// <para>
	/// Stats groups to associate with the search. Each group maintains a statistics
	/// aggregation for its associated searches. You can retrieve these stats using
	/// the indices stats API.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Stats { get; set; }

	/// <summary>
	/// <para>
	/// List of stored fields to return as part of a hit. If no fields are specified,
	/// no stored fields are included in the response. If this field is specified, the _source
	/// parameter defaults to false. You can pass _source: true to return both source fields
	/// and stored fields in the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fields? StoredFields { get; set; }
	public Elastic.Clients.Elasticsearch.Core.Search.Suggester? Suggest { get; set; }

	/// <summary>
	/// <para>
	/// Maximum number of documents to collect for each shard. If a query reaches this
	/// limit, Elasticsearch terminates the query early. Elasticsearch collects documents
	/// before sorting. Defaults to 0, which does not terminate query execution early.
	/// </para>
	/// </summary>
	public long? TerminateAfter { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the period of time to wait for a response from each shard. If no response
	/// is received before the timeout expires, the request fails and returns an error.
	/// Defaults to no timeout.
	/// </para>
	/// </summary>
	public string? Timeout { get; set; }

	/// <summary>
	/// <para>
	/// If true, calculate and return document scores, even if the scores are not used for sorting.
	/// </para>
	/// </summary>
	public bool? TrackScores { get; set; }

	/// <summary>
	/// <para>
	/// Number of hits matching the query to count accurately. If true, the exact
	/// number of hits is returned at the cost of some performance. If false, the
	/// response does not include the total number of hits matching the query.
	/// Defaults to 10,000 hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.TrackHits? TrackTotalHits { get; set; }

	/// <summary>
	/// <para>
	/// If true, returns document version as part of a hit.
	/// </para>
	/// </summary>
	public bool? Version { get; set; }
}

/// <summary>
/// <para>
/// Run an async search.
/// </para>
/// <para>
/// When the primary sort of the results is an indexed field, shards get sorted based on minimum and maximum value that they hold for that field. Partial results become available following the sort criteria that was requested.
/// </para>
/// <para>
/// Warning: Asynchronous search does not support scroll or search requests that include only the suggest section.
/// </para>
/// <para>
/// By default, Elasticsearch does not allow you to store an async search response larger than 10Mb and an attempt to do this results in an error.
/// The maximum allowed size for a stored async search response can be set by changing the <c>search.max_async_search_response_size</c> cluster level setting.
/// </para>
/// </summary>
public readonly partial struct SubmitAsyncSearchRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SubmitAsyncSearchRequestDescriptor(Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequest instance)
	{
		Instance = instance;
	}

	public SubmitAsyncSearchRequestDescriptor(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		Instance = new Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequest(indices);
	}

	public SubmitAsyncSearchRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor(Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequest instance) => new Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequest(Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A comma-separated list of index names to search; use <c>_all</c> or empty string to perform the operation on all indices
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Indices(Elastic.Clients.Elasticsearch.Indices? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes <c>_all</c> string or when no indices have been specified)
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor AllowNoIndices(bool? value = true)
	{
		Instance.AllowNoIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicate if an error should be returned if there is a partial search failure or timeout
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor AllowPartialSearchResults(bool? value = true)
	{
		Instance.AllowPartialSearchResults = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The analyzer to use for the query string
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify whether wildcard and prefix queries should be analyzed (default: false)
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor AnalyzeWildcard(bool? value = true)
	{
		Instance.AnalyzeWildcard = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Affects how often partial results become available, which happens whenever shard results are reduced.
	/// A partial reduction is performed every time the coordinating node has received a certain number of new shard responses (5 by default).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor BatchedReduceSize(long? value)
	{
		Instance.BatchedReduceSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The default value is the only supported value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor CcsMinimizeRoundtrips(bool? value = true)
	{
		Instance.CcsMinimizeRoundtrips = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The default operator for query string query (AND or OR)
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor DefaultOperator(Elastic.Clients.Elasticsearch.QueryDsl.Operator? value)
	{
		Instance.DefaultOperator = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to use as default where no field prefix is given in the query string
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Df(string? value)
	{
		Instance.Df = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to expand wildcard expression to concrete indices that are open, closed or both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor ExpandWildcards(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? value)
	{
		Instance.ExpandWildcards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to expand wildcard expression to concrete indices that are open, closed or both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor ExpandWildcards(params Elastic.Clients.Elasticsearch.ExpandWildcard[] values)
	{
		Instance.ExpandWildcards = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether specified concrete, expanded or aliased indices should be ignored when throttled
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor IgnoreThrottled(bool? value = true)
	{
		Instance.IgnoreThrottled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether specified concrete indices should be ignored when unavailable (missing or closed)
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor IgnoreUnavailable(bool? value = true)
	{
		Instance.IgnoreUnavailable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies how long the async search needs to be available.
	/// Ongoing async searches and any saved search results are deleted after this period.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor KeepAlive(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.KeepAlive = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, results are stored for later retrieval when the search completes within the <c>wait_for_completion_timeout</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor KeepOnCompletion(bool? value = true)
	{
		Instance.KeepOnCompletion = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify whether format-based query failures (such as providing text to a numeric field) should be ignored
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Lenient(bool? value = true)
	{
		Instance.Lenient = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of concurrent shard requests per node this search executes concurrently. This value should be used to limit the impact of the search on the cluster in order to limit the number of concurrent shard requests
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor MaxConcurrentShardRequests(int? value)
	{
		Instance.MaxConcurrentShardRequests = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify the node or shard the operation should be performed on (default: random)
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Preference(string? value)
	{
		Instance.Preference = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query in the Lucene query string syntax
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor QueryLuceneSyntax(string? value)
	{
		Instance.QueryLuceneSyntax = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify if request cache should be used for this request or not, defaults to true
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor RequestCache(bool? value = true)
	{
		Instance.RequestCache = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether hits.total should be rendered as an integer or an object in the rest search response
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor RestTotalHitsAsInt(bool? value = true)
	{
		Instance.RestTotalHitsAsInt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of specific routing values
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Routing(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.Routing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Search operation type
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor SearchType(Elastic.Clients.Elasticsearch.SearchType? value)
	{
		Instance.SearchType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to exclude from the returned _source field
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor SourceExcludes(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.SourceExcludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to exclude from the returned _source field
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor SourceExcludes<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.SourceExcludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to extract and return from the _source field
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor SourceIncludes(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.SourceIncludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to extract and return from the _source field
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor SourceIncludes<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.SourceIncludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies which field to use for suggestions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor SuggestField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.SuggestField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies which field to use for suggestions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor SuggestField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.SuggestField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify suggest mode
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor SuggestMode(Elastic.Clients.Elasticsearch.SuggestMode? value)
	{
		Instance.SuggestMode = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// How many suggestions to return in response
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor SuggestSize(long? value)
	{
		Instance.SuggestSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The source text for which the suggestions should be returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor SuggestText(string? value)
	{
		Instance.SuggestText = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify whether aggregation and suggester names should be prefixed by their respective types in the response
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor TypedKeys(bool? value = true)
	{
		Instance.TypedKeys = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Blocks and waits until the search is completed up to a certain timeout.
	/// When the async search completes within the timeout, the response won’t include the ID as the results are not stored in the cluster.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor WaitForCompletionTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.WaitForCompletionTimeout = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Aggregations(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>? value)
	{
		Instance.Aggregations = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Aggregations()
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Aggregations(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation>? action)
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Aggregations<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<T>>? action)
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor AddAggregation(string key, Elastic.Clients.Elasticsearch.Aggregations.Aggregation value)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor AddAggregation(string key, System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor> action)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor AddAggregation<T>(string key, System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<T>> action)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Collapse(Elastic.Clients.Elasticsearch.Core.Search.FieldCollapse? value)
	{
		Instance.Collapse = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Collapse(System.Action<Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor> action)
	{
		Instance.Collapse = Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Collapse<T>(System.Action<Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor<T>> action)
	{
		Instance.Collapse = Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The request returns doc values for field
	/// names matching these patterns in the hits.fields property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor DocvalueFields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? value)
	{
		Instance.DocvalueFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The request returns doc values for field
	/// names matching these patterns in the hits.fields property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor DocvalueFields(params Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat[] values)
	{
		Instance.DocvalueFields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The request returns doc values for field
	/// names matching these patterns in the hits.fields property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor DocvalueFields(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor.Build(action));
		}

		Instance.DocvalueFields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The request returns doc values for field
	/// names matching these patterns in the hits.fields property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor DocvalueFields<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<T>.Build(action));
		}

		Instance.DocvalueFields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, returns detailed information about score computation as part of a hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Explain(bool? value = true)
	{
		Instance.Explain = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Ext(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Ext = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Ext()
	{
		Instance.Ext = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Ext(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Ext = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor AddExt(string key, object value)
	{
		Instance.Ext ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Ext.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The request returns values for field names
	/// matching these patterns in the hits.fields property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Fields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The request returns values for field names
	/// matching these patterns in the hits.fields property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Fields(params Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat[] values)
	{
		Instance.Fields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The request returns values for field names
	/// matching these patterns in the hits.fields property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Fields(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor.Build(action));
		}

		Instance.Fields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The request returns values for field names
	/// matching these patterns in the hits.fields property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Fields<T>(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<T>.Build(action));
		}

		Instance.Fields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Starting document offset. By default, you cannot page through more than 10,000
	/// hits using the from and size parameters. To page through more hits, use the
	/// search_after parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor From(int? value)
	{
		Instance.From = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Highlight(Elastic.Clients.Elasticsearch.Core.Search.Highlight? value)
	{
		Instance.Highlight = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Highlight(System.Action<Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor> action)
	{
		Instance.Highlight = Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Highlight<T>(System.Action<Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor<T>> action)
	{
		Instance.Highlight = Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Boosts the _score of documents from specified indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor IndicesBoost(System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>>? value)
	{
		Instance.IndicesBoost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Boosts the _score of documents from specified indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor IndicesBoost()
	{
		Instance.IndicesBoost = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfIndexNameDouble.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Boosts the _score of documents from specified indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor IndicesBoost(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfIndexNameDouble>? action)
	{
		Instance.IndicesBoost = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfIndexNameDouble.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor AddIndicesBoost(Elastic.Clients.Elasticsearch.IndexName key, double value)
	{
		Instance.IndicesBoost ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>>();
		Instance.IndicesBoost.Add(new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>(key, value));
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Knn(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.KnnSearch>? value)
	{
		Instance.Knn = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Knn(params Elastic.Clients.Elasticsearch.KnnSearch[] values)
	{
		Instance.Knn = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Knn(params System.Action<Elastic.Clients.Elasticsearch.KnnSearchDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.KnnSearch>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.KnnSearchDescriptor.Build(action));
		}

		Instance.Knn = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Knn<T>(params System.Action<Elastic.Clients.Elasticsearch.KnnSearchDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.KnnSearch>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.KnnSearchDescriptor<T>.Build(action));
		}

		Instance.Knn = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum _score for matching documents. Documents with a lower _score are
	/// not included in search results and results collected by aggregations.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor MinScore(double? value)
	{
		Instance.MinScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limits the search to a point in time (PIT). If you provide a PIT, you
	/// cannot specify an &lt;index> in the request path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Pit(Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReference? value)
	{
		Instance.Pit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limits the search to a point in time (PIT). If you provide a PIT, you
	/// cannot specify an &lt;index> in the request path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Pit(System.Action<Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReferenceDescriptor> action)
	{
		Instance.Pit = Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReferenceDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor PostFilter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.PostFilter = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor PostFilter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.PostFilter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor PostFilter<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.PostFilter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Profile(bool? value = true)
	{
		Instance.Profile = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the search definition using the Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the search definition using the Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the search definition using the Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Query<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Rescore(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.Rescore>? value)
	{
		Instance.Rescore = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Rescore(params Elastic.Clients.Elasticsearch.Core.Search.Rescore[] values)
	{
		Instance.Rescore = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Rescore(params System.Action<Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Core.Search.Rescore>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor.Build(action));
		}

		Instance.Rescore = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Rescore<T>(params System.Action<Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Core.Search.Rescore>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<T>.Build(action));
		}

		Instance.Rescore = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines one or more runtime fields in the search request. These fields take
	/// precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor RuntimeMappings(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.RuntimeMappings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines one or more runtime fields in the search request. These fields take
	/// precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor RuntimeMappings()
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines one or more runtime fields in the search request. These fields take
	/// precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor RuntimeMappings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines one or more runtime fields in the search request. These fields take
	/// precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor RuntimeMappings<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor AddRuntimeMapping<T>(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor ScriptFields(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.ScriptField>? value)
	{
		Instance.ScriptFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor ScriptFields()
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor ScriptFields(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField>? action)
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor AddScriptField(string key, Elastic.Clients.Elasticsearch.ScriptField value)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor AddScriptField(string key, System.Action<Elastic.Clients.Elasticsearch.ScriptFieldDescriptor> action)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, Elastic.Clients.Elasticsearch.ScriptFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor SearchAfter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>? value)
	{
		Instance.SearchAfter = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor SearchAfter(params Elastic.Clients.Elasticsearch.FieldValue[] values)
	{
		Instance.SearchAfter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, returns sequence number and primary term of the last modification
	/// of each hit. See Optimistic concurrency control.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor SeqNoPrimaryTerm(bool? value = true)
	{
		Instance.SeqNoPrimaryTerm = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of hits to return. By default, you cannot page through more
	/// than 10,000 hits using the from and size parameters. To page through more
	/// hits, use the search_after parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Slice(Elastic.Clients.Elasticsearch.SlicedScroll? value)
	{
		Instance.Slice = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Slice(System.Action<Elastic.Clients.Elasticsearch.SlicedScrollDescriptor> action)
	{
		Instance.Slice = Elastic.Clients.Elasticsearch.SlicedScrollDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Slice<T>(System.Action<Elastic.Clients.Elasticsearch.SlicedScrollDescriptor<T>> action)
	{
		Instance.Slice = Elastic.Clients.Elasticsearch.SlicedScrollDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Sort(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? value)
	{
		Instance.Sort = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Sort(params Elastic.Clients.Elasticsearch.SortOptions[] values)
	{
		Instance.Sort = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Sort(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Sort<T>(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor<T>.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates which source fields are returned for matching documents. These
	/// fields are returned in the hits._source property of the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Source(Elastic.Clients.Elasticsearch.Core.Search.SourceConfig? value)
	{
		Instance.Source = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates which source fields are returned for matching documents. These
	/// fields are returned in the hits._source property of the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Source(System.Func<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory, Elastic.Clients.Elasticsearch.Core.Search.SourceConfig> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates which source fields are returned for matching documents. These
	/// fields are returned in the hits._source property of the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Source<T>(System.Func<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory<T>, Elastic.Clients.Elasticsearch.Core.Search.SourceConfig> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Stats groups to associate with the search. Each group maintains a statistics
	/// aggregation for its associated searches. You can retrieve these stats using
	/// the indices stats API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Stats(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Stats = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Stats groups to associate with the search. Each group maintains a statistics
	/// aggregation for its associated searches. You can retrieve these stats using
	/// the indices stats API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Stats(params string[] values)
	{
		Instance.Stats = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// List of stored fields to return as part of a hit. If no fields are specified,
	/// no stored fields are included in the response. If this field is specified, the _source
	/// parameter defaults to false. You can pass _source: true to return both source fields
	/// and stored fields in the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor StoredFields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.StoredFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// List of stored fields to return as part of a hit. If no fields are specified,
	/// no stored fields are included in the response. If this field is specified, the _source
	/// parameter defaults to false. You can pass _source: true to return both source fields
	/// and stored fields in the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor StoredFields<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.StoredFields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Suggest(Elastic.Clients.Elasticsearch.Core.Search.Suggester? value)
	{
		Instance.Suggest = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Suggest()
	{
		Instance.Suggest = Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Suggest(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor>? action)
	{
		Instance.Suggest = Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Suggest<T>(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<T>>? action)
	{
		Instance.Suggest = Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of documents to collect for each shard. If a query reaches this
	/// limit, Elasticsearch terminates the query early. Elasticsearch collects documents
	/// before sorting. Defaults to 0, which does not terminate query execution early.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor TerminateAfter(long? value)
	{
		Instance.TerminateAfter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the period of time to wait for a response from each shard. If no response
	/// is received before the timeout expires, the request fails and returns an error.
	/// Defaults to no timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Timeout(string? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, calculate and return document scores, even if the scores are not used for sorting.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor TrackScores(bool? value = true)
	{
		Instance.TrackScores = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of hits matching the query to count accurately. If true, the exact
	/// number of hits is returned at the cost of some performance. If false, the
	/// response does not include the total number of hits matching the query.
	/// Defaults to 10,000 hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor TrackTotalHits(Elastic.Clients.Elasticsearch.Core.Search.TrackHits? value)
	{
		Instance.TrackTotalHits = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of hits matching the query to count accurately. If true, the exact
	/// number of hits is returned at the cost of some performance. If false, the
	/// response does not include the total number of hits matching the query.
	/// Defaults to 10,000 hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor TrackTotalHits(System.Func<Elastic.Clients.Elasticsearch.Core.Search.TrackHitsFactory, Elastic.Clients.Elasticsearch.Core.Search.TrackHits> action)
	{
		Instance.TrackTotalHits = Elastic.Clients.Elasticsearch.Core.Search.TrackHitsFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, returns document version as part of a hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Version(bool? value = true)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequest Build(System.Action<Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor(new Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Run an async search.
/// </para>
/// <para>
/// When the primary sort of the results is an indexed field, shards get sorted based on minimum and maximum value that they hold for that field. Partial results become available following the sort criteria that was requested.
/// </para>
/// <para>
/// Warning: Asynchronous search does not support scroll or search requests that include only the suggest section.
/// </para>
/// <para>
/// By default, Elasticsearch does not allow you to store an async search response larger than 10Mb and an attempt to do this results in an error.
/// The maximum allowed size for a stored async search response can be set by changing the <c>search.max_async_search_response_size</c> cluster level setting.
/// </para>
/// </summary>
public readonly partial struct SubmitAsyncSearchRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SubmitAsyncSearchRequestDescriptor(Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequest instance)
	{
		Instance = instance;
	}

	public SubmitAsyncSearchRequestDescriptor(Elastic.Clients.Elasticsearch.Indices? indices)
	{
		Instance = new Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequest(indices);
	}

	public SubmitAsyncSearchRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequest instance) => new Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequest(Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A comma-separated list of index names to search; use <c>_all</c> or empty string to perform the operation on all indices
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Indices(Elastic.Clients.Elasticsearch.Indices? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to ignore if a wildcard indices expression resolves into no concrete indices. (This includes <c>_all</c> string or when no indices have been specified)
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> AllowNoIndices(bool? value = true)
	{
		Instance.AllowNoIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicate if an error should be returned if there is a partial search failure or timeout
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> AllowPartialSearchResults(bool? value = true)
	{
		Instance.AllowPartialSearchResults = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The analyzer to use for the query string
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Analyzer(string? value)
	{
		Instance.Analyzer = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify whether wildcard and prefix queries should be analyzed (default: false)
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> AnalyzeWildcard(bool? value = true)
	{
		Instance.AnalyzeWildcard = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Affects how often partial results become available, which happens whenever shard results are reduced.
	/// A partial reduction is performed every time the coordinating node has received a certain number of new shard responses (5 by default).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> BatchedReduceSize(long? value)
	{
		Instance.BatchedReduceSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The default value is the only supported value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> CcsMinimizeRoundtrips(bool? value = true)
	{
		Instance.CcsMinimizeRoundtrips = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The default operator for query string query (AND or OR)
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> DefaultOperator(Elastic.Clients.Elasticsearch.QueryDsl.Operator? value)
	{
		Instance.DefaultOperator = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The field to use as default where no field prefix is given in the query string
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Df(string? value)
	{
		Instance.Df = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to expand wildcard expression to concrete indices that are open, closed or both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> ExpandWildcards(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.ExpandWildcard>? value)
	{
		Instance.ExpandWildcards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether to expand wildcard expression to concrete indices that are open, closed or both.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> ExpandWildcards(params Elastic.Clients.Elasticsearch.ExpandWildcard[] values)
	{
		Instance.ExpandWildcards = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether specified concrete, expanded or aliased indices should be ignored when throttled
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> IgnoreThrottled(bool? value = true)
	{
		Instance.IgnoreThrottled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Whether specified concrete indices should be ignored when unavailable (missing or closed)
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> IgnoreUnavailable(bool? value = true)
	{
		Instance.IgnoreUnavailable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies how long the async search needs to be available.
	/// Ongoing async searches and any saved search results are deleted after this period.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> KeepAlive(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.KeepAlive = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, results are stored for later retrieval when the search completes within the <c>wait_for_completion_timeout</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> KeepOnCompletion(bool? value = true)
	{
		Instance.KeepOnCompletion = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify whether format-based query failures (such as providing text to a numeric field) should be ignored
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Lenient(bool? value = true)
	{
		Instance.Lenient = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of concurrent shard requests per node this search executes concurrently. This value should be used to limit the impact of the search on the cluster in order to limit the number of concurrent shard requests
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> MaxConcurrentShardRequests(int? value)
	{
		Instance.MaxConcurrentShardRequests = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify the node or shard the operation should be performed on (default: random)
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Preference(string? value)
	{
		Instance.Preference = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query in the Lucene query string syntax
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> QueryLuceneSyntax(string? value)
	{
		Instance.QueryLuceneSyntax = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify if request cache should be used for this request or not, defaults to true
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> RequestCache(bool? value = true)
	{
		Instance.RequestCache = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether hits.total should be rendered as an integer or an object in the rest search response
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> RestTotalHitsAsInt(bool? value = true)
	{
		Instance.RestTotalHitsAsInt = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of specific routing values
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Routing(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.Routing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Search operation type
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> SearchType(Elastic.Clients.Elasticsearch.SearchType? value)
	{
		Instance.SearchType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to exclude from the returned _source field
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> SourceExcludes(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.SourceExcludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to exclude from the returned _source field
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> SourceExcludes(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.SourceExcludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to extract and return from the _source field
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> SourceIncludes(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.SourceIncludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of fields to extract and return from the _source field
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> SourceIncludes(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.SourceIncludes = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies which field to use for suggestions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> SuggestField(Elastic.Clients.Elasticsearch.Field? value)
	{
		Instance.SuggestField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies which field to use for suggestions.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> SuggestField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.SuggestField = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify suggest mode
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> SuggestMode(Elastic.Clients.Elasticsearch.SuggestMode? value)
	{
		Instance.SuggestMode = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// How many suggestions to return in response
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> SuggestSize(long? value)
	{
		Instance.SuggestSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The source text for which the suggestions should be returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> SuggestText(string? value)
	{
		Instance.SuggestText = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specify whether aggregation and suggester names should be prefixed by their respective types in the response
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> TypedKeys(bool? value = true)
	{
		Instance.TypedKeys = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Blocks and waits until the search is completed up to a certain timeout.
	/// When the async search completes within the timeout, the response won’t include the ID as the results are not stored in the cluster.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> WaitForCompletionTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.WaitForCompletionTimeout = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Aggregations(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>? value)
	{
		Instance.Aggregations = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Aggregations()
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Aggregations(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<TDocument>>? action)
	{
		Instance.Aggregations = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringAggregation<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> AddAggregation(string key, Elastic.Clients.Elasticsearch.Aggregations.Aggregation value)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> AddAggregation(string key, System.Action<Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<TDocument>> action)
	{
		Instance.Aggregations ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Aggregations.Aggregation>();
		Instance.Aggregations.Add(key, Elastic.Clients.Elasticsearch.Aggregations.AggregationDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Collapse(Elastic.Clients.Elasticsearch.Core.Search.FieldCollapse? value)
	{
		Instance.Collapse = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Collapse(System.Action<Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor<TDocument>> action)
	{
		Instance.Collapse = Elastic.Clients.Elasticsearch.Core.Search.FieldCollapseDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The request returns doc values for field
	/// names matching these patterns in the hits.fields property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> DocvalueFields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? value)
	{
		Instance.DocvalueFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The request returns doc values for field
	/// names matching these patterns in the hits.fields property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> DocvalueFields(params Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat[] values)
	{
		Instance.DocvalueFields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The request returns doc values for field
	/// names matching these patterns in the hits.fields property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> DocvalueFields(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>.Build(action));
		}

		Instance.DocvalueFields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, returns detailed information about score computation as part of a hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Explain(bool? value = true)
	{
		Instance.Explain = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Ext(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Ext = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Ext()
	{
		Instance.Ext = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration of search extensions defined by Elasticsearch plugins.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Ext(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Ext = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> AddExt(string key, object value)
	{
		Instance.Ext ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Ext.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The request returns values for field names
	/// matching these patterns in the hits.fields property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Fields(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>? value)
	{
		Instance.Fields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The request returns values for field names
	/// matching these patterns in the hits.fields property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Fields(params Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat[] values)
	{
		Instance.Fields = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of wildcard (*) patterns. The request returns values for field names
	/// matching these patterns in the hits.fields property of the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Fields(params System.Action<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormat>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.QueryDsl.FieldAndFormatDescriptor<TDocument>.Build(action));
		}

		Instance.Fields = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Starting document offset. By default, you cannot page through more than 10,000
	/// hits using the from and size parameters. To page through more hits, use the
	/// search_after parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> From(int? value)
	{
		Instance.From = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Highlight(Elastic.Clients.Elasticsearch.Core.Search.Highlight? value)
	{
		Instance.Highlight = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Highlight(System.Action<Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor<TDocument>> action)
	{
		Instance.Highlight = Elastic.Clients.Elasticsearch.Core.Search.HighlightDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Boosts the _score of documents from specified indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> IndicesBoost(System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>>? value)
	{
		Instance.IndicesBoost = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Boosts the _score of documents from specified indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> IndicesBoost()
	{
		Instance.IndicesBoost = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfIndexNameDouble.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Boosts the _score of documents from specified indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> IndicesBoost(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfIndexNameDouble>? action)
	{
		Instance.IndicesBoost = Elastic.Clients.Elasticsearch.Fluent.FluentCollectionOfKeyValuePairOfIndexNameDouble.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> AddIndicesBoost(Elastic.Clients.Elasticsearch.IndexName key, double value)
	{
		Instance.IndicesBoost ??= new System.Collections.Generic.List<System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>>();
		Instance.IndicesBoost.Add(new System.Collections.Generic.KeyValuePair<Elastic.Clients.Elasticsearch.IndexName, double>(key, value));
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Knn(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.KnnSearch>? value)
	{
		Instance.Knn = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Knn(params Elastic.Clients.Elasticsearch.KnnSearch[] values)
	{
		Instance.Knn = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the approximate kNN search to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Knn(params System.Action<Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.KnnSearch>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.KnnSearchDescriptor<TDocument>.Build(action));
		}

		Instance.Knn = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum _score for matching documents. Documents with a lower _score are
	/// not included in search results and results collected by aggregations.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> MinScore(double? value)
	{
		Instance.MinScore = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limits the search to a point in time (PIT). If you provide a PIT, you
	/// cannot specify an &lt;index> in the request path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Pit(Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReference? value)
	{
		Instance.Pit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Limits the search to a point in time (PIT). If you provide a PIT, you
	/// cannot specify an &lt;index> in the request path.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Pit(System.Action<Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReferenceDescriptor> action)
	{
		Instance.Pit = Elastic.Clients.Elasticsearch.Core.Search.PointInTimeReferenceDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> PostFilter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.PostFilter = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> PostFilter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.PostFilter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Profile(bool? value = true)
	{
		Instance.Profile = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the search definition using the Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines the search definition using the Query DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Rescore(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Core.Search.Rescore>? value)
	{
		Instance.Rescore = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Rescore(params Elastic.Clients.Elasticsearch.Core.Search.Rescore[] values)
	{
		Instance.Rescore = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Rescore(params System.Action<Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Core.Search.Rescore>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Core.Search.RescoreDescriptor<TDocument>.Build(action));
		}

		Instance.Rescore = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines one or more runtime fields in the search request. These fields take
	/// precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> RuntimeMappings(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.RuntimeMappings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines one or more runtime fields in the search request. These fields take
	/// precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> RuntimeMappings()
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Defines one or more runtime fields in the search request. These fields take
	/// precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> RuntimeMappings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> AddRuntimeMapping(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> AddRuntimeMapping(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> ScriptFields(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.ScriptField>? value)
	{
		Instance.ScriptFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> ScriptFields()
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Retrieve a script evaluation (based on different fields) for each hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> ScriptFields(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField>? action)
	{
		Instance.ScriptFields = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringScriptField.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> AddScriptField(string key, Elastic.Clients.Elasticsearch.ScriptField value)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> AddScriptField(string key, System.Action<Elastic.Clients.Elasticsearch.ScriptFieldDescriptor> action)
	{
		Instance.ScriptFields ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.ScriptField>();
		Instance.ScriptFields.Add(key, Elastic.Clients.Elasticsearch.ScriptFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> SearchAfter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>? value)
	{
		Instance.SearchAfter = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> SearchAfter(params Elastic.Clients.Elasticsearch.FieldValue[] values)
	{
		Instance.SearchAfter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, returns sequence number and primary term of the last modification
	/// of each hit. See Optimistic concurrency control.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> SeqNoPrimaryTerm(bool? value = true)
	{
		Instance.SeqNoPrimaryTerm = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of hits to return. By default, you cannot page through more
	/// than 10,000 hits using the from and size parameters. To page through more
	/// hits, use the search_after parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Slice(Elastic.Clients.Elasticsearch.SlicedScroll? value)
	{
		Instance.Slice = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Slice(System.Action<Elastic.Clients.Elasticsearch.SlicedScrollDescriptor<TDocument>> action)
	{
		Instance.Slice = Elastic.Clients.Elasticsearch.SlicedScrollDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Sort(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? value)
	{
		Instance.Sort = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Sort(params Elastic.Clients.Elasticsearch.SortOptions[] values)
	{
		Instance.Sort = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Sort(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates which source fields are returned for matching documents. These
	/// fields are returned in the hits._source property of the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Source(Elastic.Clients.Elasticsearch.Core.Search.SourceConfig? value)
	{
		Instance.Source = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates which source fields are returned for matching documents. These
	/// fields are returned in the hits._source property of the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Source(System.Func<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory<TDocument>, Elastic.Clients.Elasticsearch.Core.Search.SourceConfig> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Stats groups to associate with the search. Each group maintains a statistics
	/// aggregation for its associated searches. You can retrieve these stats using
	/// the indices stats API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Stats(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Stats = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Stats groups to associate with the search. Each group maintains a statistics
	/// aggregation for its associated searches. You can retrieve these stats using
	/// the indices stats API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Stats(params string[] values)
	{
		Instance.Stats = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// List of stored fields to return as part of a hit. If no fields are specified,
	/// no stored fields are included in the response. If this field is specified, the _source
	/// parameter defaults to false. You can pass _source: true to return both source fields
	/// and stored fields in the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> StoredFields(Elastic.Clients.Elasticsearch.Fields? value)
	{
		Instance.StoredFields = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// List of stored fields to return as part of a hit. If no fields are specified,
	/// no stored fields are included in the response. If this field is specified, the _source
	/// parameter defaults to false. You can pass _source: true to return both source fields
	/// and stored fields in the search response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> StoredFields(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.StoredFields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Suggest(Elastic.Clients.Elasticsearch.Core.Search.Suggester? value)
	{
		Instance.Suggest = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Suggest()
	{
		Instance.Suggest = Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Suggest(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument>>? action)
	{
		Instance.Suggest = Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Maximum number of documents to collect for each shard. If a query reaches this
	/// limit, Elasticsearch terminates the query early. Elasticsearch collects documents
	/// before sorting. Defaults to 0, which does not terminate query execution early.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> TerminateAfter(long? value)
	{
		Instance.TerminateAfter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the period of time to wait for a response from each shard. If no response
	/// is received before the timeout expires, the request fails and returns an error.
	/// Defaults to no timeout.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Timeout(string? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, calculate and return document scores, even if the scores are not used for sorting.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> TrackScores(bool? value = true)
	{
		Instance.TrackScores = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of hits matching the query to count accurately. If true, the exact
	/// number of hits is returned at the cost of some performance. If false, the
	/// response does not include the total number of hits matching the query.
	/// Defaults to 10,000 hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> TrackTotalHits(Elastic.Clients.Elasticsearch.Core.Search.TrackHits? value)
	{
		Instance.TrackTotalHits = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Number of hits matching the query to count accurately. If true, the exact
	/// number of hits is returned at the cost of some performance. If false, the
	/// response does not include the total number of hits matching the query.
	/// Defaults to 10,000 hits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> TrackTotalHits(System.Func<Elastic.Clients.Elasticsearch.Core.Search.TrackHitsFactory, Elastic.Clients.Elasticsearch.Core.Search.TrackHits> action)
	{
		Instance.TrackTotalHits = Elastic.Clients.Elasticsearch.Core.Search.TrackHitsFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If true, returns document version as part of a hit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Version(bool? value = true)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequest Build(System.Action<Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.AsyncSearch.SubmitAsyncSearchRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}